----------------------------------------------------------------------------------
-- Company: www.simong.se
-- Engineer: Simon Gustafsson
-- 
-- Create Date:    18:20:37 12/12/2009 
-- Design Name: 
-- Module Name:    uart_tx - rtl
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
--   Transmitting UART
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
-- Copyright (c) 2009 Simon Gustafsson (www.simong.se)
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity uart_tx is
    generic( baudrate:positive:=115200;
				 F:positive:=48000000 );
    Port ( 
		resetn : in STD_LOGIC;
		clk : in std_logic;
		txd : out  STD_LOGIC;
        uart_txd : in  STD_LOGIC_VECTOR (7 downto 0);
        uart_txd_empty : out  STD_LOGIC;
        uart_txd_start : in std_logic
        );
end uart_tx;

architecture rtl of uart_tx is

--component declarations
component delays
	generic (cycles:positive:=10);
	port ( clk : in std_logic;
			 resetn : in std_logic;
			 timeout : out std_logic);
end component;

for U1:delays use entity work.delays(rtl); -- used by TX UART

signal uart_tx_cnt : std_logic_vector(3 downto 0);
signal delay_resetn_tx : std_logic;
signal delay_timed_out_tx : std_logic;
constant bitcycles:positive := F/baudrate;

begin
	U1:delays generic map(cycles=>bitcycles) port map(clk=>clk, resetn=>delay_resetn_tx, timeout=>delay_timed_out_tx  );
	
	-- for transmission of serial data
	-- Whenever uart_rxd_full is set, starts transmission of uart_rxd
	process(clk,resetn)
	variable tosend: std_logic_vector(7 downto 0);
	begin
	if resetn='0' then
		uart_tx_cnt <= (others=>'1');
		txd <= '1';
		delay_resetn_tx <= '0';
		uart_txd_empty <= '1';
	elsif rising_edge(clk) then
		if uart_txd_start='1' or uart_tx_cnt/="1111" then
			case uart_tx_cnt is
				when "1111" => tosend:=uart_txd;
									txd <= '0'; --start bit
									delay_resetn_tx<='0';
									uart_tx_cnt <= "0000";
									uart_txd_empty <= '0';
									
				when "1000" => if delay_timed_out_tx='1' then
										uart_tx_cnt <= uart_tx_cnt+1;
										txd <= '1'; --stop bit
										delay_resetn_tx<='0';
									else
										delay_resetn_tx<='1';
									end if;
									
				when "1001" => if delay_timed_out_tx='1' then
										uart_tx_cnt <= "1111"; --we are finished
										uart_txd_empty<='1';
									else
										delay_resetn_tx<='1';
									end if;
									
				when "1010" | "1011" | "1100" | "1101" | "1110" =>
									uart_tx_cnt <= "1111";
									uart_txd_empty<='1';
									delay_resetn_tx<='1';
				when others =>
									if delay_timed_out_tx='1' then
										uart_tx_cnt <= uart_tx_cnt+1;
										txd <= tosend( CONV_INTEGER(uart_tx_cnt) );
										delay_resetn_tx<='0';
									else
										delay_resetn_tx<='1';
									end if;
			end case;
--		elsif uart_tx_cnt="1111" then
--			uart_txd_empty<='1';
		end if;
	end if;
	end process;
	
end rtl;

