
--------------------------------------------------------------------------------
-- Company: www.simong.se
-- Engineer: Simon Gustafsson
--
-- Create Date:   21:00:02 08/25/2008
-- Design Name:   freq_generator
-- Module Name:   C:/Users/simon/Documents/programming/VHDL/freq_generator/testbench.vhd
-- Project Name:  freq_generator
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: freq_generator
--
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- Copyright (c) 2009 Simon Gustafsson (www.simong.se)
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends 
-- that these types always be used for the top-level I/O of a design in order 
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;

USE std.textio.ALL; -- for file access read, readline, write, writeline ...
USE ieee.std_logic_arith.ALL; -- for function conv_std_logic_vector(arg:integer; size:integer) return std_logic_vector

ENTITY testbench_vhd IS
END testbench_vhd;

ARCHITECTURE behavior OF testbench_vhd IS 

	-- Component Declaration for the Unit Under Test (UUT)
	COMPONENT freq_generator
	PORT(
		clk_ext : IN std_logic;
		rxd : IN std_logic;
		test : IN std_logic_vector(2 downto 0);          
		txd : OUT std_logic;
		waveout : OUT std_logic_vector(7 downto 0);
		pwm_out : out std_logic;
		leds : out STD_LOGIC_VECTOR (3 downto 0);
		reset : in std_logic;
		RS232_Rx_debug_out : out std_logic
		);
	END COMPONENT;

	--Inputs
	SIGNAL clk :  std_logic := '1';
	SIGNAL rxd :  std_logic := '0';
	SIGNAL test :  std_logic_vector(2 downto 0) := (others=>'0');
	signal reset : std_logic :='0';

	--Outputs
	SIGNAL txd :  std_logic;
	SIGNAL waveout :  std_logic_vector(7 downto 0);
	SIGNAL pwm_out : std_logic;
	SIGNAL leds :  std_logic_vector(3 downto 0);
	SIGNAL RS232_Rx_debug_out : std_logic;

	-- Constants
	constant T:time := 62.5 ns;        -- CLK period time
	constant T_2:time := T/2;        -- CLK Half period time
	constant F:integer := 16000000; -- CLK frequency
	
	
	signal resetn:std_logic;
BEGIN

	process(clk,resetn)
	begin
		reset <= not resetn;
	end process;

	-- Instantiate the Unit Under Test (UUT)
	uut: freq_generator PORT MAP(
		clk_ext => clk,
		txd => txd,
		rxd => rxd,
		waveout => waveout,
		pwm_out => pwm_out,
		leds => leds,
		test => test,
		reset => reset,
		RS232_Rx_debug_out => RS232_Rx_debug_out
	);

	tb : PROCESS
	BEGIN
		resetn<='0';
		wait for 200 ns;	-- Wait 200 ns for global reset to finish
		resetn<='1';

		-- Place stimulus here
		
		test<=( 0=>'1', others=>'0' ); -- triangular wave (as of now)
		
		wait for 1000 ns;
		
		test <= (others=>'0');
		
		--test<=( 1=>'1', others=>'0' ); --square wave (as of now)
		
		
		--test <= ( 2=>'1', others=>'0' ); -- Use waveform from UART

		wait; -- will wait forever
	END PROCESS;
	
	
	clk_toggler: process
	begin
		wait for T_2;
		clk <= not clk;
	end process;
	
	
	rxd_toggler:process
	constant baudrate:integer := 115200;--115200;
	constant bittime:time := 8611 ns; --(F*T)/baudrate;
	variable text_line:line; -- stores one line of text at a time (from my_file)
	variable my_char: character;
	file my_file: text open read_mode is "my_serial_input.txt";
	variable char_as_vector: std_logic_vector(7 downto 0);
	begin
		rxd <= '1';
		wait for 500 ns;
		
		while not endfile(my_file) loop
			readline(my_file, text_line); -- reads one line from file into text_line

			if text_line'length /= 0 then
				for char_counter in 1 to text_line'length loop
					
					my_char := text_line(char_counter);
					
					char_as_vector := conv_std_logic_vector(character'pos(my_char),8);
				
					
					-- Start bit (assumes rxd high previously)
					rxd <= '0';
					wait for bittime;
				
					-- Eight data bits (LSB first)
					for i in 0 to 7 loop
						rxd <= char_as_vector(i);
						wait for bittime;
					end loop;
					
					rxd<='1'; --stop bit
					wait for bittime;
	
	
					wait for 3*bittime; --To separate characters (useful when debugging)
				end loop; --for char_counter...
			end if;
			
			--Send newline (LF, 0x0A)
			char_as_vector := "00001010";
			rxd <= '0';
			wait for bittime;
		
			-- Eight data bits (LSB first)
			for i in 0 to 7 loop
				rxd <= char_as_vector(i);
				wait for bittime;
			end loop;
			
			rxd<='1'; --stop bit
			wait for bittime;

			wait for 5*bittime; --To separate characters (useful when debugging)
			
			
			
			wait for 10*bittime; -- Separate lines additionally (useful when debugging)
		end loop;
	end process;
	

END;
