----------------------------------------------------------------------------------
-- Company: www.simong.se
-- Engineer: Simon Gustafsson
-- 
-- Create Date:    21:24:32 09/15/2008 
-- Design Name: 
-- Module Name:    my_ram - rtl 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
-- Copyright (c) 2009 Simon Gustafsson (www.simong.se)
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity my_ram is
	generic( addr_width:positive:=8; data_width:positive:=8 );
	port(addr: in std_logic_vector(addr_width-1 downto 0);
	clk,we_n: in std_logic;
	din:in std_logic_vector(data_width-1 downto 0);
	dout:out std_logic_vector(data_width-1 downto 0));
end;

architecture rtl of my_ram is
type ram_type is array((2**addr_width)-1 downto 0) of std_logic_vector(data_width-1 downto 0);
signal ram_array:ram_type:=(others=>(others=>'0')); -- Clear ram at startup (only for simulator)
begin
	process(clk)
	begin
		if rising_edge(clk) then
			if we_n='0' then
				ram_array(conv_integer(addr))<=din;
			end if;
			dout <= ram_array(conv_integer(addr));		
		end if;
	end process;
end;
