%
% Simulating a delta sigma DAC
%
% Should be invoked by octave, not matlab
%
% Copyright (c) 2009 Simon Gustafsson (www.simong.se)


f_in=100000;
fs=12e6%44100*16;
t=0:(1/fs):(2*pi/f_in);

in = 128*(1+sin(t.*f_in)); %between 0 and 255

out = zeros(size(in));
err = zeros(size(in));
integrated_err = zeros(size(in));
delta = zeros(size(in));

integrated_err(1)=255;

subplot(4,1,1);
plot(in,".;in;");

for n=2:length(t),
 delta(n) = (in(n) - err(n-1)); % from -255 to 255
 integrated_err(n) = delta(n) + integrated_err(n-1);
 out(n)=integrated_err(n)>=255;
 err(n)=255*out(n);
end

subplot(4,1,2);
plot(delta,";delta;");

subplot(4,1,3);
plot(integrated_err,";integrated err;");

subplot(4,1,4);
stairs(out);
axis([0 length(in) -0.1 1.1 0 1]);
