----------------------------------------------------------------------------------
-- Company: www.simong.se
-- Engineer: Simon Gustafsson
-- 
-- Create Date:    21:19:26 09/15/2008 
-- Design Name: 
-- Module Name:    delay - rtl 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
-- Copyright (c) 2009 Simon Gustafsson (www.simong.se)
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;



entity delays is
	generic (cycles:positive:=10);
	port ( clk : in std_logic;
			 resetn : in std_logic;
			 timeout : out std_logic);
end delays;


architecture rtl of delays is
signal cntr:std_logic_vector(19 downto 0);
begin
	process(clk,resetn)
	begin
		if resetn='0' then
			timeout<='0';
			cntr<=(others=>'0');
		elsif rising_edge(clk) then
			if cntr=cycles then
				timeout<='1';
			else
				cntr <= cntr+1;
			end if;
		end if;
	end process;	
end;
