----------------------------------------------------------------------------------
-- Company: www.simong.se
-- Engineer: Simon Gustafsson
-- 
-- Create Date:    20:20:34 12/12/2009 
-- Design Name: 
-- Module Name:    dac - rtl 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
--   A first order delta-sigma DAC
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
-- Copyright (c) 2009 Simon Gustafsson (www.simong.se)
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_SIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity dac is
	port(
		resetn : in std_logic;
		clk : in std_logic;
		data : in std_logic_vector(7 downto 0);
		pwm_out : out std_logic
		);
end dac;

architecture rtl of dac is
signal integrated:integer range -255 to 512;
signal clk_daq:std_logic;
signal cntr:std_logic_vector(5 downto 0);
signal dout:std_logic;
begin

	-- To prevent obsessive oversampling (by a factor of around 1000)
	process(clk,resetn)
	begin
		if resetn='0' then
			clk_daq <= '0';
			cntr <= (others=>'0');
		elsif rising_edge(clk) then
			clk_daq <= cntr(2);
			cntr <= cntr+1;
		end if;
	end process;


	process(clk_daq, resetn)
	variable delta:integer range -255 to 255;
	begin
		if resetn='0' then
			integrated<=255;
			delta := 0;
			pwm_out <='0';
		-- Xilinx died on this (maybe because clk not in sensitivity list): elsif clk'event and clk='1' and clk_daq'event and clk_daq='1' then
		elsif rising_edge(clk_daq) then
			if dout='1' then
				delta := CONV_INTEGER(("0"&data)) - 255;
			else
				delta := CONV_INTEGER(("0"&data));
			end if;
			integrated <= delta + integrated;			
			if integrated > 255 then
				pwm_out <= '1';
				dout <= '1';
			else
				pwm_out <= '0';
				dout <= '0';
			end if;
		end if;
	end process;
	
end rtl;

