#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <syslog.h>
#include <errno.h> //for errno...

using namespace std;

int fd = -1;
int fifofd = -1;
int state = 0;

int continuous=0;
char command=0;
const char* pipename="/home/simon/command_pipe";

/*
från "http://www.erlenstar.demon.co.uk/unix/faq_3.html#SEC40":

2.10 What can I do with named pipes (FIFOs)?
2.10.1 What is a named pipe?
2.10.2 How do I create a named pipe?
2.10.3 How do I use a named pipe?
*/


/*
Från "http://www.erlenstar.demon.co.uk/unix/faq_2.html":

1.7 How do I get my program to act like a daemon?

A daemon process is usually defined as a background process that does not belong to a terminal session. Many system services are performed by daemons; network services, printing etc.

Simply invoking a program in the background isn't really adequate for these long-running programs; that does not correctly detach the process from the terminal session that started it. Also, the conventional way of starting daemons is simply to issue the command manually or from an rc script; the daemon is expected to put itself into the background.

Here are the steps to become a daemon:

   1. fork() so the parent can exit, this returns control to the command line or shell invoking your program. This step is required so that the new process is guaranteed not to be a process group leader. The next step, setsid(), fails if you're a process group leader.
   2. setsid() to become a process group and session group leader. Since a controlling terminal is associated with a session, and this new session has not yet acquired a controlling terminal our process now has no controlling terminal, which is a Good Thing for daemons.
   3. fork() again so the parent, (the session group leader), can exit. This means that we, as a non-session group leader, can never regain a controlling terminal.
   4. chdir("/") to ensure that our process doesn't keep any directory in use. Failure to do this could make it so that an administrator couldn't unmount a filesystem, because it was our current directory. [Equivalently, we could change to any directory containing files important to the daemon's operation.]
   5. umask(0) so that we have complete control over the permissions of anything we write. We don't know what umask we may have inherited. [This step is optional]
   6. close() fds 0, 1, and 2. This releases the standard in, out, and error we inherited from our parent process. We have no way of knowing where these fds might have been redirected to. Note that many daemons use sysconf() to determine the limit _SC_OPEN_MAX. _SC_OPEN_MAX tells you the maximun open files/process. Then in a loop, the daemon can close all possible file descriptors. You have to decide if you need to do this or not. If you think that there might be file-descriptors open you should close them, since there's a limit on number of concurrent file descriptors.
   7. Establish new open descriptors for stdin, stdout and stderr. Even if you don't plan to use them, it is still a good idea to have them open. The precise handling of these is a matter of taste; if you have a logfile, for example, you might wish to open it as stdout or stderr, and open `/dev/null' as stdin; alternatively, you could open `/dev/console' as stderr and/or stdout, and `/dev/null' as stdin, or any other combination that makes sense for your particular daemon. 

Almost none of this is necessary (or advisable) if your daemon is being started by inetd. In that case, stdin, stdout and stderr are all set up for you to refer to the network connection, and the fork()s and session manipulation should not be done (to avoid confusing inetd). Only the chdir() and umask() steps remain as useful. 

*/

/*
Från "http://www.linuxjournal.com/article/2335"
Use the getrlimit() call to determine the maximum number of open file descriptors and to close them.
*/

/*
I have a solution for the *nix world, but windows is a different matter, it tends to not follow the ANSI standard so some of the system dependant calls are implemented different according to which compiler is beeing used.

*nix ei:

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>

//
// Just a simple deamon making function, as suggested in
// Unix Network programming, second edition.
// fork() and close() all file descriptors with
// stderr/stdout/stdin/etc, and finaly chroot your
// self to be running on your own.
//

void deamon_init(const char* pname, int facility)
{
int i;
unsigned long pid;
if((pid=fork())!=0)
exit(0);
setsid();
signal( SIGHUP, SIG_IGN );
if( ( pid=fork() )!=0)
exit(0);
chdir("/");
umask(0);
for(i=0; i < MAXFD; i++)
close(i);
}

int main(int argv, char* argc[])
{
deamon_init(argv[0],0);
//
// rest of program will have no access to stdin/stdout/stderr
// And will only appear when the OS is questioned for hidden
// processes
//
sleep(50);
return 0;
}
*/



/*
  set modem control lines RTS and DTR according to state, where
  state=a*TIOCM_RTS | b*TIOCM_DTR
  a and b should be either 0 or 1.
*/
int setLines(int state){
  int rc;
  int faultfree=1;
  int tmp=TIOCM_RTS;

  switch(state & TIOCM_RTS){
  case 0:
    rc = ioctl(fd, TIOCMBIC, &tmp);
    if (rc < 0){
      int err = errno;
      cerr << "Error lowering RTS (" << rc << "); ";
      cerr << "reported error: " << strerror(err) << endl;
      faultfree=0;
    }else {
      cout << "RTS=0 ";
    }
    break;
  case TIOCM_RTS:
    rc = ioctl(fd, TIOCMBIS, &tmp);
    if(rc < 0) {
      int err = errno;
      cerr << "Error raising RTS (" << rc << "); ";
      cerr << "reported error: " << strerror(err) << endl;
      faultfree=0;
    }else {
      cout << "RTS=1 ";
    }
  }

  tmp=TIOCM_DTR;
  switch(state & TIOCM_DTR){
  case 0:
    rc = ioctl(fd, TIOCMBIC, &tmp);
    if (rc < 0){
      int err = errno;
      cerr << "Error lowering DTR (" << rc << "); ";
      cerr << "reported error: " << strerror(err) << endl;
      faultfree=0;
    }else{
      cout << "DTR=0 ";
    }
    break;
  case TIOCM_DTR:
    rc = ioctl(fd, TIOCMBIS, &tmp);
    if(rc < 0) {
      int err = errno;
      cerr << "Error raising DTR (" << rc << "); ";
      cerr << "reported error: " << strerror(err) << endl;
      faultfree=0;
    }else {
      cout << "DTR=1 ";
    }
  }
  cout << endl;
  return faultfree;
}

int parsecommand(char command){
  int state;
  switch(command){
    case '0' : state=0; break;
    case '1' : state=TIOCM_RTS; break;
    case '2' : state=TIOCM_DTR; break;
    case '3' : state=TIOCM_RTS|TIOCM_DTR; break;
    case 'F' : 
    case 'f' : state=TIOCM_DTR; break;
    case 'S' :
    case 's' : state=TIOCM_RTS|TIOCM_DTR; break;
    case 'N' :
    case 'n' : state=0; break;
    default  : state=-1;
  }
  return state;
}

int old_disc;           /* original line discipline */

int openSerial(char * device ){
  /*
    RDRW - läs och skriv,
    NONBLOCK returnerar direkt (väntar annars på DCD)
  */

  fd = open(device, O_NONBLOCK | O_RDWR);
  if (fd<0){
    int err = errno;
    cerr << "couldn't open serial port \"" << device << "\" (fd=" << fd << ")" << endl
         << "reported error: " << strerror(err) << endl
	 << "try for instance \"setserial /dev/ttyS0 Baud_base 9600 UART 16550A\"" << endl;
    return -1;
  }
  
  /* get current line discipline */
  int rc = ioctl(fd, TIOCGETD, &old_disc);
  if(rc < 0) {
    int err = errno;
    cerr << "reported error: " << strerror(err) << endl;
    /* handle error */
  }

  /* set device to blocking mode for reads and writes */
  
  fcntl(fd, F_SETFL, fcntl(fd,F_GETFL) & ~O_NONBLOCK);
  return 0;
}

int closeSerial(){
  /* restore original line discipline */
  
  int rc = ioctl(fd, TIOCSETD, &old_disc);
  if(rc < 0) {
    int err = errno;
    cerr << "reported error: " << strerror(err) << endl;
  }

  rc = close(fd); //Close serial device
  if(rc < 0) {
    int err = errno;
    cerr << "reported error: " << strerror(err) << endl;
  }

  return 0;
}

void handleSTDIN(char * device){
  if(openSerial(device)<0){
     return;
  };
  continuous=1;
  do{
    if( std::cin.good() ){
      cin >> command;
      state=parsecommand(command);
      if(state!=-1){
	setLines(state); //FIXME USE RETURN VALUE
      }else{
	//FIXME NOW THERE SHOULD BE AN ERROR
	if((command=='q') || (command=='Q')){
	  //nothing special, just quit...
	}else{
	  cerr << "Invalid command \"" << command << "\", exiting immediately" << endl;
	}
	continuous=0;
      }
    }else{
      //when !std::cin.good()
      continuous=0;
    }
  }while(continuous);
  closeSerial();
}



void handlePipe(char * device){
  if(openSerial(device)<0){
    return;
  };
  mode_t oldumask = umask(0);
  int did_i_create_fifo = mkfifo(pipename, S_IWUSR | S_IRUSR | S_IWGRP | S_IWOTH); //Set pipe writable by anyone
  if(did_i_create_fifo<0){
    int err = errno;
    cerr << "mkfifo NOT successfull!" << endl;
    cerr << "reported error: " << strerror(err) << endl
	 << "Quitting" << endl;
    closeSerial();
    return;
  }
  umask(oldumask); //restore umask
  continuous=1;
  fifofd = open (pipename, O_RDONLY); //Read only
  //FIFOS: http://www-128.ibm.com/developerworks/linux/library/l-osmig2.html


  do{  
    ssize_t readsize = read(fifofd,&command, 1);
    if(readsize<=0){ 
      if(readsize==-1){
	int err=errno;
	cerr << "read NOT successfull!" << endl;
	cerr << "reported error: " << strerror(err) << endl
	 << "Quitting" << endl;
      }
      continuous=0; 
    }else{
      state=parsecommand(command);
      if(state!=-1){
	setLines(state);
      }else{
	if( (command=='\n') || (command == '\r')) {
	  //do nothing until new command...
	}else{
	  if( (command=='q') || (command=='Q')) { continuous=0; }
	  else { cerr << "Invalid command \"" << command << "\" from pipe. Continuing..." << endl; }
	}
      }
    }
  }while(continuous);
  close(fifofd);
  if (did_i_create_fifo>=0) { 
    unlink(pipename); 
  }
  closeSerial();
}

int main(int argc, char* argv[]){

  if(argc != 3){
    cout << "usage: " << argv[0] << " /dev/ttyS0 option" << endl
	 << endl
	 << "options: N = normal (40  kohm)" << endl
	 << "         F = focus  (4,7 kohm)" << endl
	 << "         S = Snap   (2.0 kohm)" << endl
	 << "         Q = Quit without doing anything more" << endl
	 << "         - = use standard input for reading commands" << endl
	 << "             each command should be on its own line" << endl
         << "         p = create pipe to listen to commands from" << endl
	 << "         d = become a daemon, create pipe for commands"
         << endl
         << "         D = become a daemon, create pipe for commands," << endl
         << "             but keep writing results to the console" << endl;
    return 1;
  }

  if( argc == 3 && ( argv[2][1] == 0 ) ){ //two options, second one only one char
    command=argv[2][0];
int tmp;
    switch(command){
    case '-': handleSTDIN(argv[1]); break;
    case 'P' :
    case 'p' :	handlePipe(argv[1]); break;
    case 'd' :
      tmp = daemon(0,0); //true daemon, its only connection to the outside world is the pipe
      if(tmp==0){
        openlog(argv[0], LOG_CONS, LOG_USER);
        syslog(LOG_INFO,"%s","FZ20 remote daemon started");
        handlePipe(argv[1]);
        syslog(LOG_INFO,"%s","FZ20 remote daemon stopped");
      }else{
        syslog(LOG_ERR,"%s","error starting FZ20 remote daemon");
        cerr << "Unable to run as a daemon, will return immediately!" << endl;
      }
      break;
    case 'D' :
      tmp = daemon(0,1); //int daemon(int nochdir, int noclose)
      if(tmp==0){
        cout << "Running as a daemon now..." << endl;
        handlePipe(argv[1]);
	cout << "Quitting my job as a daemon..." << endl;
      }else{
	int err=errno;
        cerr << "Unable to run as a daemon, will return immediately!" << endl;
        cerr << "reported error: " << strerror(err) << endl;
      }
      break;
    case 'q':
    case 'Q': return 0; break;
    default: if (parsecommand(command)!=-1) {
      openSerial(argv[1]);
      setLines(parsecommand(command));
      usleep(250); //Sleep for a little while...
      closeSerial();
    }else{
      cout << "INVALID argument supplied. Will return immediately!" 
	   << endl;
      }
    }
  } 
  return 0;
}
