/*
Generates a string of characters to stdout whos duration is
determined by command line parameters. The programs output could
be redirected to my seriald program to control the FZ20 camera.

Copyright(c) 2005 Simon Gustafsson

Usage examples:
Ex 1.
  Piping directly 
  "./intervall 5 1 0.25 | ./seriald /dev/ttyS0 -"

Ex 2.
  Running seriald as a daemon, piping to its fifo
  "./seriald /dev/ttyS0 d" 
  "./intervall 5 1 0.25 > pipe"


*/

#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <math.h>

using namespace std;

timespec prefocus;

itimerval inext;
itimerval ifocustime;
itimerval ishuttertime;
itimerval iiddletime;
char state;

void sigtrap(int signo){
  switch(state){
  case 'f':  
    inext=ifocustime;
    setitimer(ITIMER_REAL,&inext,0);
    cout << 'f'<<endl;
    state='s';
    break;
  case 's':
    inext=ishuttertime;
    setitimer(ITIMER_REAL,&inext,0);
    cout << 's' << endl;
    state='n';
    break;
  case 'n':
    inext=iiddletime;
    setitimer(ITIMER_REAL,&inext,0);
    cout << 'n' << endl;
    state='f';
    break;
  case 'S':
    inext=ishuttertime;
    setitimer(ITIMER_REAL,&inext,0);
    cout << 's' << endl;
    state='N';
    break;
  case 'N':
    inext=iiddletime;
    setitimer(ITIMER_REAL,&inext,0);
    cout << 'n' << endl;
    state='S';
    break;
  }
}

int main(int argc, char* argv[]){

  memset(&inext,0,sizeof(inext));
  memset(&ifocustime,0,sizeof(inext));
  memset(&ishuttertime,0,sizeof(inext));
  memset(&iiddletime,0,sizeof(inext));

  double intervall=5;
  double prefocus_time=0;
  double shuttertime=0.15;

  char* end;
  if(argc>=2){
    
    intervall=strtod(argv[1],&end);
    if(argv[1]==end){
      cerr << "unable to read intervall" << endl;
      return 1;
    }
  }
  if(intervall<1e-3) intervall=1e-3;
  cerr << "intervall=" << intervall << "s";  

  if(argc>=3){
    prefocus_time=strtod(argv[2],&end);
    if(argv[2]==end){
      cerr << "unable to read prefocus_time" << endl;
      return 1;
    }
    state='f';
    if(prefocus_time<1e-3) prefocus_time=1e-3;
  }else{
    state='S';
  }
  cerr << ", prefocus_time=" << prefocus_time << "s";
  ifocustime.it_value.tv_sec=(time_t) prefocus_time;
  ifocustime.it_value.tv_usec=(long)floor((prefocus_time-(time_t)prefocus_time)*1e6);

  if(argc>=4){
    
    shuttertime=strtod(argv[3],&end);
    if(argv[3]==end){
      cerr << "unable to read intervall" << endl;
      return 1;
    }
  }
  if(shuttertime<1e-3) shuttertime=1e-3;
  ishuttertime.it_value.tv_sec=(long) shuttertime;
  ishuttertime.it_value.tv_usec=(long)((shuttertime - (long)shuttertime)*1e6);
  cerr << ", shuttertime= " << shuttertime << "s" << endl;
  

  double iddletime=intervall-prefocus_time-shuttertime;
  if(iddletime<1e-3) iddletime=1e-3;
  iiddletime.it_value.tv_sec=(long) iddletime;
  iiddletime.it_value.tv_usec=(long)floor((iddletime-(long)iddletime)*1e6);


  if((argc==1) ||(argc>4)){
    cerr << "usage: " << argv[0] << " intervall [prefocus_time [shutter_time]]" << endl
	 << "       intervall = seconds between photograps" << endl
	 << "       prefocus_time = seconds to prefocus (default "
	 <<prefocus_time << " s)" << endl
         << "       shutter_time =seconds to hold shutter down (default "
	 << shuttertime << " s)" << endl;
    return 1;
  }


  signal(SIGALRM, sigtrap);
  raise(SIGALRM); //first photo taken directly

  while (1) pause(); // wait without consuming CPU resources

  return 0;
}
