#ifndef __PPM_DECODE_H__
#define __PPM_DECODE_H__

/*=====================================================================
Nu mste PD6 (InputCapturePin) vara kopplad till en PPM-signal med korta
negativa pulser, dvs normalt hg signal... Mnga sndare har alltfr hg
utsignal fr att kunna kopplas in direkt. Drfr br man ha en stor
resistor och ett zenermotstnd, som begrnsar spnningen till under +5V
//====================================================================*/

/* Includes */
#include <io.h>
#include <interrupt.h>
#include <sig-avr.h>

/* Definitions */
#ifndef CLOCK
#define CLOCK               3686400
#warning Satte CLOCK i PPM_DECODE
#endif
#define ICP_falling 0
#define ICP_rising 0x40
#define ICP_denoise 0x80

#define ppmdec_prescaler 8
#define ppmdec_presval 2

/* Variabel som vi tyvrr lgger hr. */
uint8_t ppmdec_internal_state; //0219 skall kanske vara volatile, men troligast inte.
uint8_t ppmdec_pos[8];
uint8_t ppmdec_pos_valid;

/* Global functions */
void ppmdec_start(void); /*Startar avkodning */
void ppmdec_stop(void);
uint8_t ppmdec_getData(uint8_t* where); /* Fyller tta minnespositioner med 
servopositioner. returnerar falskt om det inte kommit data under 100 ms.
Vntar tills nsta chunk med PPM-data kommer, om det behvs.*/



#define EN_MS ( CLOCK/1000/ppmdec_prescaler ) 

#endif
