#include <io.h>
#include <interrupt.h>
#include <sig-avr.h>
#include "ppm_decode.h"


void ppmdec_start(void){ /*Startar avkodning */
//Vi snor timer1
outp(0,TCCR1B); //Stoppad timer1
outp(0,TCCR0); //stoppar timer0

outp(0,   TCCR1A);	//Nollstllning
outp(0,   TCNT1H);
outp(0,   TCNT1L);
sbi(TIFR,TOV1); //nolla overflow1-flagga
sbi(TIFR,ICF1); //nolla input capture-flagga
#define TICIE1 3
outp((1<<TICIE1),TIMSK); //INPUT CAPTURE ,ej OUTPUT COMPARE MATCH |(1<<OCIE1A)
cbi(DDRD,PD6); //PD6 Ingng
sbi(PORTD,PD6); //PD6 Pullupp
ppmdec_internal_state=bit_is_set(PIND,PD6)?1:0;
outp(ICP_rising | ICP_denoise | 
	ppmdec_presval,TCCR1B);
ppmdec_pos_valid = 0;
}
void ppmdec_stop(void){
//Lmnar tillbaka timer1
//0219
outp(0,TCCR1B); //Stoppad, inget input capture
outp(5,TCCR0); //startar timer0. Prescaler = 5 //0219
ppmdec_pos_valid = 0;
}

uint8_t ppmdec_getData(uint8_t* where){ /* Fyller tta minnespositioner med 
	servopositioner, och returnerar falskt bara om det inte kommit data de senaste 100 ms.*/
	//0219
	uint16_t x;
	for(x=0;x<30000;x++) { //0219 beroende p klockfrekvens, 30000 vid 3.6864 MHz
		if(ppmdec_pos_valid) {
			for(x=0;x<8;x++) where[x]=ppmdec_pos[x];
			ppmdec_pos_valid=0;
			return 1;
		}
	}
return 0;
} //0219 Mste trimma tiden till 100 ms i slingan
