//FIXME stt DEBUG_VERSION nedan bara fr debuggkrningar (simuleringar)...
// #define DEBUG_VERSION

/* ****************************************************
Kod som tar emot kommandon seriellt, och sen stter 8 servon.
**************************************************** */
#include <io.h>
#include <interrupt.h>
#include <sig-avr.h>
#include <progmem.h>
#include "uart.h"
#include "I2C.h"
//#include "ppm_decode.h"


#define CLOCK 4000000
//7372800 //Mste ven ndra p uart.h




#define LED_LEFT		PB3
#define LED_RIGHT		PB2
#define LED_UPP		PB0
#define LED_MIDDLE	PB4
#define LED_DOWN		PB1

#define PPM_OUT		PB3

//#define BUTTON_PROGRAM	PD3
//#define BUTTON_ACTIVE	PD2

#define BV(bit)	(1 << bit)

//#define MACRO_PROGRAMMERA ( bit_is_clear(PIND,BUTTON_PROGRAM) )
//#define MACRO_AKTIVERAD		( bit_is_set(PIND,BUTTON_ACTIVE) )

/******************************************************/
#define EEPROM_adr 0xA0
/* Allt detta har varit borttaget lnge...
void EEPROM_poll(void){
	//Tidigare har i2c_write anropats, och nu vntar man p att EEPROM-minnet 
	//skall bli klart med skrivningen...
	u08 i; 
	u08 addr;
	u08 timeout=0;
	
loop:
	addr = EEPROM_adr & 0xFE;
	i2c_internal_start();

    for (i=0;i<8;i++) {
        if (addr>127) SDA_1; else SDA_0;
        i2c_delay(uDLY);
        SCL_1; i2c_delay(uDLY);
        SCL_0; i2c_delay(uDLY);
        addr<<=1;
    }
    SDA_1; i2c_delay(uDLY);
    SCL_1; i2c_delay(uDLY);
    cbi(DDRD,SDA);    
    if (R_SDA) { 
    	//Ingen ACK
    	SCL_0; i2c_delay(uDLY);
    	sbi(DDRD,SDA);
    	timeout++;
    	if(timeout!=0) goto loop;
    	i2c_internal_stop();    	
    } else
    {
    	i2c_writebyte(0);		//Address
	i2c_internal_start();
	i2c_writebyte(EEPROM_adr|1);
	i2c_readbyte();                // prebere byte
	i2c_internal_stop();
    }
  
    
	
}
*/

/* Nu kommer ngra saker fr att lsa tta 
 * byte i taget frn eepromet till where[]
 */
/*
//Stter adressrknaren till starten av en av 9 banker (0..8)
void SetEEPROMBank(uint8_t bank){
	unsigned char byte;
	i2c_internal_start();
    byte=EEPROM_adr & 0xFE;                    // naslov
    i2c_writebyte(byte);
    byte=address;                       // interni naslov
    i2c_writebyte(byte);
    i2c_internal_start();
    byte=EEPROM_adr | 1;                  // naslov + RD
    i2c_writebyte(byte);
    byte=i2c_readbyte();                // prebere byte
    i2c_internal_stop();

}
*/
/*
uint8_t GetEEPROM(uint16_t addr){
	uint8_t byte;
	uint8_t addrLo = addr & 0xFF;
	uint8_t addrHi = addr >> 8;
	
	//return i2c_read( addrHi, addrLo );
	//tidigare. Nu detta lnga uttryck...
	i2c_internal_start();
	i2c_writebyte(EEPROM_adr | 0xFE);
	i2c_writebyte(addrHi);
	i2c_writebyte(addrLo); //Ny grej
	i2c_internal_start();
	i2c_writebyte(EEPROM_adr | 1);
	byte=i2c_readbyte();                // prebere byte
	i2c_internal_stop();
	return(byte);
}
*/
/*
void SetEEPROM(uint16_t addr, uint8_t data){
	uint8_t addrLo = addr & 0xFF;
	uint8_t addrHi = addr>>8;
	//i2c_write(addrHi,addrLo,data); //ersatt av sakerna nedan
	i2c_internal_start();
	i2c_writebyte(EEPROM_adr & 0xFE);
	i2c_writebyte(addrHi);
	i2c_writebyte(addrLo);
	i2c_writebyte(data);
	i2c_internal_stop();
	
	//0219EEPROM_poll();
}
*/
/*
void eeprom_pagewrite(uint16_t addr, uint8_t* data, uint8_t length){
	uint8_t i;	
	i2c_internal_start();
	i2c_writebyte(((addr>>7) & 0x0E) | EEPROM_adr);
	i2c_writebyte(addr & 0xFF);
	for(i=0; i<length; i++){
		i2c_writebyte(data[i]);
	}
	i2c_internal_stop();
	//EEPROM_poll();
}
*/
/******************************************************/

#define PRESCALER0 1024
#define COUNT0_20ms ( ( 256 - (CLOCK/50)/PRESCALER0 ) )

#define PRESCALER1 1
#define COUNT1_1ms ( (CLOCK/1000)/PRESCALER1  )

/* Globala variabler */
//uint8_t servos[8];
uint8_t where[8];    //Anvnds av main fr att skicka till funktioner...
volatile uint8_t i_servo;
uint8_t keyes; //Vilken tangent som r nedtryckt...
#define KEYES_STORE (10)
#define KEYES_UPP (11)
#define KEYES_DOWN (12)
#define KEYES_NONE (0)

/* Funktionsprototyper */
void pulseServoHigh(void /*uint8_t n*/);
void delay2(uint16_t max);
void init_ports(void);
void init_counters(void);
void init_rs232(void);
void updateKeyes(void);
void pos2mem_nr(void); //Anvnder where, skickar svar till variabeln position
#define MODE_STANDALONE 0
#define MODE_NORMAL 1
uint8_t mode; //om sndaren r inkopplad eler inte...
uint8_t position=0; //mste initieras av pos2mem_nr
uint8_t pos_232; //Position uppdated after every call to sync_with_rs232 och litetill
uint16_t minnesposition=0; //Anvnds fr att lsa saker i EEPROM vid PPM-utskickning
uint16_t minnesslut=0;	//Anvnds fr att se slutet vid PPM-utskickning

/* Interrupthanterare */
/*
SIGNAL(SIG_OVERFLOW0) 			//rknare0. (kommer hit var 20ms)
{	
	outp(COUNT0_20ms,TCNT0);	//Starta om rknaren 
		//0219 i_servo=0;
		pulseServoHigh();		//Brja pulsa alla servon.
}
*/

SIGNAL(SIG_OVERFLOW1)			/* rknare1, pulsning av servon 1-2ms */
{
	//if((i_servo+1) & 0x07) 
	//{
		pulseServoHigh(/*i_servo*/);
	//}
	//else
	//{
	//	sbi(PORTB,PPM_OUT);		//Stter ppm-ut hg
	//	outp(0,TCCR1B);		//Stoppa ena rknaren
	//}

//	if(++i_servo <= 7) {		//Vi har bara 8 servon
//		pulseServoHigh(/*i_servo*/);
//	}
//	else {
//		sbi(PORTB,PB3);		//Stter ppm-ut hg
//		outp(0,TCCR1B);		//Stoppa ena rknaren
//	}

}

//uint16_t current_addr=0;

/********************[SMSAKER]*******************************/

//Stter variabeln keyes till den tangent som r nedtryckt.
void updateKeyes(void) 
{
	uint8_t counter=0;
	
	keyes=KEYES_NONE;
	
	outb( 0xFE,PORTB); //B0 lg, B3 hg, resten pull-upp
	outb( 0x09 ,DDRB); //B1-B2,B4-B7 ingngar, B0,B3 utgngar
	delay2(3);	
	switch((~inp(PINB))&0xF0){
		case 1<<PB7: keyes=KEYES_STORE; counter+=1; break; //1<<PB7
		case 1<<PB6: keyes=1; counter+=1;break; //1<<PB6
		case 1<<PB5: keyes=4; counter+=1;break; //1<<PB5
		case 1<<PB4: keyes=7; counter+=1;break; //1<<PB4
		case 0: ; break;
		default: counter=2; keyes=KEYES_NONE;
	}
	outb(0x08,DDRB);

	outb( 0xFD,PORTB); //B1 lg, B3 hg, resten pull-upp
	outb( 0x0A ,DDRB); //B0.B2,B4-B7 ingngar, B1,B3 utgngar	
	delay2(3);
	switch((~inp(PINB))&0xF0){
		case 1<<PB7: keyes=KEYES_UPP; counter+=1;break;
		case 1<<PB6: keyes=2; counter+=1;break;
		case 1<<PB5: keyes=5; counter+=1;break;
		case 1<<PB4: keyes=8; counter+=1;break;
		case 0: ; break;
		default: keyes=0; counter=2;
	}
	outb(0x08,DDRB);	

	outb( 0xFB,PORTB); //B2 lg, B3 hg, resten pull-upp
	outb( 0x0C ,DDRB); //B0-B1,B4-B7 ingngar, B2,B3 utgngar
	delay2(3);
	switch((~inp(PINB))&0xF0){
		case 1<<PB7: keyes=KEYES_DOWN;counter+=1;break;
		case 1<<PB6: keyes=3; counter+=1;break;
		case 1<<PB5: keyes=6; counter+=1;break;
		case 1<<PB4: keyes=9; counter+=1;break;
		case 0: ; break;
		default: keyes=KEYES_NONE;counter=2;
	}
	outb(0x08,DDRB);
	
	if(counter > 1) keyes=KEYES_NONE;
}


uint8_t LED_n;
uint8_t LED_dat[]={0x1F, 0x1E, 0x1A, 0x18, 0x10, 0x00};
void LEDS_Countdown(void){
	//Alla tnda, slcker uppe, slcker hger, slcker nere, vnster, mitt...
	for(LED_n=0;LED_n<12; LED_n++){
		delay2(65535);		
		UART_SendByte(LED_dat[LED_n>>1]);
	}
}
void LEDS_flash_done(void){
/* FIXME terstll detta (ta bort / *   * /)
	for(LED_n=0;LED_n<6; LED_n++){
		delay2(65535);
		UART_SendByte(LED_n&1 ? 0x10:0x00);
	}
*/
}

void sync_with_rs232(void){
	uint8_t x;
	if(mode==MODE_NORMAL)
	{
		if(UART_ReceiveByte()==0xAA)
		{
			//Tar emot saker fr synkroniseringens skull...
			pos_232=UART_ReceiveByte();
			for(x=0; x<8; x++) 
			{
				UART_ReceiveByte(); //
			}
			
		}
		else 
		{
			LEDS_flash_done();
		}
	}
	else
	{
		delay2(10000); //FIXME denna tid mste justeras in...
	}
}

/*********************[ MAIN ]********************************/

int main(void) 
{
	uint8_t x,y;
	
	init_ports();
	i2c_init();
	//init_counters();
	UART_Init();
		
	sei();
	
	
	//Kolla om sndaren snder pulser till oss, eller om vi ska jobba i
	//sndarlst lge...
	mode=MODE_STANDALONE;
	
	
#ifdef DEBUG_VERSION
	keyes=10;
	goto switch_keyes;
#endif
	
	
	
	
	for(minnesslut=0; minnesslut<25600; minnesslut++)
	{
		//i2c_write16(EEPROM_adr,minnesslut, minnesslut & 0xFF); //FIXME ta bort
		//delay2(4000);
		if(UART_ReceivedChar)
		{
			if(UART_ReceiveByte()==0xAA) 
			{
				mode=MODE_NORMAL;
				for(x=0;x<9;x++) 
				{
					UART_ReceiveByte();
				}
				goto forever;
			}
		}
		delay2(100);
	}
	
	sync_with_rs232();
	
forever:


	//Nu avkodar vi tangentbordet...
	updateKeyes(); //Stter variabeln keyes...
		
	
	//Nu skickar vi vad som ska visas p LED till hger...
switch_keyes:
	switch(keyes){
	case 2: UART_SendByte(1); break;  //upp     1<<0
	case 4: UART_SendByte(8); break;  //vnster 1<<3
	case 5: UART_SendByte(16); break; //mitt    1<<4
	case 6: UART_SendByte(4); break;  //hger   1<<2
	case 8: UART_SendByte(2); break;  //ned     1<<1
	case KEYES_STORE:
	
		
		
#ifdef DEBUG_VERSION
		keyes=2;
#else
		//Blinkar med toppdioden tills minne tryckts in...
		while((keyes<1) | (keyes>9)) {
			UART_SendByte(2);
			delay2(60000);
			UART_SendByte(0);
			delay2(60000);
			updateKeyes();
		}; 
#endif		
		position=keyes-1; //tal mellan 0 och 8, anger "minne" 1-9...
		
		//Vnta p att knappen slpps...
		while(keyes) updateKeyes();
		
		minnesposition=(28*position) << 8;
		minnesslut=minnesposition+7165; //7168 r brjan p nsta
#ifndef DEBUG_VERSION		
		LEDS_Countdown(); //Ger ngon typ av nedrkning...


		//MSTE SYNKRONISERA MOT SERIELLA DATASTRMMEN
		UART_ReceiveByte();
		for (;;) {
			delay2(1600); //c:a 3 ms
			if (UART_ReceivedChar) //Om ngot tagits emot...
			{
				UART_ReceiveByte();
			}
			else
			{
				goto got_sync;
			}
				
		}
got_sync:
		
		//FIXME synkningen kan gras mycket bttre. 
		//Kolla t.ex uppehll p 20 ms
		

#endif

		
pagelabel:
		//Fyller en "page" med minne i taget
		i2c_internal_start();
		i2c_writebyte(EEPROM_adr & 0xFE);
		i2c_writebyte(minnesposition >> 8); //hg adress
		i2c_writebyte(0);//lg adress (alltid 0 p page-boundaries)
		
		for(y=0;y<32;y++){
#ifndef DEBUG_VERSION
		  if(UART_ReceiveByte()==0xAA)
#endif		  
		  { //FIXME kolla s att '{' hr ihop med 'if-grejen' ovan...
			//Nu ska vi ta emot sndarens positioner...		
#ifndef DEBUG_VERSION
			pos_232=UART_ReceiveByte(); //Tar emot "position"
#endif			
			for(x=0; x<8; x++) 
			{
#ifndef DEBUG_VERSION			
				where[x]=UART_ReceiveByte(); //Vi mste buffra datat. Hinner inte med i realtid
#endif
			}
			
			for(x=0; x<8; x++) 
			{
			
				if(minnesposition>=minnesslut) {
					i2c_internal_stop();
					delay2(3000);
					goto no_more_data_to_store;
				}
#ifdef DEBUG_VERSION
				i2c_writebyte(y*8+x);
#else
				i2c_writebyte(where[x]);
#endif
				minnesposition++;
				//SetEEPROM(minnesposition++,UART_ReceiveByte());
			}
			
		  } //slut p if(UART_ReceiveByte()==0xAA)
#ifndef DEBUG_VERSION
		  //else { 
		  //UART_SendByte(0x03); //Pekar uppt och nedt...
		  //}
#endif		  		  
		  updateKeyes();
		  if(keyes!=KEYES_NONE) {break;} //hoppar ur slingan
		} //Slut p for(y=0;y<32;y++)
		
		i2c_internal_stop();
		delay2(3000); //FIXME ndra vrdet?
		//Om ingen tangent tryckt, g till templabel
		//updateKeyes(); inflyttad i for(y=0;y<32;y++)-loopen
		if(keyes==KEYES_NONE) goto pagelabel;
no_more_data_to_store:
		//delay2(3500); //FIXME ta bort?
		//grej som berttar hur mycket 
		//av minnet som ska sparas
		minnesslut=minnesposition;
		minnesposition=((28*position) << 8)+7166;
		
		i2c_write16(EEPROM_adr, minnesposition, minnesslut >> 8);
		delay2(6000);
		i2c_write16(EEPROM_adr, minnesposition+1, minnesslut & 0xFF);
		delay2(6000);
		
		
		//FIXME skriv rutin som stter minnesposition 
		//och minnesslut nr den anropas med en "position"
		goto forever;
		break;
		
	case KEYES_NONE:
		{		
			//sync_with_rs232();
			keyes=pos_232;
			pos_232=5; //FIXME Fr att slippa dumma grejer
			goto switch_keyes;
		}
	default: 
		UART_SendByte(0);
		break;
	}//end case
		
	position=keyes-1;
	if(position<=8) //(keyes>=1) & (keyes<=9))
	{ 

//FIXME kolla att det fungerar
minnesposition=((28*position) << 8)+7166;
minnesslut=i2c_read16(EEPROM_adr, minnesposition) << 8;
minnesslut+=i2c_read16(EEPROM_adr, minnesposition+1);

		//Nu ska vi brja snda ut saker frn en ny tangent
		minnesposition=(28*(position)) << 8;
//FIXME		minnesslut=minnesposition+511; //FIXME gr variabel (+7165 max)
	
		i2c_internal_start();
		i2c_writebyte(EEPROM_adr & 0xFE); //FIXME var EEPROM_adr & 0xFE
		i2c_writebyte(minnesposition>>8);
		i2c_writebyte(0);

ppmlooplabel:		
		sync_with_rs232();
		
		//FIXME kolla interruptet och pulseservohigh...
		for(x=0; x<8; x++)
		{
			i2c_internal_start();
			i2c_writebyte(EEPROM_adr | 1); 
			where[x]=i2c_readbyte();
			i2c_internal_stop();
		}

		//Nu skickar vi ut PPM-pulser 
		init_counters();
		i_servo=0;
		pulseServoHigh(/*0*/);		//Brja pulsa alla servon.
		while(i_servo != 8) { }; //gr inget

		minnesposition += 8;
		if(minnesposition>=minnesslut) {
		//	outp(0,TCCR1B);		//FIXME kan man kommentera bort? rknaren stoppad
		//	outp(0,TCCR0);		//rknaren stoppad
			goto forever;
		}
		
		goto ppmlooplabel;
	}
		
	
	
	
	goto forever;

		
//	//minnesposition=16+50*8*position;
//	minnesposition = position << 4;
//	minnesposition += 16+(minnesposition << 3) + (minnesposition << 4);
	
/*	if(MACRO_PROGRAMMERA)
	{
		//Vi ska programmera minnet.
		LEDS_Countdown();

		for(x=0;x<50;x++){
			if(MACRO_PROGRAMMERA) {
				delay2(5000);
				SetEEPROM(position,x);
				goto spagetti2;
			}
			
			cbi(DDRB,LED_MIDDLE);
			sbi(PORTB,LED_MIDDLE);
			
			if(!ppmdec_getData( where )) break; //0219
			eeprom_pagewrite(x+minnesposition,where,8); //0219
			//LEDS_flash();
			
			cbi(PORTB,LED_MIDDLE);
			sbi(DDRB,LED_MIDDLE);
			
		}
		delay2(5000);
		SetEEPROM(position,50);
		
		spagetti2:
		//ppmdec_stop();
		LEDS_flash_done();
	}
	else
	{
		//Vi programmerar inte, utan flyttar oss.		
		ppmdec_stop();
		minnesslut=minnesposition+(GetEEPROM(position) << 3);
		init_counters();
		while(minnesposition < minnesslut) ; //Gr inget...
	}
	goto forever;
*/
/*
move:	
	

goto lern;



lern:
	
lern1:
	UART_PrintfEndOfLine();
	delay2(30000);
	for(x=0; x<8; x++) {
		UART_Printfu08(ppmdec_pos[x]);
		UART_SendByte(' ');
	}
	UART_Printfu08(current_addr >> 8);
	UART_Printfu08(current_addr &0xFF);
	//UART_Printfu08(ppmdec_internal_state);
	
	if(current_addr>= 1000) goto display;
	if(bit_is_set(PIND,PD3)) goto lern1;
goto move;

display:
	PRINT("Fullt\r\n");
	for(x=0; x<2048; x++){
		UART_Printfu08(GetEEPROM(x));
	}

	
	
display1:
goto display1;	
*/
}

void init_ports(void){
	//Fixar riktning p portar.
	outb( 0x08 ,DDRB); //B0-B2,B4-B7 ingngar, B3 utgng
	outb( 0x08,PORTB); //Inga pull-upp, PB3 hg
	outb(0x00,DDRD); //hela D ingng
	outb(0xFF,PORTD); //hela D pull-upp
}

void delay2(uint16_t max)
{
/*	Ngra uppmtta tider vid 3.6864 MHz:
	max=100,  exekveringstid=193.41  us
	   =1000,               =1902.40 us
	   =10000,              =34.79 ms

*/
	uint16_t i;
	for(i=0;i< max; i++) {
		asm volatile("nop\n\t"::);
	}
}

/************[Saker som rr sjlva servo-delen]***************/

void pulseServoHigh(void) //(uint8_t n)
{
	uint16_t PSH_delay;
	uint8_t PSH_temp;

	if(i_servo>7) {
		outp(0,TCCR1B);		//rknaren stoppad
		//outp(0,TCCR0);		//rknaren stoppad
		return;
	}
	
	PSH_temp=where[i_servo++];
	
	cbi(PORTB,PPM_OUT);		//Stt ppm-ut lg.
	
	//Rkna ut tidsfrdrjningen
	PSH_delay =  (65536 - COUNT1_1ms) - PSH_temp*( COUNT1_1ms / 256 );
	
	//stt rknarna
	__outw_atomic(PSH_delay,TCNT1L);
	//outp(delay >> 8,   TCNT1H);
	//outp(delay & 0xFF, TCNT1L);
	
	outp(1,TCCR1B);		//PRESCALER1 1, rknaren startad
	delay2(155);		//Vnta 300us frn lgsttningen
	sbi(PORTB,PPM_OUT);	//Stt ppm-ut hg.
}

/*************************************************************/


void init_counters(void){
	//0219 i_servo=0;
	//Stter upp 1ms-2ms rknaren	
	outp(0,   TCCR1A);	//Nollstllning
	outp(0,TCCR1B);		//rknaren stoppad
	outp((1<<TOIE1), TIMSK);//Slr p TCNT1 overflow-int gr vi nedan...	
	//outp(1,TCCR1B);		//PRESCALER1=1, rknaren gr


	//Stter upp 20ms-rknaren
//	outp((1<<TOIE0)|(1<<TOIE1),TIMSK);	//Slr p TCNT0 overflow-int
//	outp(0,TCNT0);		//Nollstll rknaren 
//	outp(5,TCCR0);		//PRESCALER0=1024, rknaren gr
//	outp(COUNT0_20ms,TCNT0);//Interrupt om 20ms
}


