 /***********************************************************
  *   Program:    I2C driver
  *   Created:    24.5.99 23:01
  *   Author:     Bray++
  *   Comments:   I2C driver (not optimized, spljoh..:)..)
  ************************************************************/
#include "i2c.h"

//By Simon Gustafsson
void i2c_internal_start(void){
    SDA_1; SCL_1; i2c_delay(uDLY);
    SDA_0; i2c_delay(uDLY);
    SCL_0; i2c_delay(uDLY);
}
//By Simon Gustafsson
void i2c_internal_stop(void){
    SDA_0; i2c_delay(uDLY);             // stop
    SCL_1; i2c_delay(uDLY);             //
    SDA_1; i2c_delay(uDLY);             //
}


// inicializacija pinov
void i2c_init()
{
    sbi(DDRD,SDA);
    sbi(DDRD,SCL);
}

// zakasnitev
void i2c_delay(unsigned int p)
{
  unsigned int i;
  unsigned char j;
  for(i=0;i<p;i++)
    for (j=0;j<10;j++);
}

// pisanje byte-a na i2c
void i2c_writebyte(unsigned char byte)
{
    unsigned char i;

    for (i=0;i<8;i++) {
        if (byte>127) SDA_1; else SDA_0;
        i2c_delay(uDLY);
        SCL_1; i2c_delay(uDLY);
        SCL_0; i2c_delay(uDLY);
        byte<<=1;
    }
    SDA_1; i2c_delay(uDLY);
    SCL_1; i2c_delay(uDLY);
    cbi(DDRD,SDA);
    //if (R_SDA) i2cflag=0; else i2cflag=1;
    SCL_0; i2c_delay(uDLY);
    sbi(DDRD,SDA);
}

// branje byte-a z i2c
unsigned char i2c_readbyte(void)
{
    unsigned char i,byte=0;

    cbi(DDRD,SDA);                     // nastavi pin za vhod
    for (i=0;i<8;i++) {
        byte<<=1;
        if (R_SDA) byte|=1;
        i2c_delay(uDLY);
        SCL_1; i2c_delay(uDLY);
        SCL_0; i2c_delay(uDLY);
    }
    sbi(DDRD,SDA);                     // nastavi pin za izhod
    SDA_1; i2c_delay(uDLY);
    SCL_1; i2c_delay(uDLY);
    SCL_0; i2c_delay(uDLY);
    return(byte);
}

// I2C write
void i2c_write16(unsigned char deviceaddr, uint16_t address, unsigned char data)
{
    unsigned char byte;
    i2c_internal_start();    
    i2c_writebyte(deviceaddr & 0xFE);
    i2c_writebyte(address >> 8);
    i2c_writebyte(address & 0xFF);
    i2c_writebyte(data);
    i2c_internal_stop();
}

unsigned char i2c_read16(unsigned char deviceaddr, uint16_t address)
{
    unsigned char byte;
    i2c_internal_start();
    i2c_writebyte(deviceaddr & 0xFE);
    i2c_writebyte(address >> 8);
    i2c_writebyte(address & 0xFF);
    i2c_internal_start();
    i2c_writebyte(deviceaddr | 1);
    byte=i2c_readbyte();                // prebere byte
    i2c_internal_stop();
    return(byte);
}


// I2C read

/*
unsigned char i2c_read(unsigned char deviceaddr, unsigned char address)
{
    unsigned char byte;
    i2c_internal_start();
    byte=deviceaddr & 0xFE;                    // naslov
    i2c_writebyte(byte);
    byte=address;                       // interni naslov
    i2c_writebyte(byte);
    i2c_internal_start();
//    SCL_1; i2c_delay(uDLY);
//    SDA_0; i2c_delay(uDLY);
//    SCL_0; i2c_delay(uDLY);
    byte=deviceaddr | 1;                  // naslov + RD
    i2c_writebyte(byte);
    byte=i2c_readbyte();                // prebere byte
    i2c_internal_stop();
    return(byte);
}
*/