/* ****************************************************
Kod som tar emot kommandon seriellt, och sen stter 8 servon.
**************************************************** */
#include <io.h>
#include <interrupt.h>
#include <sig-avr.h>
#include <progmem.h>
#include "uart.h"
// #include "I2C.h"
#include "ppm_decode.h"


#define CLOCK 4000000
//7372800 //Mste ven ndra p uart.h




#define LED_LEFT		PB3
#define LED_RIGHT		PB2
#define LED_UPP		PB0
#define LED_MIDDLE	PB4
#define LED_DOWN		PB1

//#define PPM_OUT		PB3

//#define BUTTON_PROGRAM	PD3
//#define BUTTON_ACTIVE	PD2

#define BV(bit)	(1 << bit)

//#define MACRO_PROGRAMMERA ( bit_is_clear(PIND,BUTTON_PROGRAM) )
//#define MACRO_AKTIVERAD		( bit_is_set(PIND,BUTTON_ACTIVE) )

/******************************************************/


#define PRESCALER0 1024
#define COUNT0_20ms ( ( 256 - (CLOCK/50)/PRESCALER0 ) )

#define PRESCALER1 1
#define COUNT1_1ms ( (CLOCK/1000)/PRESCALER1  )

/* Globala variabler */
//uint8_t servos[8];
uint8_t where[8];    //Anvnds av main fr att skicka till funktioner...
uint8_t i_servo = 0;


/* Funktionsprototyper */
void pulseServoHigh(void /*uint8_t n*/);
void delay2(uint16_t max);
void init_ports(void);
void init_counters(void);
void init_rs232(void);
void pos2mem_nr(void); //Anvnder where, skickar svar till variabeln position
uint8_t position; //mste initieras av pos2mem_nr
//uint16_t minnesposition; //Anvnds fr att lsa saker i EEPROM vid PPM-utskickning
//uint16_t minnesslut;	//Anvnds fr att se slutet vid PPM-utskickning

/* Interrupthanterare */

//SIGNAL(SIG_OVERFLOW0) 			/* rknare0. (kommer hit var 20ms) */
//{	
//	outp(COUNT0_20ms,TCNT0);	//Starta om rknaren 
//		//0219 i_servo=0;
//		pulseServoHigh(/*0*/);		//Brja pulsa alla servon.
//}


//SIGNAL(SIG_OVERFLOW1)			/* rknare1, pulsning av servon 1-2ms */
//{
//	if((minnesposition+1) & 0x07) 
//	{
//		pulseServoHigh(/*i_servo*/);
//	}
//	else
//	{
//		sbi(PORTB,PPM_OUT);		//Stter ppm-ut hg
//		outp(0,TCCR1B);		//Stoppa ena rknaren
//	}
//
////	if(++i_servo <= 7) {		//Vi har bara 8 servon
////		pulseServoHigh(/*i_servo*/);
////	}
////	else {
////		sbi(PORTB,PB3);		//Stter ppm-ut hg
////		outp(0,TCCR1B);		//Stoppa ena rknaren
////	}
//
//}

//uint16_t current_addr=0;
SIGNAL(SIG_INPUT_CAPTURE1) //Enda interrupt anropat d ppmdec_start() "aktiv"
{
	uint16_t tid;
	tid = __inw_atomic(ICR1L);
	//tid = inp(ICR1L);
	//tid += inp(ICR1H)<< 8;
	
	outp(0,   TCNT1H);	//
	outp(0,   TCNT1L);	//
spagetti2:	
	switch(ppmdec_internal_state) {
	case 0: /* Startade p hg bit. Hittat en stigande nu */
		if(tid>3*EN_MS) {
			//Nu brjar det!
			ppmdec_internal_state = 2;
		}
		else {
			//Duger inte som startvillkor...
			ppmdec_internal_state = 0;			
		}
		break;
	case 1: /* Startade p lg bit. Hittade en stigande nu */
		ppmdec_internal_state = 0;
		break;
	case 2: /* Lngd p 1:a servopulsen */
	case 3: /* 2:a */
	case 4:
	case 5:
	case 6:
	case 7:
	case 8:
	case 9:
		if(tid<2*(EN_MS+EN_MS/10)) {
			//Nu brjar det!
			ppmdec_pos[ppmdec_internal_state-2] = ((tid - (EN_MS - EN_MS/10))*256)/(EN_MS+3*EN_MS/10);
			ppmdec_internal_state++;
			if(ppmdec_internal_state>9) { //Mste ndras beroende p antal kanaler
				//ppmdec_internal_state=0;
				goto spagetti1;
				
				
			}
		}
		else {
			//Duger inte som en servopuls
			//for(;ppmdec_internal_state <10;ppmdec_internal_state++) {
			//	ppmdec_pos[ppmdec_internal_state-2]=0xFF;
			//}
spagetti1:
			//if (current_addr<2088) {
			//	eeprom_pagewrite(current_addr, ppmdec_pos, 8);
			//	current_addr += 8;
			//}
			ppmdec_internal_state = 0;
			ppmdec_pos_valid = 1;
			goto spagetti2;
			}
		break;
	default:
		ppmdec_internal_state=0;
		
	}
	outp(ICP_rising | ICP_denoise | 
				ppmdec_presval,TCCR1B);
}
/********************[SMSAKER]*******************************/
//FIXME mste byta position mot talen mellan 0 och 8
void pos2mem_nr(void){ //Anvnder where, sparar svar i position
	if((where[0]>100) & (where[0] < 150) & (where[1]>100) & (where[1] < 150) ) {
		position=5;
		return;
	}
	
	if(where[0]>where[1]) {//nedt och hger
		if((255 - where[0])>where[1]) {// nedt (och vnster)
			position=8; //nedt enda alternativ
		}
		else{
			position=6; //hger enda alternativ
		}
	}
	else { //uppt och vnster
		if((255 - where[0])>where[1]) {// vnster (och nedt)
			position=4; //vnster enda alternativ
		}
		else{
			position=2; //uppt enda alternativ
		}
	}
	
}


/*
uint8_t LED_n;
uint8_t LED_dat[]={0xFC, 0xDC ,0xCC,0x4C,0x48,0x08};
void LEDS_Countdown(void){
//Alla tnda, slcker uppe, slcker hger, slcker nere, vnster, mitt...
	outb(0xFC,PORTB);
	for(LED_n=0;LED_n<12; LED_n++){
		delay2(65535);		
		outb(LED_dat[LED_n>>1],PORTB);
	}
}
void LEDS_flash_done(void){
	//uint8_t n;
	for(LED_n=0;LED_n<6; LED_n++){
		delay2(65535);
		outb( ( (LED_n&1) ? 0xFC : 0x08 ),PORTB);
	}

}
*/


/*********************[ MAIN ]********************************/
int main(void) 
{
	uint8_t x;		
	
	init_ports();	
	//init_counters();
	UART_Init();
	
	
	sei();
	
	ppmdec_start();

forever:
	
	if(ppmdec_getData( where )) 
	{
		UART_SendByte(0xAA);
		pos2mem_nr(); //anvnder where, laddar position
	
		//Nytt fr tv IC-version. Skickar data seriellt
		//till andra ic:n		
		UART_SendByte(position);
		for(x=0; x<8;x++)
		{			
			UART_SendByte(where [x]);
		}
	}

	if(UART_ReceivedChar)
	{
		x=UART_ReceiveByte();
		outb(x,PORTB);
		
		outb(0x1F,DDRB);
		//cbi(PORTB,PB6); //FIXME tabort
		//delay2(20);
		//sbi(PORTB,PB6);

	}

		//cbi(PORTB,PB7); //FIXME tabort
		//delay2(20);
		//sbi(PORTB,PB7);
	
	goto forever;
		
//	//minnesposition=16+50*8*position;
//	minnesposition = position << 4;
//	minnesposition += 16+(minnesposition << 3) + (minnesposition << 4);
	
/*	if(MACRO_PROGRAMMERA)
	{
		//Vi ska programmera minnet.
		LEDS_Countdown();

		for(x=0;x<50;x++){
			if(MACRO_PROGRAMMERA) {
				delay2(5000);
				SetEEPROM(position,x);
				goto spagetti2;
			}
			
			cbi(DDRB,LED_MIDDLE);
			sbi(PORTB,LED_MIDDLE);
			
			if(!ppmdec_getData( where )) break; //0219
			eeprom_pagewrite(x+minnesposition,where,8); //0219
			//LEDS_flash();
			
			cbi(PORTB,LED_MIDDLE);
			sbi(DDRB,LED_MIDDLE);
			
		}
		delay2(5000);
		SetEEPROM(position,50);
		
		spagetti2:
		//ppmdec_stop();
		LEDS_flash_done();
	}
	else
	{
		//Vi programmerar inte, utan flyttar oss.		
		ppmdec_stop();
		minnesslut=minnesposition+(GetEEPROM(position) << 3);
		init_counters();
		while(minnesposition < minnesslut) ; //Gr inget...
	}
	goto forever;
*/
/*
move:	
	

goto lern;



lern:
	
lern1:
	UART_PrintfEndOfLine();
	delay2(30000);
	for(x=0; x<8; x++) {
		UART_Printfu08(ppmdec_pos[x]);
		UART_SendByte(' ');
	}
	UART_Printfu08(current_addr >> 8);
	UART_Printfu08(current_addr &0xFF);
	//UART_Printfu08(ppmdec_internal_state);
	
	if(current_addr>= 1000) goto display;
	if(bit_is_set(PIND,PD3)) goto lern1;
goto move;

display:
	PRINT("Fullt\r\n");
	for(x=0; x<2048; x++){
		UART_Printfu08(GetEEPROM(x));
	}

	
	
display1:
goto display1;	
*/
}

void init_ports(void){
	//Fixar riktning p portar.
	outb( 0x1F ,DDRB); //B0-B4 utgngar (till lysdioder)
	outb( 0x00,PORTB);
	outb(0x00,DDRD); //hela D ingng
	outb(0xFF,PORTD); //hela D pull-upp
}

void delay2(uint16_t max)
{
/*	Ngra uppmtta tider vid 3.6864 MHz:
	max=100,  exekveringstid=193.41  us
	   =1000,               =1902.40 us
	   =10000,              =34.79 ms

*/
	uint16_t i;
	for(i=0;i< max; i++) {
		asm volatile("nop\n\t"::);
	}
}


/*************************************************************/
/*
void actOnRS232_HUMAN(void)
{
	uint8_t x;
slinga:
	x = UART_ReceiveByte();
	//UART_SendByte(x);
	switch(Reception_state){
	case 0:
		if(x=='+') {
			UART_SendByte('+');
			Reception_state = 1;			
			break;
		}
		if(x=='?') {
			for(x=0; x<8; x++){
				UART_SendByte('0'+x);
				UART_SendByte('-');
				UART_Printfu08(servos[x]);
				UART_SendByte(' ');
			}
			PRINT("\r\n");
		}
		break;
	case 1:
		Reception_servo=x-'0';
		UART_SendByte('0'+Reception_servo);		
		if(Reception_servo>7) { Reception_state=0; }
		else { Reception_state=2; }		
		break;
	case 2:
		UART_SendByte(x);
		Reception_pos=HexToNybble(x) << 4; //Ingen felkontroll...
		Reception_state++;
		break;
	case 3:
		Reception_pos+=HexToNybble(x);
		Reception_state=0;
		servos[Reception_servo] = Reception_pos;
		//UART_SendByte('=');
		//UART_SendByte('0'+Reception_servo);
		UART_SendByte(x);
		//UART_Printfu08(servos[Reception_servo]);
		PRINT("\r\n"); //Makro fr att snda strng.
		//UART_SendByte(' ');
		break;
	default:
		Reception_state=0;
	}
goto slinga;
}

*/
/*************************************************************/

/*
void init_counters(void){
	//0219 i_servo=0;
	//Stter upp 1ms-2ms rknaren
	//outp((1<<TOIE1), TIMSK);//Slr p TCNT1 overflow-int gr vi nedan...
	outp(0,   TCCR1A);	//Nollstllning
	outp(0,TCCR1B);		//rknaren stoppad
	//outp(1,TCCR1B);		//PRESCALER1=1, rknaren gr


	//Stter upp 20ms-rknaren
	outp((1<<TOIE0)|(1<<TOIE1),TIMSK);	//Slr p TCNT0 overflow-int
	outp(0,TCNT0);		//Nollstll rknaren 
	outp(5,TCCR0);		//PRESCALER0=1024, rknaren gr
	outp(COUNT0_20ms,TCNT0);//Interrupt om 20ms
}

*/
