/* ****************************************************
Kod som tar emot kommandon seriellt, och sen stter 8 servon.
**************************************************** */
#include <io.h>
#include <interrupt.h>
#include <sig-avr.h>
#include <progmem.h>
//#include "uart.h"
//#include "I2C.h"
#include "i2cmaster.h"
#include "ppm_decode.h"


#define CLOCK 3686400
//7372800 //Mste ven ndra p uart.h



#define LED_LEFT		PB2
#define LED_RIGHT		PB4
#define LED_UPP		PB5
#define LED_MIDDLE	PB6
#define LED_DOWN		PB7

#define PPM_OUT		PB3
#define PPM_IN		PD6
#define BUTTON_PROGRAM	PD3
#define BUTTON_ACTIVE	PD2

#define BV(bit)	(1 << bit)

#define MACRO_PROGRAMMERA ( bit_is_clear(PIND,BUTTON_PROGRAM) )
#define MACRO_AKTIVERAD		( bit_is_set(PIND,BUTTON_ACTIVE) )

/* Globala variabler */
//uint8_t servos[8];
uint8_t where[8];    //Anvnds av main fr att skicka till funktioner...
uint8_t i_servo;

/******************************************************/
#define EEPROM_adr 0xA0

void delay2(uint16_t max);

uint8_t GetEEPROM(uint16_t addr){
uint8_t ret;
	uint8_t addrLo = addr & 0xFF;
	uint8_t addrHi = ((addr>>7) & 0x0E) | EEPROM_adr;
	i2c_start_wait(addrHi|I2C_WRITE);
	i2c_write(addrLo);
	i2c_rep_start(addrHi|I2C_READ);
	ret=i2c_readNak();
	i2c_stop();
	return ret;
}

void SetEEPROM(uint16_t addr, uint8_t data){
	uint8_t addrLo = addr & 0xFF;
	uint8_t addrHi = ((addr>>7) & 0x0E) | EEPROM_adr;
	//i2c_write(addrHi,addrLo,data);
	i2c_start_wait(addrHi|I2C_WRITE);
	i2c_write(addrLo);
	i2c_write(data);
	i2c_stop();
	delay2(20000); //0219 ondigt lngt...

}
void eeprom_pagewrite(uint16_t addr, /*uint8_t* where,*/ uint8_t length){
	uint8_t addrLo = addr & 0xFF;
	uint8_t addrHi = ((addr>>7) & 0x0E) | EEPROM_adr;
	uint8_t i;
	i2c_start_wait(addrHi|I2C_WRITE);
	i2c_write(addrLo);
	for(i=0; i<length; i++){
		i2c_write(where[i]);
		//SetEEPROM(addr,where[i]);
	}
	i2c_stop();
	//delay2(15000);//ondigt lngt
}

/******************************************************/

#define PRESCALER0 1024
#define COUNT0_20ms ( ( 256 - (CLOCK/50)/PRESCALER0 ) )

#define PRESCALER1 1
#define COUNT1_1ms ( (CLOCK/1000)/PRESCALER1  )



/* Funktionsprototyper */
void pulseServoHigh(void /*uint8_t n*/);
void delay2(uint16_t max);
void init_ports(void);
void init_counters(void);
//void init_rs232(void);
void pos2mem_nr(void); //Anvnder where, skickar svar till variabeln position
uint8_t position; //mste initieras av pos2mem_nr
uint16_t minnesposition; //Anvnds fr att lsa saker i EEPROM vid PPM-utskickning
uint16_t minnesslut;	//Anvnds fr att se slutet vid PPM-utskickning
uint8_t mem_duplet=0; //Stt till 0 fr att kra snabb hastighet. 1 fr halva
/* Interrupthanterare */

SIGNAL(SIG_OVERFLOW0) 			/* rknare0. (kommer hit var 20ms) */
{	
	for(i_servo=0;i_servo<8; i_servo++) {
		where[i_servo]=GetEEPROM(minnesposition++);
	}
	switch(mem_duplet){
	case 0: break;
	case 1: mem_duplet++; minnesposition-=8; break;
	case 2: mem_duplet--; break;
	default : mem_duplet=0;
	}
	
	outp(COUNT0_20ms,TCNT0);	//Starta om rknaren 
		i_servo=0;
		pulseServoHigh(/*0*/);		//Brja pulsa alla servon.
}


SIGNAL(SIG_OVERFLOW1)			/* rknare1, pulsning av servon 1-2ms */
{
//	if((minnesposition+1) & 0x07) 
//	{
//		pulseServoHigh(/*i_servo*/);
//	}
//	else
//	{
//		sbi(PORTB,PPM_OUT);		//Stter ppm-ut hg
//		outp(0,TCCR1B);		//Stoppa ena rknaren
//	}

	if(++i_servo <= 7) {		//Vi har bara 8 servon
		pulseServoHigh(/*i_servo*/);
	}
	else {
		//sbi(PORTB,PPM_OUT);		//Stter ppm-ut hg
		outp(0,TCCR1B);		//Stoppa ena rknaren
	}

}

//uint16_t current_addr=0;
SIGNAL(SIG_INPUT_CAPTURE1) //Enda interrupt anropat d ppmdec_start() "aktiv"
{
	uint16_t tid;
	tid = __inw_atomic(ICR1L);
	//tid = inp(ICR1L);
	//tid += inp(ICR1H)<< 8;
	
	outp(0,   TCNT1H);	//
	outp(0,   TCNT1L);	//
	
	switch(ppmdec_internal_state) {
	case 0: /* Startade p hg bit. Hittat en stigande nu */
		if(tid>3*EN_MS) {
			//Nu brjar det!
			ppmdec_internal_state = 2;
		}
		else {
			//Duger inte som startvillkor...
			ppmdec_internal_state = 0;			
		}
		break;
	case 1: /* Startade p lg bit. Hittade en stigande nu */
		ppmdec_internal_state = 0;
		break;
	case 2: /* Lngd p 1:a servopulsen */
	case 3: /* 2:a */
	case 4:
	case 5:
	case 6:
	case 7:
	case 8:
	case 9:
		if(tid<2*(EN_MS_ppm+EN_MS_ppm/10)) {
			//Nu brjar det!
			ppmdec_pos[ppmdec_internal_state-2] = ((tid - (EN_MS_ppm - EN_MS_ppm/10))*256)/(EN_MS_ppm+3*EN_MS_ppm/10);
			ppmdec_internal_state++;
			if(ppmdec_internal_state>9) { //Mste ndras beroende p antal kanaler
				//ppmdec_internal_state=0;
				goto spagetti1;
				
				
			}
		}
		else {
			//Duger inte som en servopuls
			//for(;ppmdec_internal_state <10;ppmdec_internal_state++) {
			//	ppmdec_pos[ppmdec_internal_state-2]=0xFF;
			//}
spagetti1:
			//if (current_addr<2088) {
			//	eeprom_pagewrite(current_addr, ppmdec_pos, 8);
			//	current_addr += 8;
			//}
			ppmdec_internal_state = 0;
			ppmdec_pos_valid = 1;
		}
		break;
	default:
		ppmdec_internal_state=0;
		
	}
	outp(ICP_rising | ICP_denoise | 
				ppmdec_presval,TCCR1B);
}
/********************[SMSAKER]*******************************/
uint8_t position2LED[]= {LED_MIDDLE, LED_UPP,LED_RIGHT,LED_DOWN,LED_LEFT};

void pos2mem_nr(void){ //Anvnder where, sparar svar i position
	if((where[0]>100) & (where[0] < 150) & (where[1]>100) & (where[1] < 150) ) {
		position=0;
	}
	else{
		if(where[0]>where[1]) {//nedt och hger
			if((255 - where[0])>where[1]) {// nedt (och vnster)
				position=3; //nedt enda alternativ
			}
			else{
				position=2; //hger enda alternativ
			}
		}
		else { //uppt och vnster
			if((255 - where[0])>where[1]) {// vnster (och nedt)
				position=4; //vnster enda alternativ
			}
			else{
				position=1; //uppt enda alternativ
			}
		}
	}
}


uint8_t LED_n;
uint8_t LED_dat[]={0xFE, 0xDE ,0xCE,0x4E,0x4A,0x0A}; //0219
void LEDS_Countdown(void){
//Alla tnda, slcker uppe, slcker hger, slcker nere, vnster, mitt...
	outb(0xFE,PORTB);
	for(LED_n=0;LED_n<12; LED_n++){
		delay2(65535);
		outb(LED_dat[LED_n>>1]|PPM_OUT,PORTB);
	}
}
/*
void LEDS_flash(void){
	outb(
}
*/
void LEDS_flash_done(void){
	//uint8_t n;
	for(LED_n=0;LED_n<6; LED_n++){
		delay2(65535);
		outb( ( (LED_n&1) ? 0xFE : 0x0A ) |PPM_OUT,PORTB);
	}

}

/*********************[ MAIN ]********************************/

int main(void) 
{
	uint8_t x;		
	
	init_ports();
	i2c_init();
	//init_counters();
	//UART_Init();
	
	sei();
	
//	PRINT("!");
	//UART_PrintfEndOfLine();
//	for(x=0; x<2048; x++){
//		UART_Printfu08(GetEEPROM(x));
//	}
forever:
/*	if(!MACRO_AKTIVERAD) {
//forever2: //FIXME snabb lsning p bugg i kompilatorn???
		outp(0,TCCR0);//Stoppar 20ms-rknaren
		if( bit_is_set(PIND,PPM_IN)) {
			outp(PORTB,BV(PPM_OUT));
			//sbi(PORTB,PPM_OUT);
		}
		else {
			//cbi(PORTB,PPM_OUT);
			outp(PORTB,0);
		}
		
		
		GetEEPROM(minnesposition++);
		delay2(100);
//		if(!MACRO_AKTIVERAD) goto forever2; //FIXME
	}
*/
	if(MACRO_AKTIVERAD){
		mem_duplet=0;
	}
	else {
		mem_duplet=1;
	}
	//Gemensamt fr programmering och rrelse.
	ppmdec_start();
	x=ppmdec_getData( /*where*/ ); //Lgger datat i where
	pos2mem_nr(); //anvnder where, laddar position
	if(x) {
		outb(0x08 |BV(position2LED[position]), PORTB);
	}
	else {
		outb(0x5C, PORTB); 
		//Horisontell linje om vi inte tog emot PPM-data
	}
	//minnesposition=16+50*8*position;
	minnesposition = position << 4;
	minnesposition += 16+(minnesposition << 3) + (minnesposition << 4);
	
	if(MACRO_PROGRAMMERA)
	{
		//Vi ska programmera minnet.
		LEDS_Countdown();

		for(x=0;x<50;x++){
			if(MACRO_PROGRAMMERA & (x!=0)) {
				delay2(15000);
				SetEEPROM(position,x);
				goto spagetti2;
			}
			
			
			if(!ppmdec_getData( /*where*/ )) break; //Lgger datat i where
			//delay2(15000);//0219 10ms
			
			if(mem_duplet!=0){
			if(!ppmdec_getData( /*where*/)) break;
			}
			
			eeprom_pagewrite(minnesposition+(x<<3),/*where,*/8); //0219
			//delay2(15000);//0219 10ms
			//LEDS_flash();
			
			
		}
		delay2(15000);
		SetEEPROM(position,50);
		
		spagetti2:
		//ppmdec_stop();
		LEDS_flash_done();
		delay2(15000);
	}
	else
	{
		//Vi programmerar inte, utan flyttar oss.		
		ppmdec_stop();
		minnesslut=minnesposition+((GetEEPROM(position)&0x3F) << 3);
		init_counters();
		
	simon_a:
		//Togglaminnets diod, s man ser at ngot hnder...
		//outp(where[0]<<4|0x08,PORTB);
		//if(minnesposition < minnesslut) goto simon_a;
		if(inp(TCCR0)!=0) goto simon_a;
	//0219 vi borde kanske stoppa rknare noll?
	}
	goto forever;
}


/************[Saker som rr sjlva servo-delen]***************/

void pulseServoHigh(void /*uint8_t n*/)
{
	uint16_t PSH_delay;
		
	if(minnesposition>=minnesslut) {
		outp(0,TCCR1B);		//rknaren stoppad
		outp(0,TCCR0);		//rknaren stoppad
		return;
	}
	
	cbi(PORTB,PPM_OUT);		//Stt ppm-ut lg.
	
	//Rkna ut tidsfrdrjningen
	PSH_delay =  (65535 -((COUNT1_1ms -COUNT1_1ms/10 + where[i_servo]*16) +where[i_servo]));//*2-(where[i_servo]>>2));// (COUNT1_1ms >> 8=exakt 1,8);
	
	//stt rknarna
	__outw_atomic(PSH_delay,TCNT1L);
	//outp(delay >> 8,   TCNT1H);
	//outp(delay & 0xFF, TCNT1L);
	
	outp(1,TCCR1B);		//PRESCALER1 1, rknaren startad
	delay2(155);		//Vnta 300us frn lgsttningen
	sbi(PORTB,PPM_OUT);	//Stt ppm-ut hg.
}
/*************************************************************/
/*************************************************************/
void init_ports(void){
	//Fixar riktning p portar.
	outb( BV(PPM_OUT) |0xFC,DDRB); //PPM_OUT och LEDs utgngar 
	outb( 0xFE,PORTB);
	outb(0x00,DDRD); //hela D ingng
	outb(0xFF,PORTD); //hela D pull-upp
}
void init_counters(void){
	//0219 i_servo=0;
	//Stter upp 1ms-2ms rknaren
	//outp((1<<TOIE1), TIMSK);//Slr p TCNT1 overflow-int gr vi nedan...
	outp(0,   TCCR1A);	//Nollstllning
	outp(0,TCCR1B);		//rknaren stoppad
	//outp(1,TCCR1B);		//PRESCALER1=1, rknaren gr


	//Stter upp 20ms-rknaren
	outp((1<<TOIE0)|(1<<TOIE1),TIMSK);	//Slr p TCNT0 overflow-int
	outp(0,TCNT0);		//Nollstll rknaren 
	outp(5,TCCR0);		//PRESCALER0=1024, rknaren gr
	outp(COUNT0_20ms,TCNT0);//Interrupt om 20ms
}

void delay2(uint16_t max)
{
/*	Ngra uppmtta tider vid 3.6864 MHz:
	max=100,  exekveringstid=193.41  us
	   =1000,               =1902.40 us
	   =10000,              =34.79 ms

*/
	uint16_t i;
	for(i=0;i< max; i++) {
		asm volatile("nop\n\t"::);
	}
}

