 /***********************************************************
  *   Program:    I2C header
  *   Created:    24.5.99 23:02
  *   Author:     Bray++
  *   Comments:   I2C definitions
  ************************************************************/
#include <io.h>

#define SCL PD5
#define SDA PD4

#define uDLY 10
//Simon: uDLY 5 frn brjan

#define SDA_0 cbi(PORTD,SDA)
#define SDA_1 sbi(PORTD,SDA)
#define SCL_0 cbi(PORTD,SCL)
#define SCL_1 sbi(PORTD,SCL)
#define R_SDA bit_is_set(PIND,SDA)

//unsigned char i2cflag;                                  // Acknowledge flag (ne dela neki)

void i2c_init(void);                                        // inicializacija pinov
void i2c_delay(unsigned int p);                         // zakasnitev (>4us !?)
void i2c_writebyte(unsigned char byte);                 // pisanje byte-a na i2c
unsigned char i2c_readbyte(void);                       // branje byte-a z i2c
void i2c_write(unsigned char deviceaddr, unsigned char address, unsigned char data);    // I2C write
unsigned char i2c_read(unsigned char deviceaddr, unsigned char address);                // I2C read

//By Simon Gustafsson
void i2c_internal_start(void);
void i2c_internal_stop(void);
void scl_0__udelay(void);
void scl_1__udelay(void);
void sda_0__udelay(void);
void sda_1__udelay(void);
