 /***********************************************************
  *   Program:    I2C driver
  *   Created:    24.5.99 23:01
  *   Author:     Bray++
  *   Comments:   I2C driver (not optimized, spljoh..:)..)
  ************************************************************/
#include "i2c.h"

//By Simon Gustafsson
void i2c_internal_start(void){
    SDA_1; scl_1__udelay();
    sda_0__udelay();
    scl_0__udelay();
}
//By Simon Gustafsson
void i2c_internal_stop(void){
    sda_0__udelay();             // stop
    scl_1__udelay();             //
    sda_1__udelay();             //
}
void scl_0__udelay(void){
// Motsvarar SCL_0; i2c_delay(uDLY);             //
	SCL_0;
	i2c_delay(uDLY);
}
void scl_1__udelay(void){
// Motsvarar SCL_1; i2c_delay(uDLY);             //
	SCL_1;
	i2c_delay(uDLY);
}
void sda_0__udelay(void){
	SDA_0; i2c_delay(uDLY);
}
void sda_1__udelay(void){
	SDA_1; i2c_delay(uDLY);
}
/////////////////////Slut Simons saker///////////////////////

// inicializacija pinov
void i2c_init()
{
    sbi(DDRD,SDA);
    sbi(DDRD,SCL);
}

// zakasnitev
void i2c_delay(unsigned int p)
{
  unsigned int i;
  unsigned char j;
  for(i=0;i<p;i++)
    for (j=0;j<10;j++);
}

// pisanje byte-a na i2c
void i2c_writebyte(unsigned char byte)
{
    unsigned char i;

    for (i=0;i<8;i++) {
        if (byte>127) sda_1__udelay(); else sda_0__udelay();
        i2c_delay(uDLY);
        scl_1__udelay();
        scl_0__udelay();
        byte<<=1;
    }
    sda_1__udelay();
    scl_1__udelay();
    cbi(DDRD,SDA);
    //if (R_SDA) i2cflag=0; else i2cflag=1;
    scl_0__udelay();
    sbi(DDRD,SDA);
}

// branje byte-a z i2c
unsigned char i2c_readbyte(void)
{
    unsigned char i,byte=0;

    cbi(DDRD,SDA);                     // nastavi pin za vhod
    for (i=0;i<8;i++) {
        byte<<=1;
        if (R_SDA) byte|=1;
        i2c_delay(uDLY);
        scl_1__udelay();
        scl_0__udelay();
    }
    sbi(DDRD,SDA);                     // nastavi pin za izhod
    sda_1__udelay();
    scl_1__udelay();
    scl_0__udelay();
    return(byte);
}

// I2C write
void i2c_write(unsigned char deviceaddr, unsigned char address, unsigned char data)
{
    unsigned char byte;
    i2c_internal_start();
    byte=deviceaddr;                    // naslov
    i2c_writebyte(byte);
    byte=address;                       // interni naslov
    i2c_writebyte(byte);
    byte=data;                          // podatek
    i2c_writebyte(byte);
    i2c_internal_stop();
    /*for (byte=0;byte<255;byte++) {      // tole je mogoce brezveze
        scl_0__udelay();
        scl_1__udelay();
    }*/
}



// I2C read
unsigned char i2c_read(unsigned char deviceaddr, unsigned char address)
{
    unsigned char byte;
    i2c_internal_start();
    byte=deviceaddr & 0xFE;                    // naslov
    i2c_writebyte(byte);
    byte=address;                       // interni naslov
    i2c_writebyte(byte);
    i2c_internal_start();
//    scl_1__udelay();
//    sda_0__udelay();
//    scl_0__udelay();
    byte=deviceaddr | 1;                  // naslov + RD
    i2c_writebyte(byte);
    byte=i2c_readbyte();                // prebere byte
    i2c_internal_stop();
    return(byte);
}
