#include <io.h>
#include <interrupt.h>
#include <signal.h>
#include "uart.h"

#define CLOCK 7372800

#define PRESCALER0 1024
#define COUNT0_20ms ( ( 256 - (CLOCK/50)/PRESCALER0 ) )

#define PRESCALER1 1
#define COUNT1_1ms ( (CLOCK/1000)/PRESCALER1  )


uint8_t servos[]={0,0,0,0,0,0,0,0};
uint8_t i_servo = 0;


void delay2(uint16_t max){
	uint16_t counter;
	for(counter=0;counter< max; counter++) {
		asm volatile("nop\n\t"::);
	}
}


void pulseservo(uint8_t n){
uint16_t delay;
	outp(0x00,PORTB); //stt alla servosignaler lga
	
	//Rkna ut tidsfrdrjningen
	delay =  (65536 - COUNT1_1ms);
	delay -= servos[n]*( COUNT1_1ms / 256 );
	
	outp(delay >> 8,   TCNT1H); //stt rknaren
	outp(delay & 0xFF, TCNT1L);
	
	outp(1,TCCR1B);	    //PRESCALER1 1, rknaren startad
	
	outp((1 << n),PORTB); //Stt rtt servosignal hg
}

SIGNAL(SIG_OVERFLOW0){ //overflow-interrupt frn rknare0, (20ms)
	
	outp(COUNT0_20ms,TCNT0);//Starta denna rknare igen
	
	i_servo=0;
	pulseservo(0);		//Starta pulsning p servo0
}


SIGNAL(SIG_OVERFLOW1) //overflow-interrupt frn rknare1
{

	if(++i_servo <= 7) {
		pulseservo(i_servo);
	}
	else {
		outp(0x00,PORTB);
		outp(0,TCCR1B);	//Rknaren stoppad
	}
	
}

uint8_t buttons;

void actOnButtons(void) {
	if(buttons & 1)    { servos[6]=0;}
	if(buttons & 2)    { servos[6]+=1;}
	if(buttons & 4)    { servos[6]-=1; }
	if(buttons & 8)    { servos[6]=255; }
	if(buttons & 0x10) {
				   servos[5]+=1;
				   servos[6]+=1;
				   servos[7]+=1;
				   servos[0]-=1;
				   servos[1]+=2;
				   servos[2]+=3;
				   servos[3]+=4;
				   servos[4]-=2;
				 }
		
	if(buttons & 0x40) { 
		delay2(200*8);
	} else {
		delay2(4000*8);
	}
}

uint8_t rec_state=0;
uint8_t rec_servo;
uint8_t rec_pos;

uint8_t HexToNybble(uint8_t sak){
	if(sak-'0' > 9) {
		if(sak-'A' +10 > 15) {
			return 0;		
		}
		else {
			return sak-'A'+10;
		}
	}
	else {
		return sak-'0';
	}
}

void actOnRS232(){
uint8_t x;
	x = UART_ReceiveByte();
	switch(rec_state){
	case 0:
		if(x=='?') {
			for(rec_state=0; rec_state<8; rec_state++){
				UART_SendByte('0'+rec_state);
				UART_SendByte('>');
				UART_Printfu08(servos[rec_state]);
				UART_SendByte(' ');
			}
			UART_PrintfEndOfLine();
		}
		rec_servo=x-'0';
		
		if(rec_servo>7) { rec_state=0;
		}else {rec_state=1;}
		
		break;
	case 1:
		rec_pos=HexToNybble(x) << 4; //Ingen felkontroll...
		rec_state++;
		break;
	case 2:
		rec_pos+=HexToNybble(x);
		rec_state=0;
		servos[rec_servo] = rec_pos;
		UART_SendByte('0'+rec_servo);
		UART_SendByte('>');
		UART_Printfu08(servos[rec_servo]);
		UART_SendByte(' ');
		break;
	default:
		rec_state=0;
	}
}


int main(void) {

	
	//Fixar riktning p portar.
	outb(0xFF,DDRB); //Hela PORTB utgng
	outb(0x00,DDRD); //hela D ingng
	outb(0xFF,PORTD); //hela D pull-upp

	//Stter upp 1ms-2ms rknaren
	outp((1<<TOIE1), TIMSK);//Slr p TCNT1 overflow-int
	outp(0,   TCCR1A);	//Nollstllning
	outp(0,TCCR1B);		//rknaren stoppad
	//outp(1,TCCR1B);		//PRESCALER1=1, rknaren gr


	//Stter upp 20ms-rknaren
	outp((1<<TOIE0)|(1<<TOIE1),TIMSK);	//Slr p TCNT0 overflow-int
	outp(0,TCNT0);		//Nollstll rknaren 
	outp(5,TCCR0);		//PRESCALER0=1024, rknaren gr
	outp(COUNT0_20ms,TCNT0);//Interrupt om 20ms

	
	UART_Init(); //Initierar serielnk.
	
	sei();

	slinga:
		//buttons = ~(inp(PIND) & 0x7F);
		//actOnButtons();		
		
		if(UART_ReceivedChar) {
			actOnRS232();	
		}
		
	goto slinga;
}
