/* ****************************************************
Kod som skickar ut en vektor till port B.
Sedan r tanken att ett R2-stege skall gra en analog signal,
som frstrks och kopplas till en magnetmatta..
**************************************************** */
#include <io.h>
#include <interrupt.h>
#include <signal.h>
#include <progmem.h>

#define CLOCK 1000000 


#define SAMPLERATE 10000
#define VEKTORLENGTH 401
//VECTORLENGTH = antal samples som skall upprepas med frekvens LOOPFREQUENCY

#define PRESCALER0 1
//kan vara                 : 1, 8, 64, 256, 1024
//Motsvarande registervrde: 1  2   3   4     5
#define PRESCALER_REG 1

#define COUNT0 ( CLOCK/(SAMPLERATE*PRESCALER0) )
//Anger hur mycket rknaren skall rkna innan dags fr ny data ur vektorn




/* Globala variabler */
uint16_t counter;
uint8_t flashcounter;
prog_char vektor[] = {
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
	0x14, 0x14, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
	0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
	0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x16, 0x16,
	0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
	0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x17, 0x17, 0x17,
	0x17, 0x17, 0x17, 0x17, 0x16, 0x16, 0x16, 0x16,
	0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
	0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
	0x16, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x18,
	0x18, 0x19, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1F,
	0x20, 0x21, 0x23, 0x24, 0x25, 0x25, 0x26, 0x26,
	0x25, 0x25, 0x24, 0x23, 0x21, 0x20, 0x1E, 0x1D,
	0x1C, 0x1B, 0x1A, 0x19, 0x19, 0x18, 0x18, 0x18,
	0x17, 0x17, 0x18, 0x18, 0x18, 0x19, 0x19, 0x1A,
	0x1B, 0x1D, 0x1F, 0x22, 0x25, 0x28, 0x2C, 0x2F,
	0x32, 0x33, 0x34, 0x33, 0x31, 0x2E, 0x2A, 0x26,
	0x23, 0x20, 0x1E, 0x1C, 0x1B, 0x1A, 0x1A, 0x19,
	0x19, 0x1A, 0x1B, 0x1C, 0x1E, 0x21, 0x25, 0x2A,
	0x30, 0x36, 0x3C, 0x41, 0x42, 0x40, 0x3C, 0x35,
	0x2F, 0x29, 0x24, 0x20, 0x1E, 0x1C, 0x1B, 0x1B,
	0x1C, 0x1D, 0x1F, 0x23, 0x28, 0x30, 0x39, 0x43,
	0x4C, 0x50, 0x4E, 0x47, 0x3D, 0x33, 0x2B, 0x24,
	0x21, 0x1E, 0x1D, 0x1D, 0x1F, 0x22, 0x27, 0x2F,
	0x3A, 0x48, 0x56, 0x5E, 0x5C, 0x52, 0x43, 0x36,
	0x2B, 0x25, 0x21, 0x1F, 0x1F, 0x21, 0x26, 0x2E,
	0x3C, 0x4E, 0x60, 0x6C, 0x69, 0x5A, 0x46, 0x36,
	0x2A, 0x24, 0x21, 0x21, 0x24, 0x2A, 0x36, 0x49,
	0x62, 0x76, 0x79, 0x69, 0x51, 0x3B, 0x2D, 0x26,
	0x23, 0x24, 0x29, 0x34, 0x48, 0x65, 0x81, 0x88, 
	0x74, 0x56, 0x3C, 0x2D, 0x26, 0x25, 0x28, 0x32, 
	0x46, 0x68, 0x8A, 0x96, 0x7F, 0x5A, 0x3E, 0x2E, 
	0x27, 0x28, 0x2E, 0x40, 0x61, 0x8D, 0xA5, 0x91, 
	0x66, 0x43, 0x30, 0x29, 0x2A, 0x34, 0x4E, 0x7B, 
	0xA9, 0xAE, 0x83, 0x53, 0x37, 0x2C, 0x2B, 0x35, 
	0x50, 0x83, 0xB8, 0xB8, 0x83, 0x50, 0x35, 0x2D, 
	0x30, 0x42, 0x6E, 0xB0, 0xCE, 0xA2, 0x62, 0x3C, 
	0x2F, 0x31, 0x43, 0x74, 0xBE, 0xDB, 0xA3, 0x5E, 
	0x3A, 0x30, 0x37, 0x55, 0x9A, 0xE4, 0xD3, 0x81, 
	0x48, 0x34, 0x35, 0x4D, 0x8F, 0xE8, 0xE8, 0x90, 
	0x4D, 0x36, 0x38, 0x54, 0xA2, 0xFF, 0xE6, 0x82, 
	0x47};

/* Funktionsprototyper */


/* Interrupthanterare */
SIGNAL(SIG_OVERFLOW0) 			/* rknare/timer 0 */
{	
	asm volatile("wdr\n\t"::); //Nollstll watchdog timer...
	outp(255-COUNT0+inp(TCNT0),TCNT0);	//Starta om rknaren 
	outp(PRG_RDB(&vektor[counter]),PORTB);
	if(++counter >= VEKTORLENGTH) { 
		counter=0;
		if(++flashcounter >= 25) {
			flashcounter=0;
			
		}
		if(flashcounter >= 13) {
			sbi(PORTD,PD2);
		}
		else {
			cbi(PORTD,PD2);
		}
	}
	
}





/*********************[ MAIN ]********************************/

int main(void) 
{
	//Fixar riktning p portar.
	outb(0xFF,DDRB); 		//Hela PORTB utgng
	outb(0x00 | (1 << DDD2),DDRD); 		//hela D ingng utom PD2
	outb(0x8B,PORTD);		//hela D pull-upp utom PD2
	
	//Stter upp rknaren
	outp((1<<TOIE0), TIMSK);	//Slr p TCNT1 overflow-int
	outp(0,   TCNT0);			//Nollstllning
	outp(0,TCCR0);			//rknaren stoppad

	outp(PRESCALER_REG,TCCR0);	//rknaren gr

	//Stter upp watchdog
	outp(0x0B,WDTCR);

	sei();
	
	slinga:
	goto slinga;
}

/*************************************************************/


