; En klocka, som driver en LCD.
; Kristall p 4 MHz ger 1 us instruktionscykel.
; WDT timeout typiskt runtomkring 18 ms, eller 18000 instruktioner

	LIST	P=16C84
	INCLUDE	"p16c84.INC"
	
E	EQU 5	;RB5 gr till enable p LCD:n
RS	EQU 4	;RB4 gr till RS p LCD:n
TANG1	EQU 0	;RB0 R EN TANGENT-UTGNG
TANG2	EQU 1	;RB1 R EN TANGENT-UTGNG
TANG3	EQU 2	;RB2 R EN TANGENT-UTGNG
TANG4	EQU 3	;RB3 R EN TANGENT-UTGNG
TANGRET EQU 6	;RB6 R EN TANGENT-INGNG

TIMER_GOING	EQU 6	;I TOUPPDATE

MONTH_TABLE	set	(MONTHTABLE - _JAN)
DAY_TABLE	set	(DAYTABLE - _JAN)
STRING_TABLE	set	(STRINGTABLE - _JAN)
CLOCK		set	CLOCK_H
DATE		set	CLOCK_D
TIMER		set	TIMER_H
DAY		set	CLOCK_DAYNAME

	CBLOCK 0x0C
		TEMPPORTB
		CLOCK_H
		CLOCK_M
		CLOCK_S
		CLOCK_HUNDRA
		CLOCK_TUSEN
		TIMER_H
		TIMER_M
		TIMER_S
		TIMER_HUNDRA
		
		TEMPCHAR
		TEMPCHAR2
		CLOCK_DAYNAME	;00-06, MNDAG-SNDAG
		CLOCK_D		;1-31, DYGN
		CLOCK_MONTH	;0-11, MNAD
		CLOCK_YEARHIGH	;00-99, RETS HGSTA SIFFROR
		CLOCK_YEARLOW	;00-99, RETS LGSTA SIFFROR
		VIEW		;HUR DISPLAYEN SKA RITAS UPP
		TOUPPDATE	;VILKA OMRDEN SOM SKA UPPDATERAS
		ISR_TEMPW	;Anvnds av isr fr att spara info
		ISR_TEMPSTATUS  ;
		TANGFLAGS	;Vilka tangenter som r nertryckta
	ENDC

GOTOXY	MACRO	POSX, POSY
	MOVLW	0x80 + POSX + 0x40*POSY
	CALL	LCDcmd	
	ENDM
	
PTIME	MACRO	TIMEVAL, POSX, POSY
	GOTOXY	POSX, POSY
	MOVLW	TIMEVAL
	MOVWF	FSR
	CALL	PRINTTIME
	ENDM


PDATE	MACRO	DATEVAL, POSX, POSY
	GOTOXY	POSX, POSY
	MOVLW	DATEVAL
	MOVWF	FSR
	CALL	PRINTDATE
	ENDM

PDAY	MACRO	DAYVAL, POSX, POSY
	GOTOXY	POSX, POSY
	MOVLW	DAYVAL
	MOVWF	FSR
	CALL	PRINTDAY
	ENDM
;*************************************************************
; HR BRJAR KODEN

		ORG	0x000
	GOTO 	BEGINNING
		ORG	0x004

;******INTERRUPTRUTIN***********
TIMERINT			; Tar i worst case 60 us
PUSH	MOVWF	ISR_TEMPW
	SWAPF	STATUS,W
	MOVWF	ISR_TEMPSTATUS

	CLRWDT
	
	MOVLW	8
	ADDWF	TMR0,F
	
;UPPDATERA*TIDEN*****
;1/4000
	INCF	CLOCK_TUSEN,F
	MOVF	CLOCK_TUSEN,W
	SUBLW	D'39'
	BTFSC	STATUS,C
	GOTO	UPPDATEDONE
	CLRF	CLOCK_TUSEN

;1/100
	MOVF	CLOCK_HUNDRA,W
	ADDLW	1
	MOVWF	CLOCK_HUNDRA
	SUBLW	D'99'
	BTFSC	STATUS,C
	GOTO	NORMAL
	CLRF	CLOCK_HUNDRA

;sek
	MOVF	CLOCK_S,W
	ADDLW	1
	MOVWF	CLOCK_S
	SUBLW	D'59'
	BTFSC	STATUS,C
	GOTO	NORMAL
	CLRF	CLOCK_S

;min
	MOVF	CLOCK_M,W
	ADDLW	1
	MOVWF	CLOCK_M
	SUBLW	D'59'
	BTFSC	STATUS,C
	GOTO	NORMAL
	CLRF	CLOCK_M
	
;timme
	MOVF	CLOCK_H,W
	ADDLW	1
	MOVWF	CLOCK_H
	SUBLW	D'23'
	BTFSC	STATUS,C
	GOTO	NORMAL
	CLRF	CLOCK_H

;dygn	0219
	BSF	TOUPPDATE,7
	MOVF	CLOCK_D,W
	ADDLW	1
	MOVWF	CLOCK_D

	MOVLW	MONTH_TABLE
	ADDWF	CLOCK_MONTH,W
	CALL	GETCHAR
	ADDLW	1
	SUBWF	CLOCK_D,W
	BTFSC	STATUS,C
	GOTO	NORMAL
	MOVLW	1
	MOVWF	CLOCK_MONTH

NORMAL

	;DAGS FR NEDRKNING
	BTFSS	TOUPPDATE,TIMER_GOING
	GOTO	NORMAL2
;1/100	
	DECF	TIMER_HUNDRA,F
	MOVF	TIMER_HUNDRA,W
	XORLW	-1
	BTFSS	STATUS,Z
	GOTO	NORMAL3
	MOVLW	D'100'
	MOVWF	TIMER_HUNDRA
;sek
	BSF	TOUPPDATE,1

	DECF	TIMER_S,F
	MOVF	TIMER_S,W	
	XORLW	-1
	BTFSS	STATUS,Z
	GOTO	NORMAL3
	MOVLW	D'59'
	MOVWF	TIMER_S
;min	
	DECF	TIMER_M,F
	MOVF	TIMER_M,W	
	XORLW	-1
	BTFSS	STATUS,Z
	GOTO	NORMAL3
	MOVLW	D'59'
	MOVWF	TIMER_M
;timme
	DECF	TIMER_H,F
	MOVF	TIMER_H,W	
	XORLW	-1
	BTFSS	STATUS,Z
	GOTO	NORMAL3
	CLRF	TIMER_H
	CLRF	TIMER_M
	CLRF	TIMER_S
	CLRF	TIMER_HUNDRA
	BCF	TOUPPDATE,TIMER_GOING
	
NORMAL3

NORMAL2
	MOVF	CLOCK_HUNDRA,W
	BTFSS	STATUS,Z
	GOTO	UPPDATEDONE
	BSF	TOUPPDATE,0

UPPDATEDONE;*********

	BCF	INTCON,T0IF
	CLRWDT


POP 	SWAPF	ISR_TEMPSTATUS,W
	MOVWF	STATUS
	SWAPF	ISR_TEMPW,F
	SWAPF	ISR_TEMPW,W
	RETFIE
;*******************************








BEGINNING

;*****INIT*PORTS****************
	CLRF	INTCON
	BSF	STATUS,RP0	;BANK 1
	MOVLW	b'11111111'	;RESETSTATUS P PRESCALER,TIMER
	MOVWF	OPTION_REG
	BCF	STATUS,RP0	;BANK 0	
	CLRF	INTCON

	CLRF 	PORTB
	CLRF	PORTA
	BSF 	STATUS, RP0 	;BANK 1
	MOVLW 	B'11000000'	;RB<5:0> OUTPUTS
	MOVWF 	TRISB 		;RB<7:6> INPUTS
	CLRF	TRISA		;RA<4:0> OUTPUTS
	BCF	STATUS,RP0	;BANK 0
;*******************************

;*****INIT*VARS*****************
	MOVLW	0x0C
	MOVWF	FSR
	MOVLW	D'36'
CLEAR_RAM
	CLRF	INDF
	INCF	FSR,F
	ADDLW	-1
	BTFSS	STATUS,Z
	GOTO	CLEAR_RAM	
	
	MOVLW	1
	MOVWF	CLOCK_D
	MOVWF	CLOCK_MONTH
	MOVWF	VIEW
	MOVLW	D'19'
	MOVWF	CLOCK_YEARHIGH
	MOVLW	D'98'
	MOVWF	CLOCK_YEARLOW
;*******************************

;*****INIT*DISPLAY**************	
	MOVLW	D'15'
	CALL	DELAYms

	MOVLW	3
	MOVWF	PORTB
	CALL    PULSEE
	
	MOVLW	5
	CALL 	DELAYms
	CALL 	PULSEE

	MOVLW	1
	CALL 	DELAYms
	CALL	PULSEE

	MOVLW	5
	CALL 	DELAYms
	MOVLW	2
	MOVWF	PORTB
	CALL 	PULSEE
	
	MOVLW	1
	CALL	DELAYms
	MOVLW	B'00101000'
	CALL 	LCDcmd

	MOVLW	1
	CALL	DELAYms
	MOVLW	B'00001000' ;DISP OFF, CRSR OFF, BLINK OFF
	CALL	LCDcmd

	MOVLW	1
	CALL	DELAYms
	MOVLW	B'00000001' ;CLE SCR, CRSR HOME
	CALL	LCDcmd

	MOVLW	2
	CALL	DELAYms
	MOVLW	B'00000110' ;INC CRSR TO THE RIGHT WHEN WRITING
	CALL	LCDcmd	    ;DONT SHIFT SCREEN

	MOVLW	1
	CALL	DELAYms

	MOVLW	B'00001100'
	CALL	LCDcmd		;TURNS SCREEN ON
;************
;Egna fonter
	MOVLW	0x40
	CALL	LCDcmd
	MOVLW	STRING_TABLE
	MOVWF	FSR
	CALL	PRINTSTRING
;*******************************

;*****TMR0*PRESCALER*INTERRUPT**
INIT_TIMER
	CLRWDT			;Clear WDT and prescaler
	BSF	STATUS,RP0	;BANK 1
	MOVLW	b'11011111'	;Select TMR0, no prescaler
	MOVWF	OPTION_REG
	BCF	STATUS,RP0	;BANK 0

	MOVLW	B'10100000'
	MOVWF	INTCON		;ENABLE TIMER INTERRUPTS
;*******************************


VIEW_CLOCK
	MOVLW	0x81
	IORWF	TOUPPDATE,F ;Ska uppdatera klockan och datum direkt

	MOVLW	0x01
	CALL	LCDcmd
	CALL	DELAY
	CALL	DELAY
VIEW1			;efter 194 ms kommer man hit frsta gngen
	CLRWDT
	BTFSS	TOUPPDATE,0
	GOTO	LABEL1_1
	PTIME	CLOCK,0,0
	BCF	TOUPPDATE,0

LABEL1_1
	BTFSS	TOUPPDATE,7
	GOTO	LABEL1_2
	PDAY	DAY,0,1
	PDATE	DATE,8,1
	BCF	TOUPPDATE,7

LABEL1_2

	CALL	UPPDATETANGFLAGS
	BTFSS	TANGFLAGS,TANG4+4
	BTFSS	TANGFLAGS,TANG4
	GOTO	VIEW1
;********************

VIEW_TIMER
	MOVLW	0x03
	IORWF	TOUPPDATE,F ;Ska uppdatera klockan och timern

	MOVLW	0x01	;CLE SCR
	CALL	LCDcmd
	CALL	DELAY
	CALL	DELAY

	MOVLW	STRING_TABLE
	MOVWF	FSR
	MOVLW	2		;->'nedrkning'
	CALL	SCANSTRINGS
	CALL	PRINTSTRING
	GOTOXY	0,1
	MOVLW	STRING_TABLE
	MOVWF	FSR
	MOVLW	3
	CALL	SCANSTRINGS
	CALL	PRINTSTRING
	MOVLW	STRING_TABLE
	MOVWF	FSR
	MOVLW	4
	CALL	SCANSTRINGS
	CALL	PRINTSTRING
	
	
VIEW2	
	CLRWDT
	BTFSS	TOUPPDATE,1
	GOTO	LABEL2_2
	PTIME	TIMER,0x0C,0
	BCF	TOUPPDATE,1
LABEL2_2
	CALL	UPPDATETANGFLAGS

	BTFSS	TANGFLAGS,TANG1
	GOTO	LABEL2_3
	BSF	TOUPPDATE,TIMER_GOING	;START

LABEL2_3
	BTFSS	TANGFLAGS,TANG2	
	GOTO	LABEL2_4
	BCF	TOUPPDATE,TIMER_GOING	;STOPP
	
LABEL2_4
	BTFSS	TANGFLAGS,TANG3
	GOTO	LABEL2_5
	GOTOXY	0, 1			;NDRA
	MOVLW	STRING_TABLE
	MOVWF	FSR
	MOVLW	5
	CALL	SCANSTRINGS
	CALL	PRINTSTRING

LABEL2_4_1
	CALL	DELAY
	CALL	UPPDATETANGFLAGS
	BTFSC	TANGFLAGS,TANG3+4
	GOTO	LABEL2_4_1

VIEW2_2
	BTFSS	TOUPPDATE,1
	GOTO	LABEL2_2_1
	PTIME	TIMER,0x0C,0
	BCF	TOUPPDATE,1
LABEL2_2_1
	CALL	UPPDATETANGFLAGS
	MOVF	TANGFLAGS,W
	BTFSC	STATUS,Z
	GOTO	VIEW2_2
	BSF	TOUPPDATE,1

	MOVLW	0xF0
	ANDWF	TANGFLAGS,W
	BTFSC	STATUS,Z
	GOTO	LABEL2_2_0
	MOVLW	D'255'
	CALL	DELAYms
	CALL	UPPDATETANGFLAGS
LABEL2_2_0
	
	BTFSS	TANGFLAGS,TANG1
	GOTO	LABEL2_2_2
	INCF	TIMER_H,F
	MOVF	TIMER_H,W
	SUBLW	D'99'
	BTFSC	STATUS,C
	GOTO	VIEW2_2
	MOVLW	D'00'
	MOVWF	TIMER_H
LABEL2_2_2
	BTFSS	TANGFLAGS,TANG2
	GOTO	LABEL2_2_3
	INCF	TIMER_M,F
	MOVF	TIMER_M,W
	SUBLW	D'59'
	BTFSC	STATUS,C
	GOTO	VIEW2_2
	MOVLW	D'00'
	MOVWF	TIMER_M
LABEL2_2_3
	BTFSS	TANGFLAGS,TANG3
	GOTO	LABEL2_2_4
	INCF	TIMER_S,F
	MOVF	TIMER_S,W
	SUBLW	D'59'
	BTFSC	STATUS,C
	GOTO	VIEW2_2
	MOVLW	D'00'
	MOVWF	TIMER_S
LABEL2_2_4
	BTFSS	TANGFLAGS,TANG4+4
	BTFSS	TANGFLAGS,TANG4
	GOTO	VIEW2_2
	GOTO	VIEW_TIMER


LABEL2_5
	BTFSS	TANGFLAGS,TANG4+4
	BTFSS	TANGFLAGS,TANG4
	GOTO	VIEW2
;********************
VIEW_ALARM
;	MOVLW	0x01	;CLE SCR
;	CALL	LCDcmd
;	CALL	DELAY
;	CALL	DELAY
;VIEW3
;
;	CALL	UPPDATETANGFLAGS
;	BTFSS	TANGFLAGS,TANG4+4
;	BTFSS	TANGFLAGS,TANG4
;	GOTO	VIEW3
;********************
VIEW_INST
	MOVLW	0x01
	CALL	LCDcmd
	CALL	DELAY
	CALL	DELAY

	GOTOXY	0, 1			;NDRA MENYRAD
	MOVLW	STRING_TABLE
	MOVWF	FSR
	MOVLW	5
	CALL	SCANSTRINGS
	CALL	PRINTSTRING

	BCF	INTCON,GIE
	BCF	INTCON,GIE
	BCF	INTCON,GIE	;0219
	
	CLRF	CLOCK_HUNDRA

VIEW9
	CLRWDT
	BTFSS	TOUPPDATE,0
	GOTO	LABEL9_1
	PTIME	CLOCK,0x06,0
	BCF	TOUPPDATE,0
LABEL9_1
	CALL	UPPDATETANGFLAGS
	MOVF	TANGFLAGS,W
	BTFSC	STATUS,Z
	GOTO	VIEW9
	BSF	TOUPPDATE,0
	
	MOVLW	0xF0
	ANDWF	TANGFLAGS,W
	BTFSC	STATUS,Z
	GOTO	LABEL9_0
	MOVLW	D'255'
	CALL	DELAYms
	CALL	UPPDATETANGFLAGS
LABEL9_0

	BTFSS	TANGFLAGS,TANG1
	GOTO	LABEL9_2
	INCF	CLOCK_H,F
	MOVF	CLOCK_H,W
	SUBLW	D'23'
	BTFSC	STATUS,C
	GOTO	VIEW9
	MOVLW	D'00'
	MOVWF	CLOCK_H
LABEL9_2
	BTFSS	TANGFLAGS,TANG2
	GOTO	LABEL9_3
	INCF	CLOCK_M,F
	MOVF	CLOCK_M,W
	SUBLW	D'59'
	BTFSC	STATUS,C
	GOTO	VIEW9
	MOVLW	D'00'
	MOVWF	CLOCK_M
LABEL9_3
	BTFSS	TANGFLAGS,TANG3
	GOTO	LABEL9_4
	INCF	CLOCK_S,F
	MOVF	CLOCK_S,W
	SUBLW	D'59'
	BTFSC	STATUS,C
	GOTO	VIEW9
	MOVLW	D'00'
	MOVWF	CLOCK_S
LABEL9_4

	BTFSS	TANGFLAGS,TANG4+4
	BTFSS	TANGFLAGS,TANG4
	GOTO	VIEW9
	BSF	INTCON,GIE
	GOTO	VIEW_CLOCK

;*****ALLMNN*UPPDATERARE*******

;*******************************




;************SUBRUTINER**********************
;******KOLLA*TANGENTER**********
UPPDATETANGFLAGS
	CLRWDT
	SWAPF	TANGFLAGS,F
	MOVLW	B'11110000'
	ANDWF	TANGFLAGS,F
	MOVLW	B'00001111'
	IORWF	PORTB,F
	NOP
	NOP
	BTFSS	PORTB,TANGRET
	GOTO	LABEL3

;NGON TANGENT
	BCF	PORTB,TANG1
	NOP
	NOP
	BTFSS	PORTB,TANGRET
	BSF	TANGFLAGS,TANG1
	BCF	PORTB,TANG2
	BSF	PORTB,TANG1
	NOP
	NOP
	BTFSS	PORTB,TANGRET
	BSF	TANGFLAGS,TANG2
	BCF	PORTB,TANG3
	BSF	PORTB,TANG2
	NOP
	NOP
	BTFSS	PORTB,TANGRET
	BSF	TANGFLAGS,TANG3
	BCF	PORTB,TANG4
	BSF	PORTB,TANG3
	NOP
	NOP
	BTFSS	PORTB,TANGRET
	BSF	TANGFLAGS,TANG4
LABEL3
	RETURN
;*******************************


PULSEE	BSF	PORTB, E

	MOVLW	D'200'		; c:a 1000 us
PULSEE_DELAY1
	CLRWDT
	ADDLW	-1
	BTFSS	STATUS,Z
	GOTO	PULSEE_DELAY1

	BCF	PORTB, E

	MOVLW	D'200'		; c:a 1000 us
PULSEE_DELAY2
	CLRWDT
	ADDLW	-1
	BTFSS	STATUS,Z
	GOTO	PULSEE_DELAY2

	RETURN
;*******************************

DELAY	MOVLW	D'200'		; c:a 1000 us
DELAY_LOOPEN
	CLRWDT
	ADDLW	-1
	BTFSS	STATUS,Z
	GOTO	DELAY_LOOPEN
	
	RETURN
;*******************************

DELAYms	SUBLW	0
LOOPEN	
	MOVWF	TEMPCHAR
	CALL 	DELAY
	MOVF	TEMPCHAR,W
	ADDLW	1
	BTFSS	STATUS,Z
	GOTO 	LOOPEN
	RETURN
;*******************************
WrLCD	MOVWF	TEMPPORTB
	MOVLW	B'11010000'
	ANDWF	PORTB,F
	SWAPF	TEMPPORTB,W
	ANDLW	0x0F
	IORWF	PORTB,F
	CALL 	PULSEE
	MOVLW	B'11010000'
	ANDWF	PORTB,F
	MOVF	TEMPPORTB,W
	ANDLW	0x0F
	IORWF	PORTB,F
	CALL	PULSEE
	RETURN
;*******************************
LCDcmd	BCF PORTB, RS
	CALL WrLCD
	BSF PORTB, RS
	RETURN
;*******************************
PRINTTIME
	CALL	ZPRINT2POS
	MOVLW	':'
	CALL	WrLCD
	INCF	FSR,F
	CALL	ZPRINT2POS
	MOVLW	'.'
	CALL	WrLCD
	INCF	FSR,F
	CALL	ZPRINT2POS
	RETURN
;*******************************
PRINTDATE
	CALL	BPRINT2POS
	MOVLW	' '
	CALL	WrLCD

	INCF	FSR,F
	MOVF	INDF,W
	ADDWF	INDF,W
	ADDWF	INDF,W
	ADDLW	-3
	MOVWF	TEMPCHAR	;=3*MNAD=OFFSET FR GETCHAR
	CALL	GETCHAR
	CALL	WrLCD
	INCF	TEMPCHAR,F
	MOVF	TEMPCHAR,W
	CALL	GETCHAR
	CALL	WrLCD
	INCF	TEMPCHAR,F
	MOVF	TEMPCHAR,W
	CALL	GETCHAR
	CALL	WrLCD
	MOVLW	0x20
	CALL	WrLCD
	INCF	FSR,F
	CALL	BPRINT2POS
	INCF	FSR,F
	CALL	ZPRINT2POS
	RETURN
;*******************************
;******PRINT*DAY****************
PRINTDAY
	MOVLW	DAY_TABLE
	MOVWF	FSR
	MOVF	CLOCK_DAYNAME,W
	CALL	SCANSTRINGS
	CALL	PRINTSTRING
	RETURN
;*******************************	
	
	
;*******************************
ZPRINT2POS	;TALET ATT SKRIVA UT MSTE FINNAS I INDF
	MOVF	INDF,W
	CALL	TIOSIFF
	CALL	WrLCD
	CALL	ENSIFF
	CALL	WrLCD
	RETURN
;*******************************
BPRINT2POS	;TALET ATT SKRIVA UT MSTE FINNAS I INDF
	MOVF	INDF,W
	CALL	TIOSIFF
	MOVWF	TEMPCHAR
	SUBLW	0x30
	MOVLW	0x20
	BTFSS	STATUS,Z       ;MELLANSLAG OM FRSTA SIFFRA EN NOLLA
	MOVF	TEMPCHAR,W
	CALL	WrLCD
	CALL	ENSIFF
	CALL	WrLCD
	RETURN
;*******************************
SCANSTRINGS			;Gr till strng nr W frn FSR
	ANDLW	0xFF
	BTFSC	STATUS,Z
	RETURN			;Om w=0 s grs inget
	MOVWF	TEMPCHAR2
NEWSTRING
	CLRWDT			;W = 1 gr fram till nsta, w = 2...
	MOVF	FSR,W
	CALL	GETCHAR
	INCF	FSR,F
	XORLW	0xFE
	BTFSS	STATUS,Z
	GOTO	CONTINUE
	DECFSZ	TEMPCHAR2,F
	GOTO	NEWSTRING
	RETURN
CONTINUE
	GOTO	NEWSTRING	
;*******************************
PRINTSTRING
	MOVF	FSR,W
	CALL	GETCHAR
	XORLW	0xFE		;tecken 0xFE r sluttecken
	BTFSC	STATUS,Z
	GOTO	PRINTSTRING_DONE
	XORLW	0xFE
	CALL	WrLCD
	INCFSZ	FSR,F		;ska alldrig bli overflow, men bra att ha
	GOTO	PRINTSTRING
PRINTSTRING_DONE
	RETURN
;*******************************
TIOSIFF
	MOVWF	TEMPPORTB
	MOVLW	0x30	;OFFSET TILL '0' I ASCII
	MOVWF	TEMPCHAR
	MOVLW	D'10'

TIOSIFF2
	SUBWF	TEMPPORTB,F
	BTFSC	STATUS,Z
	GOTO 	WAS_ZERO
	BTFSS	STATUS,C
	GOTO	WAS_SIGNED
	INCF	TEMPCHAR,F
	GOTO	TIOSIFF2

WAS_ZERO
	INCF	TEMPCHAR,F
	MOVLW	D'10'
	SUBWF	TEMPPORTB,F
WAS_SIGNED
	MOVF	TEMPPORTB,W
	ADDLW	D'10'
	MOVWF	TEMPCHAR2
	MOVF	TEMPCHAR,W
	RETURN
;*******************************
ENSIFF	;OBS TIOSIFF MSTE HA ANROPATS INNAN MED SAMMA TAL.
	MOVF	TEMPCHAR2,W
	ADDLW	0x30
	RETURN
;*******************************


;*****KONSTANTER*STRNGAR*MM****

		ORG	0x300
GETCHAR	;RETURNERAR TECKEN NR w I w
	MOVWF	TEMPCHAR
	MOVLW	3
	MOVWF	PCLATH
	MOVF	TEMPCHAR,W
	ADDWF	PCL,F
_JAN	RETLW	'J'
	RETLW	'a'
	RETLW	'n'
_FEB	RETLW	'F'
	RETLW	'e'
	RETLW	'b'
_MAR	RETLW	'M'
	RETLW	'a'
	RETLW	'r'
_APR	RETLW	'A'
	RETLW	'p'
	RETLW	'r'
_MAJ	RETLW	'M'
	RETLW	'a'
	RETLW	'y'
_JUN	RETLW	'J'
	RETLW	'u'
	RETLW	'n'
_JUL	RETLW	'J'
	RETLW	'u'
	RETLW	'l'
_AUG	RETLW	'A'
	RETLW	'u'
	RETLW	'g'
_SEP	RETLW	'S'
	RETLW	'e'
	RETLW	'p'
_OKT	RETLW	'O'
	RETLW	'k'
	RETLW	't'
_NOV	RETLW	'N'
	RETLW	'o'
	RETLW	'v'
_DEC	RETLW	'D'
	RETLW	'e'
	RETLW	'c'
MONTHTABLE
	RETLW	D'31'
	RETLW	D'29'  ;SKOTTR BEHANDLAS FR SIG I PROGRAMMET. 0219
	RETLW	D'31'
	RETLW	D'30'
	RETLW	D'31'
	RETLW	D'30'
	RETLW	D'31'
	RETLW	D'31'
	RETLW	D'30'
	RETLW	D'31'
	RETLW	D'30'
	RETLW	D'31'
DAYTABLE
	RETLW	'm'
	RETLW	0x03;''
	RETLW	'n'
	RETLW	'd'
	RETLW	'a'
	RETLW	'g'
	RETLW	0xFE
	RETLW	't'
	RETLW	'i'
	RETLW	's'
	RETLW	'd'
	RETLW	'a'
	RETLW	'g'
	RETLW	0xFE
	RETLW	'o'
	RETLW	'n'
	RETLW	's'
	RETLW	'd'
	RETLW	'a'
	RETLW	'g'
	RETLW	0xFE
	RETLW	't'
	RETLW	'o'
	RETLW	'r'
	RETLW	's'
	RETLW	'd'
	RETLW	'a'
	RETLW	'g'
	RETLW	0xFE
	RETLW	'f'
	RETLW	'r'
	RETLW	'e'
	RETLW	'd'
	RETLW	'a'
	RETLW	'g'
	RETLW	0xFE
	RETLW	'l'
	RETLW	0xEF	;''
	RETLW	'r'
	RETLW	'd'
	RETLW	'a'
	RETLW	'g'
	RETLW	0xFE
	RETLW	's'
	RETLW	0xEF	;''
	RETLW	'n'
	RETLW	'd'
	RETLW	'a'
	RETLW	'g'
	RETLW	0xFE
STRINGTABLE
	RETLW	B'00000001'
	RETLW	B'00000011'
	RETLW	B'00001111'
	RETLW	B'00001111'
	RETLW	B'00001111'
	RETLW	B'00000011'
	RETLW	B'00000001'
	RETLW	B'00000000'

	RETLW	B'00011111'
	RETLW	B'00000100'
	RETLW	B'00000100'
	RETLW	B'00011111'
	RETLW	B'00011111'
	RETLW	B'00011111'
	RETLW	B'00011111'
	RETLW	B'00000000'

	RETLW	B'00011011'
	RETLW	B'00001010'
	RETLW	B'00001010'
	RETLW	B'00001010'
	RETLW	B'00001010'
	RETLW	B'00001010'
	RETLW	B'00011011'
	RETLW	B'00000000'

	RETLW	B'00000100'
	RETLW	B'00001010'
	RETLW	B'00000100'
	RETLW	B'00001110'
	RETLW	B'00000001'
	RETLW	B'00001111'
	RETLW	B'00010001'
	RETLW	B'00001111'

	RETLW	0xFE
;1
	RETLW	0x5B
	RETLW	0x00
	RETLW	' '
	RETLW	0x01
	RETLW	' '
	RETLW	'A'	
	RETLW	0x5D
	RETLW	0xFE
;2
	RETLW	'n'
	RETLW	'e'
	RETLW	'd'
	RETLW	'r'
	RETLW	0xE1 ; ''
	RETLW	'k'
	RETLW	'n'
	RETLW	'i'
	RETLW	'n'
	RETLW	'g'
	RETLW	':'
	RETLW	0xFE
;3	
	RETLW	0x5B
	RETLW	's'
	RETLW	't'
	RETLW	'a'
	RETLW	'r'
	RETLW	't'
	RETLW	0x5D
	RETLW	0x5B
	RETLW	's'
	RETLW	't'
	RETLW	'o'
	RETLW	'p'
	RETLW	0x5D
	RETLW	0xFE
;4
	RETLW	0x5B
	RETLW	0xE1 ; ''
	RETLW	'n'
	RETLW	'd'
	RETLW	'r'
	RETLW	'a'
	RETLW	0x5D
	RETLW	0xFE
;5
	RETLW	0x5B
	RETLW	't'
	RETLW	'i'
	RETLW	'm'
	RETLW	'm'
	RETLW	'e'
	RETLW	0x02
	RETLW	'm'
	RETLW	'i'
	RETLW	'n'
	RETLW	'u'
	RETLW	't'
	RETLW	0x02
	RETLW	's'
	RETLW	'e'
	RETLW	'k'
	RETLW	'u'
	RETLW	'n'
	RETLW	'd'
	RETLW	0x5D
	RETLW	0xFE

	RETLW	0x5B
	RETLW	'u'
	RETLW	'p'
	RETLW	'p'
	RETLW	0x5D
	RETLW	' '
	RETLW	' '
	RETLW	0x5B
	RETLW	'n'
	RETLW	'e'
	RETLW	'r'
	RETLW	0x5D
	RETLW	0xFE

;	RETLW	0x5B
;	RETLW	't'
;	RETLW	'a'
;	RETLW	' '
;	RETLW	'b'
;	RETLW	'o'
;	RETLW	'r'
;	RETLW	't'
;	RETLW	0x02
;	RETLW	'n'
;	RETLW	'y'
;	RETLW	0x5D	
;	RETLW	' '
;	RETLW	0x5B
;	RETLW	' '
;	RETLW	0xFE

;	RETLW	0x5B
;	RETLW	'v'
;	RETLW	0xE1 ; ''	
;	RETLW	'l'
;	RETLW	'j'
;	RETLW	0x5D
;	RETLW	0xFE
	
	


;*******************************
	END
