MODEL TINY               ;tasm startfil /s
.SEQ
IDEAL
LOCALS
P386
;*****************************************
StackSize=16384 ;stackens storlek
ExtraSize=512   ;minne som ska finnas direkt efter end_resident. (diskbuffer)
ReservedSize=StackSize+ExtraSize
ideal
struc BootBlkTable
    DUMMYS DB ?,?,?
    OEMNameVersion     db 8 dup (?)   ;8bytes  Namn och version and version
    BytesPerSector     dw ?           ;word    Bytes per sektor
    NumberOfSectors    dd ?           ;dword   Totala antalet sektors
    SectorsPerTrack    dw ?           ;word    Sektorer per track
    NumberOfHeads      dw ?           ;word    Antal heads
    DirectoryOffset    dd ?           ;dword   Sektor som "innehller" rooten
    StartFileOffset    dd ?           ;dword   Sektor dr startfilen brjar
    StartFileLength    dw ?           ;word    Startfilens lngd i sektorer
    AllocatorOffset    dd ?           ;dword   Sektor fr disk-systemet
    AllocatorLength    dw ?           ;word    Lngd p dito
ends

STRUC DIRECTORY_ENTRY
        FILENAME        DB 16 DUP (?)
        FATOFFSET       DD (?)
        ATTRIB          DB (?)
        DUMMYS          DB 11 DUP (?)
ENDS
ATTRIB_DATA = 'D'
ATTRIB_EXEC = 'E'
ATTRIB_DIR  = '>'  ;ST;DS INTE N

FATLAST = -1
FATFREE = 0

STRUC   MEMORY
        USERBASE DW ?
        USERTOPP DW 9FFFh
        total    dd 655360
ENDS
masm
MEMORY struc
        USERBASE DW ?
        USERTOPP DW 9FFFh
        total    dd 655360
ENDS
ideal

MACRO TECKEN CHAR:REST
        PUSH AX
        MOV AL,CHAR
        MOV AH,PRINT_CHAR
        INT 20H
        POP AX
ENDM
MACRO STRING TEXT
LOCAL @@TEXTEN, @@HOPPET
        JMP @@HOPPET

    @@TEXTEN DB TEXT,0
    @@HOPPET:
        PUSH AX DS SI
        PUSH CS
        POP DS
        MOV SI,OFFSET @@TEXTEN
        MOV AH,PRINT_STRING
        INT 20H
        POP SI DS AX
ENDM
;*****************************************
enum OSFUNC {
INST_DRIVER    =  0H
EXITPROG
reserved02
GET_KEY
GET_KEY_ECHO
PRINT_CHAR
GET_STRING
PRINT_STRING
CHECK_FOR_INPUT
READSECTOR
WRITESECTOR
CHECK_FAT_FOR_NEXT
CHECK_FAT_FOR_FREE
WRITE_FAT
CREATE_FILE
DELETE_FILE
reserved10
reserved11
reserved12
reserved13
reserved14
reserved15
FIND
LASTITEM
}
segment seg0000 at 0000h
org 78h
	label int1E
org 80h
	label int20
org 40Eh
        label segEBDA
org 522h
	label DiskInitTable
org 700h
	label OSMemStart
ends
;*****************************************
segment code para use16
assume cs:code, ds:code
org 0
_start:
;s'tter upp en	stack
push cs
pop ss
mov sp,0FFFEh

;fixar	dataseg
push	cs
pop	ds

;sparar vilken	enhet operativsystemet startats	fr[n
mov [DriveNumber],dl

;Kopierar INT1E-table
push ds
mov ax,0
mov es,ax
assume es:seg0000
mov si,[es:int1E+0]
mov ax,[es:int1E+2]
mov ds,ax
push cs
pop es
mov di,offset INT1ETABLE
mov cx,14
cld
rep movsb
pop ds

;skriver frdigt "minne"
;int 12h            ;min bios ger ett knepigt vrde
;MOV EAX,640
;shl eax,10
;mov [cs:minne.total],eax


;Flyttar det som ska bli resident till	0070:0000h
mov ax,0
mov es,ax
assume es:seg0000
mov si,offset _start_resident
mov di,offset OSMemStart
mov cx, _end_resident-_start_resident
cld
rep movsb

;pekar	INT 20h	--> _OSINT och   INT1E -> INT1ETABLE
mov [word ptr es:0+int20], offset _OSINT
mov [word ptr es:2+int20], 70h - (_start_resident - _start)/16
mov [word ptr es:0+int1E], offset INT1ETABLE - offset _start_resident
mov [word ptr es:2+int1E], 70h


;skriver ett meddelande
mov si,offset Meddelande
MOV AH, PRINT_STRING
INT 20H

;S'TTER UPP STACKEN
mov ax,0
mov ss,ax
mov sp,700h+ReservedSize + (_end_resident - _start_resident)

;KOPIERAR VISSA VARIABLER FRN BOOTBLOCKET
        MOV [cs:RetriesCounter],9
    @COPY_BBLK:
        PUSH 70h - (_start_resident - _start)/16
        POP ES
        MOV BX,OFFSET _disk_buffer
        MOV AX,0201H
        MOV CX,0001H
        MOV DX,0000H
        INT 13H

        JNC  @KLAR_COPYING
        ;nu ska vi skta om ett fel.
        MOV     AH,0
        INT     13h  ;resets disk
        DEC     [cs:RetriesCounter]
        JNZ     @COPY_BBLK
        JMP     @QUIT_ANYWAY    ;DETTA R INTE HELT NDVNDIGT,
                                ;S VI BRYR OSS INTE.

    @KLAR_COPYING:
        MOV EAX,[ES:BX+BootBlkTable.ALLOCATOROFFSET]
        MOV [CS:ALL_OFFS],EAX
        MOV AX,[ES:BX+BootBlkTable.ALLOCATORLENGTH]
        MOV [CS:ALL_LENGTH],AX
        MOV EAX,[ES:BX+BootBlkTable.DIRECTORYOFFSET]
        MOV [CS:DIR_OFFSET],EAX
        MOV EAX,[ES:BX+BootBlkTable.NumberOfSectors]
        MOV [CS:cylinders],EAX
        MOV AX,[ES:BX+BootBlkTable.SectorsPerTrack]
        MOV [CS:sec_per_track],AX
        MOV AX,[ES:BX+BootBlkTable.NumberOfHeads]
        MOV [CS:heads],AX

    @QUIT_ANYWAY:
;==============================================
@ungate_a20:
        cli
        call   empty_8042
        jnz    gate_a20_01
        mov    al,0D1h
        out    64H,al
        call   empty_8042
        jnz    gate_a20_01
        mov    al,0DFh
        out    60H,al
        call   empty_8042
gate_a20_01:
        CMP AL,0
        JNE @a20error
        MOV SI,OFFSET A20SUCCESS
        MOV AH,PRINT_STRING
        PUSHF
        PUSH CS
        PUSH OFFSET START_OS
        JMP  _OSINT

       @a20error:
        MOV SI,OFFSET A20ERROR
        MOV AH,PRINT_STRING
        PUSHF
        PUSH CS
        PUSH OFFSET START_OS
        JMP  _OSINT

        A20ERROR DB 'Gick inte att lsa upp a20',13,10,0
        A20SUCCESS DB 'A20 enabled',13,10,0
empty_8042:
        push   cx
        sub    cx,cx
empty_8042_01:
        in     al,64H
        and    al,00000010b
        loopnz empty_8042_01
        pop    cx
        ret
;==============================================
START_OS:

        db 0EAh  ;FAR JMP to start_commander
        dw offset _start_commander
        dw 70h - (_start_resident - _start)/16

jmp $
;****************************************************************************
;****************************************************************************
;****************************************************************************
;****************************************************************************

align 16
_start_resident:
MINNE MEMORY {USERBASE=70H + (_end_resident - _start_resident \
                       + 15 + ReservedSize)/16}

align 16
_OSINT:     ;<-- Hit gr alla INT 20h
        cmp ah, LASTITEM
        jl  @giltig_funktion
        MOV AX,-1
        IRET
   @giltig_funktion:
        PUSH BX
        mov bx,ax
        shr bx,7
        and bl,not 1
        jmp [WORD PTR cs:bx+offset @jumptable1]
   @jumptable1:
        dw OFFSET @funk_00
        dw OFFSET @funk_01
        dw OFFSET @funk_02
        dw OFFSET @funk_03
        dw OFFSET @funk_04
        dw OFFSET @funk_05
        dw OFFSET @funk_06
        dw OFFSET @funk_07
        dw OFFSET @funk_08
        dw OFFSET @funk_09
        dw OFFSET @funk_0A
        dw OFFSET @funk_0B
        dw OFFSET @funk_0C
        dw OFFSET @funk_0D
        dw OFFSET @funk_0E
        dw OFFSET @funk_0F
        dw OFFSET @funk_10
        dw OFFSET @funk_11
        dw OFFSET @funk_12
        dw OFFSET @funk_13
        dw OFFSET @funk_14
        dw OFFSET @funk_15
        dw OFFSET @funk_16
;******************************************
;******************************************
@funk_00: ;INST_DRIVER
        ;flyttar upp MINNE.USERBASE BX paragrafer
        ;s att BX paragrafer blir residenta
        ;AX = 0 om det gick, -1 om det inte gick
        POP BX
        push bx
        add bx,[cs:minne.userbase]
        jc @@ERROR_00
        cmp [cs:minne.usertopp],bx
        jl @@ERROR_00
        MOV AX,0
        jmp @@KLAR_00
     @@ERROR_00:
        mov ax,-1

     @@KLAR_00:
        pop bx
        IRET
@funk_01: ;EXITPROG
        MOV AX,0      ;BERTTAR ATT PROGRAMMET GICK ATT KRA
        db 0EAh  ;FAR JMP to start_commander
        dw offset _start_commander
        dw 70h - (_start_resident - _start)/16
        
@funk_02: ;             ledig
        mov ax,-1
        POP BX
        IRET
@funk_03: ;GET_KEY
        ;on return:
        ;AH = keyboard scan code
        ;AL = ASCII character or zero if special function key
        MOV AH,00
        INT 16H
        POP BX
        IRET
@funk_04: ;GET_KEY_ECHO
        ;on return:
        ;AH = keyboard scan code
        ;AL = ASCII character or zero if special function key
        MOV AH,GET_KEY
        INT 20H
        PUSH AX
        MOV AH,PRINT_CHAR
        INT 20H
        POP AX
        POP BX
        IRET
@funk_05: ;PRINT_CHAR
        ;AL = ASCII character to write
        ;
        ;returns nothing
        PUSH AX BX
        MOV AH,0EH     
        MOV BX,0007H
        INT 10H
        POP BX  AX
        POP BX
        IRET
@funk_06: ;GET_STRING
        ;ds:si -> space for asciiz string
        ;byte ptr ds:[si+0] = max length of string
        ;avbryter vid <RETUR> och specialtangenter
        STI
        PUSH AX CX SI di
        mov di,si
        MOV CL,[SI+0]
        OR CL,CL
        JZ @EXIT06
        MOV CH,0
        DEC CX
   @ONE_MORE_06:
        MOV AH,GET_KEY
        INT 20H
        MOV [SI],AL

        CMP AL,08H  ;BACKSPACE
        JNE @not_bs_06
        CMP SI,DI
        JE @ONE_MORE_06

        MOV AL,08H         ;M[STE BACKA I STR'NGEN
        MOV AH,PRINT_CHAR
        INT 20H
        MOV AL,20H
        MOV AH,PRINT_CHAR
        INT 20H
        MOV AL,08H
        MOV AH,PRINT_CHAR
        INT 20H
        dec si
        INC CX
        JMP @ONE_MORE_06

      @not_bs_06:       

        CMP AL,0dh         ;<retur> blir bara en nolla
        JNE @GOON06
        mov [byte ptr ds:0+si],0   
        JMP @EXIT06

      @GOON06:
        CMP AL,0           ;specialtecken
        JE @ONE_MORE_06

        MOV AL,[SI]
        MOV AH,PRINT_CHAR
        INT 20H

        INC SI
        LOOP @ONE_MORE_06
   @EXIT06:
        POP DI SI BX AX
        POP BX
        IRET
@funk_07: ;PRINT_STRING
        ;DS:SI -> ASCIIZ STRING TO PRINT
        ;
        ;returns nothing
        STI
        PUSH AX BX SI
   @one_more_07:
        LODSB
        OR       AL,AL
        JZ       @ret_07
        MOV      AH,0Eh
        MOV      BX,0007h
        INT      10h
        JMP @one_more_07
   @ret_07:
        POP SI BX AX
        POP BX
        IRET
@funk_08: ;CHECK_FOR_INPUT
        ;on return:
        ;ZF = 0 if a    key pressed (even Ctrl-Break)
        ;AX = 0 if no scan code is available
        ;AH = scan code
        ;AL = ASCII character or zero if special function key
        MOV AH,01H
        INT 16H
        POP BX
        IRET

cylinders       DD  0B40h
sec_per_track   dw  12h
heads           dw  2h
RetriesCounter  db  0
Currentsector   db  1h
CurrentHead     db  0
CurrentTrack    dw  0
f09_DriveNumber db  0
temp_bx         dw  0
temp_es         dw  0
disk_error DB 'Kunde ej lsa frn disk',0
disk_WRerror DB 'Kunde ej skriva till disk',0
logical_sector  dd  0

@funk_09: ;READSECTOR
        ;AL=ENHET
        ;ESI=LOGISK SEKTOR
        ;ES:BX=VART DEN SKA LSA
        MOV AL,0  ;FR SKERHETS SKULL
        POP BX
        push ds 
        mov [CS:temp_bx],bx
        mov bx,es
        mov [CS:temp_es],bx
        mov [cs:logical_sector],esi

        mov [cs:f09_DriveNumber],AL
        push cx
        PUSH BX DX ESI

    MOV EDX,ESI
    shr edx,16
    MOV EAX,ESI
    mov dx,0  ;0219

_ReadLBA:     ;IN: DXAX=Logisk sektor  ESBX=Buffer
    MOV     [cs:RetriesCounter],9
    push    dx
    push    ax
    DIV     [cs:sec_per_track]
    INC     DL
    MOV     [cs:Currentsector],DL
    XOR     DX,DX
    DIV     [cs:heads]
    MOV     [cs:CurrentHead],dl
    mov ax,[cs:sec_per_track]
    mul [cs:heads]
    mov si,ax
    pop ax
    pop dx
    div si
    mov [cs:CurrentTrack],ax

_NewTry:
    PUSH CS
    POP ES
    MOV BX,offset _disk_buffer
    MOV  AX,0201h
    MOV  CX,[cs:CurrentTrack]
    XCHG CH,CL
    SHL  CL,6
    OR   CL,[cs:CurrentSector]
    MOV  DH,[cs:CurrentHead]
    MOV  DL,[cs:f09_DriveNumber]
    INT  13h
    JNC  @KLAR_09
    ;nu ska vi skta om ett fel.
    MOV     AH,0
    INT     13h  ;resets disk
    DEC     [cs:RetriesCounter]
    JNZ     _NewTry
    JMP     @ERROR_09

     @ERROR_09:
        push ds
        mov si,OFFSET disk_error
        push cs
        pop ds
        mov ah,PRINT_STRING
        INT 20H
        pop ds
        MOV AX,-1
        jmp @slut_09

   @KLAR_09:
        PUSH CS
        POP DS
        MOV SI,offset _disk_buffer
        MOV DI,[CS:temp_es]
        MOV ES,DI
        MOV DI,[CS:temp_bx]
        MOV CX,128
        CLD
        REP MOVSD
	mov ax,0

   @slut_09:
        pop ESI dx bx
        mov BX,[CS:temp_es]
        mov es,bx
        mov BX,[CS:temp_bx]
pop cx
        pop ds
        IRET

@funk_0A: ;WRITESECTOR
        ;AL=ENHET
        ;ESI=LOGISK SEKTOR
        ;ES:BX=VARIFRN DEN SKA LSA
        MOV AL,0  ;FR SKERHETS SKULL
        POP BX
        push ds es esi di cx BX DX
        mov [cs:logical_sector],esi
        PUSH ES
        POP  DS
        MOV  SI,BX

        PUSH CS
        POP ES
        MOV DI, offset _disk_buffer
        MOV CX,128
        CLD
        REP MOVSD
;*******
        mov [cs:f09_DriveNumber],AL

    MOV EDX,[cs:logical_sector]
    shr edx,16
    MOV EAX,[cs:logical_sector]

_WRITELBA:     ;IN: DXAX=Logisk sektor  ESBX=Buffer
tecken 'b'
call print_decimal pascal,eax
tecken 'B'
tecken '.'
    MOV     [cs:RetriesCounter],9
    push    dx
    push    ax
    DIV     [cs:sec_per_track]
    INC     DL
    MOV     [cs:Currentsector],DL
    XOR     DX,DX
    DIV     [cs:heads]
    MOV     [cs:CurrentHead],dl
    mov ax,[cs:sec_per_track]
    mul [cs:heads]
    mov si,ax
    pop ax
    pop dx
    div si
    mov [cs:CurrentTrack],ax

_NewTry0A:
    PUSH CS
    POP ES
    MOV BX,offset _disk_buffer
    MOV  AX,0301h
    MOV  CX,[cs:CurrentTrack]
    XCHG CH,CL
    SHL  CL,6
    OR   CL,[cs:CurrentSector]
    MOV  DH,[cs:CurrentHead]
    MOV  DL,[cs:f09_DriveNumber]
    INT  13h
    JNC  @KLAR_0A
    ;nu ska vi skta om ett fel.
    MOV     AH,0
    INT     13h  ;resets disk
    DEC     [cs:RetriesCounter]
    JNZ     _NewTry0A
    JMP     @ERROR_0A

     @ERROR_0A:
        push ds
        mov si,OFFSET disk_WRerror
        push cs
        pop ds
        mov ah,PRINT_STRING
        INT 20H
        pop ds
        MOV AX,-1
        jmp @slut_0A

   @KLAR_0A:
        mov ax,0

   @slut_0A:

        POP DX BX CX DI ESI ES DS
        IRET
@funk_0B: ;CHECK_FAT_FOR_NEXT
        ;ESI INNEHLLER SEKTORN SOM MAN VILL KOLLA NSTA SEKTOR FR
        CALL fCHECK_FAT_FOR_NEXT PASCAL,ESI
        POP BX
        IRET
@funk_0C: ;CHECK_FAT_FOR_FREE
        ;LETAR EFTER EN FRI SEKTOR P[ DISKEN.
        ;RETURNERAR SEKTORN I AX
        ;OM AX=-1 FINNS DET INGET LEDIGT UTRYMME P[ DISKEN
        PUSH ESI ES CX ES
        MOV ESI,[CS:ALL_OFFS]
        MOV BX,[CS:ALL_LENGTH]
        MOVZX EBX,BX
        ADD EBX,ESI
        MOV [CS:LOAD_LIMIT],EBX
   @@LOAD_LOOPEN:
        MOV AL,0
        MOV AH,READSECTOR
        PUSH CS
        POP ES
        MOV BX, OFFSET _disk_buffer
        INT 20H

        MOV CX,256
   @@CHECKLOOPEN:
        MOV AX,[WORD PTR ES:BX]
        OR AX,AX
        JZ @@FOUND_ONE_FREE
        ADD BX,2
        CMP BX, OFFSET _disk_buffer+512
        JNE @@CHECKLOOPEN
        INC ESI
        CMP ESI,[CS:LOAD_LIMIT]
        JB @@LOAD_LOOPEN
        mov ax,-1
        JMP @@KLAR0C

   @@FOUND_ONE_FREE:
        SUB ESI,[CS:ALL_OFFS]
        MOV EAX,ESI
        SHL EAX,8  ;*256
        SUB BX,offset _disk_buffer
        SHR BX,1   ;2 BYTES PER WORD
        ADD AX,BX
   @@KLAR0C:
        POP ES CX ES ESI
        POP BX
        IRET
LOAD_LIMIT DD 0

@funk_0D: ;WRITE_FAT
        ;BX=GRUNDSEKTOR
        ;CX=VAD GRUNDSEKTORN SKA PEKA P
        POP BX
        PUSH ESI BX ES
        MOVZX ESI,BX
        ADD BX,BX
        PUSH BX
        MOVZX EBX,BX
        SHR EBX,8    ;DIV 256        (=fat_offset/512)
        CMP BX,[CS:ALL_LENGTH]
        JA @@ERROR0D
        ADD EBX,[CS:ALL_OFFS]
        MOV ESI,EBX
        PUSH CS
        POP ES
        MOV BX,OFFSET _disk_buffer
        MOV AL,0
        MOV AH,READSECTOR
        INT 20H
        POP BX
        push bx
        CMP AX,-1
        JE @@ERROR0D
        ADD BX,OFFSET _disk_buffer
        MOV [WORD PTR ES:BX],CX
        MOV BX,OFFSET _disk_buffer
        MOV AL,0
        MOV AH,WRITESECTOR
        INT 20H
        CMP AX,-1
        JE @@ERROR0D
        MOV AX,0
        JMP @@SLUT0D
    @@ERROR0D:
        mov ax,-1
    @@SLUT0D:
        pop bx
        POP ES BX ESI
        IRET

@funk_0E: ;CREATE_FILE
        ;BL=ATTRIBUT
        ;DS:SI=FILNAMNET
        ;RETURNERAR F;RSTA SEKTORNUMMRET I AX
        pop bx
        push es
        push bx
        PUSH SI
        MOV ESI,[CS:DIR_OFFSET]
        mov [cs:tempsect],esi
     @@SCAN_READ_LOOP:
        mov esi,[cs:tempsect]
        mov al,0
        MOV AH,READSECTOR
        push cs
        pop es
        mov bx, offset _disk_buffer
        int 20h


     @@SCANFORFREE:
        MOV BP,BX
        CMP [BYTE PTR ES:BX+DIRECTORY_ENTRY.FILENAME],0
        JE @@FOUND_FREE_SPACE
        CMP [BYTE PTR ES:BX+DIRECTORY_ENTRY.FILENAME],20H
        JE @@FOUND_FREE_SPACE
        ADD BX,20H
        CMP BX, OFFSET _disk_buffer + 512
        JGE @@NEXT_SECTOR
        JMP @@SCANFORFREE

    @@NEXT_SECTOR:
        mov esi,[cs:tempsect]
        call fCHECK_FAT_FOR_NEXT pascal,esi
        CMP AX, -1
        JE @@CREATE_NEW_DIR
        CMP AX, 0
        JE @@ERROR0E
        mov [word ptr cs:tempsect],ax
        mov [word ptr cs:tempsect+2],0
        JMP @@SCAN_READ_LOOP

     @@CREATE_NEW_DIR:
        PUSHA             ;0219
          MOV AH,CHECK_FAT_FOR_FREE
          INT 20H
          CMP AX,-1
          JNE @@OK123
          POPA
          JMP @@ERROR0E
        @@OK123:
         MOV BX,SI
         MOVZX ESI,CX
         MOV CX,AX
         MOV AH,WRITE_FAT
         INT 20H
         MOV BX,CX
         MOV CX,-1
         MOV AH,WRITE_FAT
         INT 20H
        POPA
        mov [cs:tempsect],esi
        MOV BP,OFFSET _disk_buffer

     @@FOUND_FREE_SPACE:
call print_hex pascal,ebx,4
        MOV esi,[CS:tempsect]
call print_hex pascal,esi,8
        MOV AH,CHECK_FAT_FOR_FREE
        INT 20H
        CMP AX,-1
        JE @@ERROR0E
        CMP AX,0
        JE @@ERROR0E
        MOVZX EAX,AX
        PUSH CS
        POP ES
        MOV BX,BP
call print_hex pascal,ebx,4
        PUSH EAX BX ESI
        mov bx,ax
        mov cx,-1
        mov ah, WRITE_FAT
        int 20H

        MOV esi,[CS:TEMPSECT]
        MOV AX,0900H
        MOV BX,OFFSET _disk_buffer
        INT 20H
        CMP AX,0
        JE @@OK2
        POP ESI BX EAX
        JMP @@ERROR0E
  @@OK2:
        POP ESI BX EAX


        MOV [ES:BX+DIRECTORY_ENTRY.FATOFFSET],EAX
        MOV DI,BX
        POP SI
        POP BX
        PUSH BX
        MOV [ES:DI+DIRECTORY_ENTRY.ATTRIB],BL
        push ax

        MOV CX,8
        CLD
        REP MOVSW
        SUB DI,16
        SUB SI,16
        push cs
        pop es

        MOV BX,OFFSET _disk_buffer
        MOV AH,WRITESECTOR
        MOV AL,0
        MOV ESI,[CS:TEMPSECT]
        INT 20H
TECKEN 'W'
        POP AX
        JMP @@KLAR0E

        @@NOT_FOUND:
        @@ERROR0E:
        POP SI
        mov ax,-1

        @@KLAR0E:
        POP BX
        POP ES
        IRET
TEMPSECT DD 0

@funk_0F: ;DELETE_FILE
        ;DS:SI = PEKARE TILL FILNAMN (16 BYTE LNGT)
tecken 'd'
        PUSH DS SI
        MOV AH,FIND
        INT 20H
        CMP AX,0
        JE @@ERROR0F
                    ;AX = FRSTA SEKTOR
   @@UNLINK_SECTORS:
   tecken 'u'
        MOVZX ESI,AX

        CALL fCHECK_FAT_FOR_NEXT PASCAL,ESI
        PUSH AX
        MOV BX,SI
        MOV CX,0
        MOV AH,WRITE_FAT
        INT 20H
        POP AX
        CMP AX,0ffffH
        JE @@DEL_DIR_ENTRY
        CMP AX,0
        JE @@DEL_DIR_ENTRY
        JMP @@UNLINK_SECTORS

    @@DEL_DIR_ENTRY:
        POP SI DS
        PUSH DS SI
        PUSH ESI
        MOV EAX,[CS:DIR_OFFSET]

     @@SCAN_READ_LOOP2:
        MOV ESI,EAX
call print_hex pascal,esi,8
        mov al,0
        MOV AH,READSECTOR
        push cs
        pop es
        mov bx, offset _disk_buffer
        int 20h
        pop Esi
        PUSH ESI


     @@SCANFORFILE2:
        CMP [BYTE PTR ES:BX+DIRECTORY_ENTRY.FILENAME],0
        JE @@NOT_FOUND2
        MOV CX,16
        MOV DI,BX
        PUSH SI
        CLD
        REPE CMPSB
        POP SI
        JE @@FOUNDFILE2
        ADD BX,20H
        CMP BX, OFFSET _disk_buffer + 512
        JAE @@NEXT_SECTOR2
        JMP @@SCANFORFILE2

    @@NEXT_SECTOR2:
        mov esi,[cs:logical_sector]
        call fCHECK_FAT_FOR_NEXT pascal,esi
        CMP AX, -1
        JE @@NOT_FOUND2
        CMP AX, 0
        JE @@NOT_FOUND2
        JMP @@SCAN_READ_LOOP2

     @@FOUNDFILE2:
tecken 'f'
        MOV [BYTE PTR ES:BX+DIRECTORY_ENTRY.FILENAME],20h  ;0219
        MOV AH,WRITESECTOR
        MOV AL,0
        MOV BX,OFFSET _disk_buffer
        MOV ESI,[CS:logical_sector]
        INT 20H
        MOV AX,0
        JMP @@KLAR2


     @@NOT_FOUND2:
tecken 'n'
     @@ERROR0F:
        mov ax,-1
     @@KLAR2:
        POP ESI
        POP SI DS
        POP BX
        IRET
@funk_10: ;  KAN ANV'NDAS I EN SENARE VERSION
@funk_11: ;
@funk_12: ;
@funk_13: ;
@funk_14: ;
@funk_15: ;
        mov ax,-1
        POP BX
        IRET
@funk_16: ;FIND
        ;DS:SI PEKAR P FILNAMNET TILL FILEN SOM SKA HITTAS
        ;__FILNAMNET_SKA_VARA_16_BYTE_LNGT.__
        ;RETURNERAR FILHANTAG I AX OCH ATTRIBUTEN I BL
        ;AX=0 OM DET _INTE_ FUNGERAR
        POP BX
        PUSH ES DI
        PUSH ESI
        MOV AL,0
        MOV ESI,0
        PUSH CS
        POP ES
        MOV BX,OFFSET _disk_buffer
        MOV AH,READSECTOR
        MOV AL,0
        INT 20H
                          ;NU FINNS BOOTBLOCKET I BUFFERTEN
        CMP AX,0
        JNE @@ERROR16
        MOV EAX,[ES:BX+BootBlkTable.ALLOCATOROFFSET]
        MOV [CS:ALL_OFFS],EAX
        MOV AX,[ES:BX+BootBlkTable.ALLOCATORLENGTH]
        MOV [CS:ALL_LENGTH],AX
        MOV EAX,[ES:BX+BootBlkTable.DIRECTORYOFFSET]
        MOV [CS:DIR_OFFSET],EAX

     @@SCAN_READ_LOOP:
        MOV ESI,EAX
        mov al,0
        MOV AH,READSECTOR
        push cs
        pop es
        mov bx, offset _disk_buffer
        int 20h
        pop Esi

     @@SCANFORFILE:
        CMP [BYTE PTR ES:BX+DIRECTORY_ENTRY.FILENAME],0
        JE @@NOT_FOUND
        MOV CX,16
        MOV DI,BX
        PUSH SI
        CLD
        REPE CMPSB
        POP SI
        JE @@FOUNDFILE
        ADD BX,20H
        CMP BX, OFFSET _disk_buffer + 512
        JGE @@NEXT_SECTOR
        JMP @@SCANFORFILE

    @@NEXT_SECTOR:
        mov esi,[cs:logical_sector]
        call fCHECK_FAT_FOR_NEXT pascal,esi
        CMP AX, -1
        JE @@NOT_FOUND
        CMP AX, 0
        JE @@NOT_FOUND
        JMP @@SCAN_READ_LOOP

     @@FOUNDFILE:
        MOV EAX, [ES:BX+DIRECTORY_ENTRY.FATOFFSET]
        MOV BL,[ES:BX+DIRECTORY_ENTRY.ATTRIB]
        JMP @@KLAR

        @@NOT_FOUND:
        @@ERROR16:
        mov ax,0

        @@KLAR:

        POP DI ES
        IRET
DIR_OFFSET DD 0
ALL_OFFS DD 0
ALL_LENGTH DW 0

PROC fCHECK_FAT_FOR_NEXT PASCAL NEAR
ARG @@SECTOR:DWORD
USES ESI, ES, BX
        ;returnerar i EAX (AX)  vilken sektor som som r den nsta 
        ;i filen. -1 betyder sista sektor.
        MOV ESI,[@@SECTOR]
        ADD SI,SI
        PUSH SI
        SHR SI,9
        MOVZX ESI,SI
        ADD ESI,[CS:ALL_OFFS]
        MOV AL,0
        MOV AH,READSECTOR
        PUSH CS
        POP ES
        MOV BX, OFFSET _disk_buffer
        INT 20H
        POP SI
        AND SI,511
        MOV SI,[ES:OFFSET _disk_buffer+SI]
        MOVZX EAX,SI
        RET
ENDP
;***********************************************************
;***********************************************************
;***********************************************************
;***********************************************************
PROC fEXEC PASCAL NEAR
ARG @@STARTSECTOR:WORD
        ;LETAR UPP OCH EXEKVERAR EN FIL.
        ;AX=0 OM DET GICK
        ;OBS! DIR_OFFS OCH ALL_OFFS MSTE VARA LADDADE!
        MOVZX ESI,[@@STARTSECTOR]        
        MOV AX,[CS:MINNE.USERBASE]
        MOV ES,AX

    @@LOADLOOP:
        MOV AL,0
        MOV AH,READSECTOR
        MOV BX,0
        INT 20H
        CMP AX,0
        JNE @@ERROR

        CALL fCHECK_FAT_FOR_NEXT PASCAL,ESI  ;KOLLA OM ESI F;RST;RDES
        CMP AX,-1
        JE @@KLARTLADDAT
        cmp ax,0
        JE @@KLARTLADDAT

        MOV ESI,EAX
        MOV AX,ES
        ADD AX,0020H
        MOV ES,AX
        JMP @@LOADLOOP

    @@KLARTLADDAT:
        push cs
        pop ds
        mov si,offset CommandString
        PUSH [CS:MINNE.USERBASE]
        PUSH 0000H
        DB 0CBH       ;RETF
                      ;RETURNERAR EGENTLIGEN ALLDRIG HIT.
     @@ERROR:
        MOV AX,-1
        RET
ENDP

PROC DIR PASCAL NEAR
USES EAX, ESI, ES, BX, CX, DI
        ;LETAR UPP ALLA FILER, SAMT VISAR DOM.

        MOV AL,0
        MOV ESI,0
        PUSH CS
        POP ES
        MOV BX,OFFSET _disk_buffer
        MOV AH,READSECTOR
        MOV AL,0
        INT 20H
                          ;NU FINNS BOOTBLOCKET I BUFFERTEN
        CMP AX,0
        JNE @@ERROR16
        MOV EAX,[ES:BX+BootBlkTable.ALLOCATOROFFSET]
        MOV [CS:ALL_OFFS],EAX
        MOV AX,[ES:BX+BootBlkTable.ALLOCATORLENGTH]
        MOV [CS:ALL_LENGTH],AX
        MOV EAX,[ES:BX+BootBlkTable.DIRECTORYOFFSET]
        MOV [CS:DIR_OFFSET],EAX

     @@SCAN_READ_LOOP:
        MOV ESI,EAX
        mov al,0
        MOV AH,READSECTOR
        push cs
        pop es
        mov bx, offset _disk_buffer
        int 20h

    @@SCANFORFILES:       ;0219
        CMP [BYTE PTR ES:BX+DIRECTORY_ENTRY.FILENAME],0
        JE @@NO_MORE_FILES
        CMP [BYTE PTR ES:BX+DIRECTORY_ENTRY.FILENAME],20h  ;borttagna filer
        JE @@hoppet36 
        MOV CX,16
        TECKEN [BYTE PTR ES:BX+DIRECTORY_ENTRY.ATTRIB]
        TECKEN ' '
        MOV DI,0
      @@PRINT_NAME:
        TECKEN [BYTE PTR ES:BX+DI+DIRECTORY_ENTRY.FILENAME]
        INC DI
        LOOP @@PRINT_NAME
        TECKEN 13
        TECKEN 10  ;NY RAD
        @@hoppet36:
        ADD BX,20H
        CMP BX, OFFSET _disk_buffer + 512
        JGE @@NEXT_SECTOR
        JMP @@SCANFORFILES

    @@NEXT_SECTOR:
        mov esi,[cs:logical_sector]
        call fCHECK_FAT_FOR_NEXT pascal,esi
        JMP @@SCAN_READ_LOOP

        @@NO_MORE_FILES:
        @@ERROR16:
        @@KLAR:

        RET
ENDP



prompt db 13,10,'>> ',0
CommandString db 80h dup (0)

c_mem db 'mem'
c_reg db 'reg'
c_dir db 'dir'
error_string db ' Felaktigt kommando eller filnamn',0

PROC PRINT_HEX PASCAL NEAR
ARG @@DWORD_TO_PRINT:DWORD, @@LENGTH:WORD
USES EAX, EDX, BX, CX
        ;SKRIVER UT ETT HEXADECIAMALT TAL P[ SK'RMEN

        MOV EAX,[@@DWORD_TO_PRINT]
        CMP [@@LENGTH],8
        JNA @@OK
        MOV [@@LENGTH],8
       @@OK:

        MOV CX,8
        SUB CX,[@@LENGTH]
        SHL CX,2             ;0-32
        SHL EAX,CL
        MOV CX,[@@LENGTH]

     @@PRINT_LOOP:
        CMP CX,0
        JE @@KLAR
        ROL EAX,4
        PUSH EAX
        MOV AH,PRINT_CHAR
        AND AL,0FH
        ADD AL,30H
        CMP AL,3AH
        JB @@OK2
        ADD AL, 41H-3AH
      @@OK2:
        INT 20H
        POP EAX
        LOOP @@PRINT_LOOP

   @@KLAR:
        RET

ENDP



PROC PRINT_DECIMAL PASCAL NEAR
ARG @@DWORD_TO_PRINT:DWORD
USES EAX, EDX, ESI, CX
        ;SKRIVER UT ETT DECIMALTAL P[ SK'RMEN
        MOV CX,0
        MOV EAX,[@@DWORD_TO_PRINT]
        CMP EAX,0
        JE @@NOLLA

   @@CALK_LOOPEN:
        CMP EAX,0
        JE @@PRINT_LOOPEN
      @@NOLLA:
        mov edx,0
        MOV ESI,10
        DIV ESI
        ADD DL,30H
        MOV DH,PRINT_CHAR
        PUSH DX
        INC CX
        JMP @@CALK_LOOPEN

   @@PRINT_LOOPEN:
        CMP CX,0
        JE @@KLAR
        POP AX
        INT 20H
        LOOP @@PRINT_LOOPEN

   @@KLAR:
        RET
ENDP


PROC PROCESS_COMMAND NEAR
        ;KOLLAR OM DET 'R ETT INTERNT KOMMANDO
        ;DS M[STE VARA = CS INNAN
        PUSH EAX CX DS ES SI DI
masm
        MOV CX,3
        PUSH CS CS
        POP DS ES
        MOV SI, OFFSET c_mem
        MOV DI, OFFSET CommandString
        CLD
        REPE CMPSB
        JNE @@C_REG
        CMP byte ptr [DI],0
        JE @@MEM
        CMP byte ptr [DI],20H
        JE @@MEM

   @@C_REG:
        MOV CX,3
        MOV SI, OFFSET c_reg
        MOV DI, OFFSET CommandString
        REPE CMPSB
        JNE @@C_DIR
        CMP byte ptr[DI],0
        JE @@REG
        CMP byte ptr[DI],20H
        JE @@REG

   @@C_DIR:
        MOV CX,3
        MOV SI, OFFSET c_dir
        MOV DI, OFFSET CommandString
        REPE CMPSB
        JNE @@C_3
        CMP byte ptr[DI],0
        JE @@DIR
        CMP byte ptr[DI],20H
        JE @@DIR

   @@C_3:
        CMP [0+CommandString],0
        JE @@EXIT

        JMP @@C_UNKNOWN


;@@MEMHEADER  DB 'DET FINNS ',0
;@@MEMHEADER2 DB ' BYTE LEDIGA.         USERBASE=',0
   @@MEM:

     ;   MOV AH,PRINT_STRING
     ;   MOV SI,OFFSET @@MEMHEADER
     ;   INT 20H
        STRING 'DET FINNS ',0

        MOV EAX,[CS: MINNE.TOTAL]
        MOV DX,[CS: MINNE.USERBASE]
        MOVZX EDX,DX
        SHL EDX,4
        SUB EAX,EDX

        CALL PRINT_DECIMAL pascal,EAX

       ; MOV AH,PRINT_STRING
       ; MOV SI,OFFSET @@MEMHEADER2
       ; INT 20H
       STRING ' BYTE LEDIGA.         USERBASE=',0

        MOV AX,[cs:MINNE.userbase]
        MOVZX EAX,AX
        CALL PRINT_HEX PASCAL,EAX,4

        JMP @@EXIT

   @@REG:
        TECKEN ' '
        TECKEN 'E'
        TECKEN 'A'
        TECKEN 'X'
        TECKEN ':'
        call PRINT_HEX pascal,EAX,8
        TECKEN ' '
        TECKEN 'E'
        TECKEN 'B'
        TECKEN 'X'
        TECKEN ':'
        call PRINT_HEX pascal,EBX,8
        TECKEN ' '
        TECKEN 'E'
        TECKEN 'C'
        TECKEN 'X'
        TECKEN ':'
        call PRINT_HEX pascal,ECX,8
        TECKEN ' '
        TECKEN 'E'
        TECKEN 'D'
        TECKEN 'X'
        TECKEN ':'
        call PRINT_HEX pascal,EDX,8
        TECKEN 13
        TECKEN 10
        TECKEN ' '
        TECKEN 'E'
        TECKEN 'S'
        TECKEN 'I'
        TECKEN ':'
        call PRINT_HEX pascal,ESI,8
        TECKEN ' '
        TECKEN 'E'
        TECKEN 'D'
        TECKEN 'I'
        TECKEN ':'
        call PRINT_HEX pascal,EDI,8
        TECKEN ' '
        TECKEN 'E'
        TECKEN 'S'
        TECKEN 'P'
        TECKEN ':'
        call PRINT_HEX pascal,ESP,8
        TECKEN ' '
        TECKEN 'E'
        TECKEN 'B'
        TECKEN 'P'
        TECKEN ':'
        call PRINT_HEX pascal,EBP,8
        TECKEN 13
        TECKEN 10
        TECKEN ' '
        TECKEN 'C'
        TECKEN 'S'
        TECKEN ':'
        PUSH 0
        PUSH CS
        push 4
        call PRINT_HEX pascal
        PUSH 0
        PUSH DS
        PUSH 4
        TECKEN ' '
        TECKEN 'D'
        TECKEN 'S'
        TECKEN ':'
        call PRINT_HEX pascal
        PUSH 0
        PUSH SS
        PUSH 4
        TECKEN ' '
        TECKEN 'S'
        TECKEN 'S'
        TECKEN ':'
        call PRINT_HEX pascal
        PUSH 0
        PUSH ES
        PUSH 4
        TECKEN ' '
        TECKEN 'E'
        TECKEN 'S'
        TECKEN ':'
        call PRINT_HEX pascal
        JMP @@EXIT

   @@DUMP:
        MOV AX,0B820H
        MOV ES,AX
        MOV BX,0
        MOV ESI,2Dh
        MOV AL,0
        MOV AH,READSECTOR
        INT 20H
        JMP @@EXIT

    @@DIR:
        CALL DIR pascal

        JMP @@EXIT

   @@TempFileName dB 10h dup (0)
   @@C_UNKNOWN:
        MOV SI,OFFSET CommandString
        CMP [BYTE PTR 0+SI],0
        JE @@EXIT

        MOV CX,10H
        MOV BX,OFFSET @@TempFileName

    @@GETFILENAMELOOP:
        MOV AL,[BYTE PTR SI]
        CMP AL,0
        JE @@FILLBLANKS
        CMP AL,20H
        JE @@FILLBLANKS
        MOV [BYTE PTR BX],AL
        INC SI
        INC BX
        LOOP @@GETFILENAMELOOP
        JMP @@DONE_PREPARING

      @@FILLBLANKS:
        MOV AL,20H
        MOV [BYTE PTR BX],AL
        INC BX
        LOOP @@FILLBLANKS
      @@DONE_PREPARING:

        PUSH CS
        POP DS
        MOV SI,OFFSET @@TempFileName
        MOV AH,FIND
        INT 20H
                        ;AX=FILHANTAG,     BL=ATTRIBUT
        CMP AX,0
        JE @@NOT_FILE
        CMP BL,ATTRIB_EXEC
        JE @@LOADIT
        STRING 'Filen r inte ett program'
        JMP @@EXIT

      @@LOADIT:
        CALL fEXEC PASCAL,AX
        JMP @@EXIT

      @@NOT_FILE:
        mov si,offset error_string
        mov ah,PRINT_STRING
        INT 20H
        JMP @@EXIT


   @@EXIT:
ideal
        POP DI SI ES DS CX EAX
        RET
ENDP

proc _start_commander near
        ;Denna procedur 'r sj'lva kommandohanteraren
        MOV BX,0
        MOV SS,BX
        MOV SP,700h+ReservedSize + (_end_resident - _start_resident)
        STI        
_start_of_commander:
        push cs
        pop ds

        mov si,offset prompt
        mov ah,PRINT_STRING
        int 20h                 ;visar prompten

        mov si,offset CommandString
        mov [BYTE PTR DS:0+si],80h
        mov ah, GET_STRING
        int 20h                 ;l'ser kommando

        TECKEN 13
        TECKEN 10               ;NY RAD


        MOV AH,PRINT_STRING     ;ekar kommando
        INT 20H
        TECKEN ':'
        TECKEN 13
        TECKEN 10

        CALL PROCESS_COMMAND

        jmp _start_of_commander
endp

;****************************************************************************
DriveNumber db	?

INT1ETABLE  db 14 dup (0)

align 16
_end_resident:
label _disk_buffer

;****************************************************************************
;****************************************************************************
Meddelande db 13,10
           db 'Startfilen is initializing system',13,10,0
ends
END
