{$G+}
PROGRAM RAWDISK;
USES CRT, DOS;

TYPE
  TBuffer = array[0..511] of Byte;
  PBuffer = ^TBuffer;
  TBiosRW=RECORD
     SectorsToRead:Byte; { 8-bit}
     Cylinder:Word;      {10-bit}
     Sector:Byte;        { 6-bit}
     Head:Byte;          { 4-bit}
     Drive:Byte;         { 8-bit}
     Buffer:PBuffer;     {32-bit}
  END;

  TBBLK = RECORD
    unimportant: array[0..10] of byte;
    BytesPerSector: word;
    Sectors: longint;
    SectorsPerTrack: word;
    Heads: word;
  END;
  TDiskInfo = RECORD
    Drive: Byte;             { 00h=A, 01h=B, 80h=C, 81h=D }
    Start: LongInt;          { Den frsta sektorn som ska anvndas }
    NumberOfRetries:Byte;
    BIOS: RECORD
      Cylinders: Word;
      SectorsPerTrack: Word;
      Heads: Word;
      DriveType: Byte;
      DBT: Pointer;
    END;
    BiosRW: TBiosRW;
    Buffer: PBuffer;
  END;

VAR
  INFO: TDiskInfo;           { Hr samlas all info om enheten }
  MyBuffer: TBuffer;

PROCEDURE ShowHelp;
BEGIN
  WriteLn('HJLP');
  WriteLn('Skriver och lser sektorer direkt frn disk.');
  WriteLn;
  WriteLn('RAWDISK [-R | -W] fil enhet sektor [antal]');
  WriteLn;
  WriteLn('  R      Lser sektorer frn disk till DOS-fil');
  WriteLn('  W      Lser frn DOS-fil till diskens sektorer');
  WriteLn('  fil    Namnet p DOS-filen som anvnds');
  WriteLn('  enhet  Disk som ska anvndas (00h=A, 01h=B, 80h=C, 81h=D)');
  WriteLn('  sektor Den frsta sektorn som pverkas av operationen');
  WriteLn('  antal  Det antal sektorer som ska lsas');
  WriteLn;
  WriteLn('RAWDISK -R dump.bin 0 0 10');
  WriteLn('    .. Lser de 10 frsta sektorerna p A-enheten till dump.bin');
  WriteLn;
  WriteLn('RAWDISK -W block.bin 80h 0');
  WriteLn('    .. Skriver filen block.bin till den frsta hrddisken, och');
  WriteLn('       skriver det antal sektorer som behvs fr att skriva hela filen');
  WriteLn;
END;

FUNCTION SelectDrive(SelDrive: Byte): Boolean;
VAR Regs: Registers;
BEGIN
  Info.Drive := SelDrive;
  WITH Regs, Info.BIOS DO BEGIN
    AH := 08;
    DL := SelDrive;
    Intr($13,Regs);
    Cylinders := CH + ((CL shr 6) shl 8) + 1;
    SectorsPerTrack := CL and $3F;
    Heads := DH + 1;
    DriveType := BL;
    DBT := ptr(ES, DI);
    SelectDrive := (DL = 0) or (Regs.Flags = 1); {Carry satt eller ingen enhet}
  END;
END;

{*******************************************************}

FUNCTION Hex(InByte: Byte): string;
CONST H: string = '0123456789ABCDEF';
BEGIN
  Hex := H[InByte shr 4 + 1] + H[InByte and $F + 1];
END;

FUNCTION StrToInt(Str: string): longint;
VAR I, Code: Integer;
BEGIN
  Val(Str, I, Code);
  IF Code <> 0 THEN StrToInt := -1
    ELSE StrToInt := I;
END;


FUNCTION FileExist(FileName: string): Boolean;
VAR f: file;
BEGIN
  {$I-}
  Assign(f, FileName);
  Reset(f);
  Close(f);
  {$I+}
  FileExist := (IOResult = 0) and (FileName <> '');
END;
{**********************************************************}
{**********************************************************}
FUNCTION ReadDiskSectors(Data: TBiosRW): Boolean; assembler;
VAR retries: byte;
ASM
        MOV   AL,[Info.NumberOfRetries]
        MOV   [retries],AL
@start:
        MOV   AH,02
        PUSH  DS
        LDS   BX, data
        MOV   AL,[TBiosRW(BX).SectorsToRead]
        MOV   CX,[TBiosRW(BX).Cylinder]
        XCHG  CH,CL
        SHL   CL,06
        OR    CL,[TBiosRW(BX).Sector]
        MOV   DH,[TBiosRW(BX).Head]
        MOV   DL,[TBiosRW(BX).Drive]
        LES   BX,TBiosRW(BX).Buffer[0]
        POP   DS
        INT   13h
        MOV   AL,0
        JNB   @NoError
        DEC   [retries]
        JNS   @start
        MOV   AL,1
 @NoError:
END;

FUNCTION WriteDiskSectors(data: TBiosRW): Boolean; assembler;
VAR retries: byte;
ASM
        MOV   AL,[Info.NumberOfRetries]
        MOV   [retries],AL
@start:
        MOV   AH,03
        PUSH  DS
        LDS   BX, data
        MOV   AL,[TBiosRW(BX).SectorsToRead]
        MOV   CX,[TBiosRW(BX).Cylinder]
        XCHG  CH,CL
        SHL   CL,06
        OR    CL,[TBiosRW(BX).Sector]
        MOV   DH,[TBiosRW(BX).Head]
        MOV   DL,[TBiosRW(BX).Drive]
        LES   BX,TBiosRW(BX).Buffer[0]
        POP   DS
        INT   13h
        MOV   AL,0
        JNB   @NoError
        DEC   [retries]
        JNS   @start
        MOV   AL,1
 @NoError:
END;

FUNCTION ReadLBA(VAR Buffer2: TBuffer; LBA: Longint): Boolean;
VAR temp: longint; bool: Boolean;
VAR biosread: TBiosRW;
BEGIN
  temp := (LBA div Info.BIOS.SectorsPerTrack);
  WITH BiosRead do BEGIN
      SectorsToRead := 1;
      Cylinder := temp div Info.BIOS.Heads;
      Head := temp mod Info.BIOS.Heads;
      Sector := (LBA mod Info.BIOS.SectorsPerTrack)+1;
      Drive := Info.Drive;
      Buffer := @Info.Buffer;
      bool := ReadDiskSectors(BiosRead); {true om ngot gick snett}
      ReadLBA := bool;
      IF bool = False THEN move(Info.Buffer,Buffer2,512);
  END;
END;

FUNCTION WriteLBA(VAR Buffer2: TBuffer; LBA: Longint): Boolean;
VAR temp: longint;
VAR biosread: TBiosRW;
BEGIN
  WITH BiosRead do BEGIN
      move(Buffer2, Info.Buffer, 512);
      temp := (LBA div Info.BIOS.SectorsPerTrack);
      SectorsToRead := 1;
      Cylinder := temp div Info.BIOS.Heads;
      Head := temp mod Info.BIOS.Heads;
      Sector := (LBA mod Info.BIOS.SectorsPerTrack)+1;
      Drive := Info.Drive;
      Buffer := @Info.Buffer;
      WriteLBA := WriteDiskSectors(BiosRead);{true om ngot gick snett}
  END;
END;
{***********************************************************}
{***********************************************************}


FUNCTION DoRead: Boolean;
LABEL Fel;
VAR filen: file of TBuffer;
VAR I, Antal: LongInt;
BEGIN
  DoRead := True;
  IF ParamCount <> 5 THEN BEGIN
    WriteLn('Fr f parametrar fr lsning!');
    Exit;
  END;
  IF FileExist(ParamStr(2)) THEN BEGIN
    Write('Filen "' + ParamStr(2) +
            '" existerar. Vill du skriva ver den? [J]a, [N]ej: ');
    WHILE Keypressed DO ReadKey;  { Tmmer tangentbufferten }
    Fel:
    Case ReadKey OF
      'J','j' : WriteLn('J');
      'N','n' : BEGIN WriteLn('N'); Halt(1); END;
      ELSE GOTO Fel;
    END;
  END;

  Assign(filen, ParamStr(2));
  Rewrite(filen);
  Antal := StrToInt(ParamStr(5));
  IF Antal = -1 THEN BEGIN
    WriteLn('Felaktigt antal "' + ParamStr(5) + '"');
    Exit;
  END;

  FOR I := 1 To Antal do
  BEGIN
    IF ReadLBA(MyBuffer, I-1+Info.Start) THEN BEGIN
      WriteLn('Misslyckad lsning');
      Halt(5);
    END;
    Write(filen, MyBuffer);
  END;
  Close(filen);
  WriteLn('Filen ',Paramstr(2),' har skapats, och ', Antal,' block har skrivits');
  halt(0);

  DoRead := False
END;

FUNCTION DoWrite: Boolean;
VAR filen: file;
VAR I: LongInt; result: word;
BEGIN
  DoWrite := True;
  IF ParamCount <> 4 THEN BEGIN
    WriteLn('Fr mnga parametrar fr skrivning!');
    Exit;
  END;
  IF NOT FileExist(ParamStr(2)) THEN BEGIN
    WriteLn('Filen "' + ParamStr(2) + '" existerar inte');
    Exit;
  END;
  Assign(filen, ParamStr(2));
  Reset(filen, 1);
  FOR I := 0+Info.Start TO Info.Start+((FileSize(filen)-1) div 512) DO
  BEGIN
    BlockRead(filen, MyBuffer, 512, result);
    IF (512-result) <> 0 THEN
    BEGIN
      WriteLn('rest: ',512-result,' skrivs nu');
      FOR Result := result TO 512 DO MyBuffer[result]:=0;
    END;
    IF WriteLBA(MyBuffer,I) THEN
    BEGIN
      WriteLn('Misslyckad Skrivning!');
      EXIT;
    END;
  END;
  WriteLn(1+((FileSize(filen)-1) div 512),' block har skrivits');
  Close(filen);
  DoWrite := False;
END;

PROCEDURE CheckBootBlock;
LABEL Fel, NyVal;
VAR Access: TBiosRW;
VAR pstr: ^string; pbblk: ^tbblk;
BEGIN
  WITH Access do BEGIN
    SectorsToRead := 1;
    Cylinder := 0;
    Sector := 1;
    Head := 0;
    Drive := Info.Drive;
    Buffer := @Info.Buffer^[0];
    IF ReadDiskSectors(Access) THEN BEGIN
      WriteLn('Gick inte att lsa bootblocket');
      Halt(3);
    END;
    Info.Buffer^[2] := 4;
    pstr := @Info.Buffer^[2];
    IF pstr^ <> 'ROSE' THEN Exit;   { Inte eget boot-block. Litar p BIOS }
    pbblk := @Info.Buffer^[0];
    IF (pbblk^.SectorsPerTrack = Info.BIOS.SectorsPerTrack) and
       (pbblk^.Heads = Info.BIOS.Heads) THEN Exit;   { BIOS och bblk stmmer }
  END;
  WriteLn('Informationen fr diskens geometri skiljer sig mellan');
  WriteLn('BIOS och bootblocket.');
  Nyval:
  Write('Vill du [A]vbryta, lita p [B]IOS, lita p B[o]otblock, se mer [I]nfo: ');
  While Keypressed do ReadKey;
  Fel:
  CASE ReadKey OF
    'B','b' : BEGIN WriteLn('B'); Exit; END;
    'A','a' : BEGIN WriteLn('a'); Halt(4); END;
    'O','o' : WITH Info.BIOS do BEGIN
                WriteLn('o');
                SectorsPerTrack := pbblk^.SectorsPerTrack;
                Heads := pbblk^.Heads;
              END;
    'I','i' : BEGIN
                WriteLn('***    Heads SectorsPerTrack');
                WITH Info.BIOS DO
                  WriteLn('BIOS     : ',Heads:3,'   ',SectorsPerTrack);
                WITH pbblk^ DO
                  writeln('Bootblock: ',Heads:3,'   ',SectorsPerTrack);
                GOTO Nyval;
              END;
    ELSE GOTO Fel;
  END;
END;

FUNCTION FollowParams:Boolean;
 { Kollar att programmet ftt giltiga parametrar }
VAR Temp: LongInt;
VAR TempStr: string;
BEGIN
  FollowParams := False;
  IF ParamCount < 4 THEN Exit;

  Temp := StrToInt(ParamStr(3));                   { enhet }
  IF (Temp = -1) or SelectDrive(Temp) THEN BEGIN
    WriteLn('Ogiltig enhet "' + ParamStr(3) + '"');
    Exit;
  END;

  Info.Start := StrToInt(ParamStr(4));              { startsektor }
  IF Info.Start = -1 THEN BEGIN
    WriteLn('Ogiltig Startsektor "' + ParamStr(4) + '"');
    Exit;
  END;

  CheckBootBlock;

  TempStr := ParamStr(1);
  IF Length(TempStr) > 2 THEN Exit;
  IF (TempStr[1] = '-') or (TempStr[1] = '/') THEN TempStr[1] := TempStr[2];

  CASE TempStr[1] OF
    'R', 'r' : IF DoRead THEN EXIT;
    'W', 'w' : IF DoWrite THEN EXIT;
    ELSE Exit;
  END;
  FollowParams := True;
END;

FUNCTION AdjustPointer(Inpointer: pointer): pointer; ASSEMBLER;
ASM
        MOV   AX,word ptr[InPointer]
        MOV   DX,word ptr[InPointer+2]
        MOV   BX,AX
        AND   BX,0FFF0h
        SUB   AX,BX
        SHR   BX,4
        ADD   DX,BX
END;
                      {TRUE om den pasar i en "sida"}
FUNCTION IsSinglePage(InPointer: pointer; Size: Word): Boolean; ASSEMBLER;
ASM
        PUSH  word ptr[InPointer+2]
        PUSH  word ptr[InPointer]
        CALL  AdjustPointer
        MOV   BX,DX
        SHR   BX,12
        ADD   AX,[Size]
        JC    @NotAChance
        PUSH  BX
        PUSH  DX
        PUSH  AX
        CALL  AdjustPointer
        SHR   DX,12
        POP   AX
        SUB   AX,DX
        JNE   @NotAChance
        MOV   AX,1
        JMP   @slut
@NotAChance:
        MOV   AX,0
@slut:
END;

{****************************************************************}
{****************************************************************}

PROCEDURE SetUpBuffer;
{ Ser till att vi inte fr ngra konstiga DMA-fel }
BEGIN
  REPEAT
    New(Info.Buffer);
    IF Info.Buffer = nil THEN BEGIN
      WriteLn('Minnsefel');
      Halt(2);
    END;
  UNTIL IsSinglePage(@Info.Buffer^[0], 512);
END;

BEGIN
  SetUpBuffer;
  Info.NumberOfRetries := 5;
  IF NOT FollowParams THEN
  BEGIN
    ShowHelp;
    Halt(1);
  END;

END.