model tiny
P286
ideal

;;**** DATA-STRUKTURER ******************************************************
struc DiskBaseTable
    btModeByte1       db ?    ;Disk Controller mode byte 1
    btModeByte2       db ?    ;Disk Controller mode byte 2
    btMotorOffDelay   db ?    ;clock ticks until motor off
    btSectorSize      db ?    ;FM or MFM Mode: Log2(Bytes per sector/128)
    btSectorsPerTrack db ?    ;Last sector on track
    btGapLength       db ?    ;gap length in bytes
    btSectorSize2     db ?    ;disk data length (80h for 128 bytes/sector. FFh otherwise);
    btFormatGapLength db ?    ;gap length when formatting
    btFormatPattern   db ?    ;data pattern used during formatting
    btHeadBounceDelay db ?    ;floppy head bounce delay (in milliseconds)
    btMotorStartDelay db ?    ;floppy motor start delay (in 0.125 second intervals)
ends

struc BootBlkTable
    OEMNameVersion     db 8 dup (?)   ;8bytes  Namn och version and version
    BytesPerSector     dw ?           ;word    Bytes per sektor
    NumberOfSectors    dd ?           ;dword   Totala antalet sektors
    SectorsPerTrack    dw ?           ;word    Sektorer per track
    NumberOfHeads      dw ?           ;word    Antal heads
    DirectoryOffset    dd ?           ;dword   Sektor som "innehller" rooten
    StartFileOffset    dd ?           ;dword   Sektor dr startfilen brjar
    StartFileLength    dw ?           ;word    Startfilens lngd i sektorer
    AllocatorOffset    dd ?           ;dword   Sektor fr disk-systemet
    AllocatorLength    dw ?           ;word    Lngd p ditto
    Reserved           db 10 dup (?)  ;10bytes Bra att ha i framtiden
ends

;****************************************************************************

segment NextCodeSeg at 1400h     ;Hit kommer startfilen att laddas
ends

segment code
     assume cs:code, ds:code
     org 0h

    JMP     _start
org 03h
BootBlk BootBlkTable  <      \
      'ROSE 0.1',200h,0B40h, \OEMNameVersion, BytesPerSector, NumberOfSectors
       12h,02h,2Dh,          \SectorsPerTrack, NumberOfHeads, DirectoryOffset
       0001h,0020h,          \StartFileOffset, StartFileLength,
       0021h,000Ch>          ;AllocatorOffset, AllocatorLength


DBT DiskBaseTable <00,00,00,00,12h,0,0,0,0,0Fh,00h>
    DriveNumber    db ?
    RetriesCounter db ?
    CurrentTrack   dw ?
    CurrentSector  db ?
    CurrentHead    db ?
label OldInt1E dword
_start:
    CLI
    db 0EAh    ;=FAR JMP _init
    dw offset _init,07C0h
_init:
    MOV     [DriveNumber],DL  ;sparar undan vilken enhet som anvnds.
    XOR     AX,AX
    MOV     SS,AX 
    MOV     SP,7C00h   ;stter upp stacken
    PUSH    CS
    POP     ES         ;07C0h -> ES
    MOV     BX,0078h
    LDS     SI,[SS:BX]    ;laddar pekare till INT 1E (Disk base table)

    mov     [word ptr OldInt1E],SI
    mov     [word ptr OldInt1E+2],DS
;    PUSH    DS
;    PUSH    SI         ;DS:SI pekar p [INT 1E]
;    PUSH    SS         ;0000h
;    PUSH    BX         ;0078h
    MOV     DI, offset DBT
    MOV     CX, 000Bh  ;storlek p DBT
    CLD

_DBTReplaceLoop:                  ;Ger biosen vrden fr hur den ska
    LODSB                         ;anvnda enheten.
    CMP     [BYTE PTR ES:DI],00
    JE      _ChangeThisByte
    MOV     AL,[ES:DI]
_ChangeThisByte:
    STOSB
    MOV     AL,AH
    LOOP    _DBTReplaceLoop

_InitializeDiskSystem:
    PUSH    SS
    POP     DS                 ;0000h -> DS
    MOV     [WORD PTR DS:BX+02], 7C0h        ;detta segment
    MOV     [WORD PTR DS:BX],offset DBT  ;
    STI
    MOV     AH,0
    INT     13h                ;Resets disk system
    JB      _BootError   ;If error...

    PUSH CS
    POP  DS
;*****************************************************************
;==================SLUT P INITIERINGEN
_LoadStartFile:
    mov si,offset messStart
    call _WriteString
    mov  ax,NextCodeSeg
    mov  es,ax
    xor  bx,bx
  _ReadingLoop:
      call _progress
      mov  dx,[(WORD PTR bootblk.StartFileOffset)+2]
      mov  ax,[WORD PTR bootblk.StartFileOffset]
      DEC  [bootblk.StartFileLength]
      jz   _LeaveControl
      call _ReadLBA
      add  [WORD PTR bootblk.StartFileOffset],1
      adc  [(WORD PTR bootblk.StartFileOffset)+2],0
      add  bx,200h
      call _AdjustESBX
    JMP  _ReadingLoop


_BootError:
    MOV     SI,offset ErrDISKIO
    CALL    _WriteString
    XOR     AH,AH
    INT     16h            ;vntar p tangenttryckning

    mov  bx, [word ptr cs:OldInt1E]
    mov  cx, [word ptr cs:OldInt1E+2]
    xor  ax, ax
    mov  ds, ax
    mov  [0078h],bx
    mov  [007Ah],cx

;    POP     SI
;   POP     DS
;    POP     [SI]
;    POP     [SI+02]        ;Stdar upp ndringar i Disk base table
    INT     19h            ;Bootar om


_LeaveControl:
    mov  si,offset messLaddad
    call _WriteString
    MOV  DL,[DriveNumber]
    db 0EAh                    ;JMP "Startfilen"
    dw 0000h,NextCodeSeg       ;Lmnar ver till startfilen


_WriteString:              ;Skriver ut en strng som avslutas med 00h
    LODSB
    OR      AL,AL
    JZ      _Ret
    MOV     AH,0Eh
    MOV     BX,0007h
    INT     10h
    JMP     _WriteString

_progress:
    pusha
    mov si, offset messProgress
    call _WriteString
    popa
_Ret:
    RET

_ReadLBA:     ;IN: DXAX=Logisk sektor  ESBX=Buffer
    MOV     [RetriesCounter],9
    push    dx
    push    ax
    DIV     [bootblk.SectorsPerTrack]
    INC     DL
    MOV     [Currentsector],DL
    XOR     DX,DX
    DIV     [Bootblk.NumberOfHeads]
    MOV [CurrentHead],dl
    mov ax,[Bootblk.SectorsPerTrack]
    mul [Bootblk.NumberOfHeads]
    mov si,ax
    pop ax
    pop dx
    div si
    mov [CurrentTrack],ax

_NewTry:
    MOV  AX,0201h
    MOV  CX,[CurrentTrack]
    XCHG CH,CL
    SHL  CL,6
    OR   CL,[CurrentSector]
    MOV  DH,[CurrentHead]
    MOV  DL,[DriveNumber]
    INT  13h
    JNC _Ret
    ;nu ska vi skta om ett fel.
    MOV     AH,0
    INT     13h  ;resets disk
    DEC     [RetriesCounter]
    JNZ     _NewTry
    JMP     _BootError
    RET

;;***********************************

_AdjustESBX:              ;bevarar alla register utom ES:BX (och flaggorna)
    PUSH    AX CX
    MOV     AX,BX
    AND     AX,0FFF0h
    SUB     BX,AX      ;and bx,000fh
    SHR     AX,4
    MOV     CX,ES
    ADD     CX,AX
    MOV     ES,CX
    POP     CX AX
RET

ErrDISKIO      db 13,10
               db 'Disk I/O error',13,10
               db 'Gick ej att ladda startfil',13,10,0
messStart      db 13,10,'Laddar startfilen',13,10,0
messLaddad     db 13,10,'Lmnar kontrollen till startfilen',13,10,0
messProgress   db '.',0

org 1FEh
BootSignature  dw 0AA55h

ends
end
