//Copyright (C) 2000 Simon Gustafsson.

/** Metoder för 3-dimmensionell vektoralgebra.
  * Vektorerna kan också ses som koordinater
  * @author Simon Gustafsson (www.simong.se) */
public class VA3D {


  /** Adderar två vektorer 
    *@param r1 första vektorn
    *@param r2 andra vektorn
    *@return summan av de två vektorerna */
  public static Point3D add(Point3D r1, Point3D r2){
    return new Point3D(r1.koord[0]+r2.koord[0],
                       r1.koord[1]+r2.koord[1],
                       r1.koord[2]+r2.koord[2]);
  }


  /** Subtraherar två vektorer.
   *@return r1-r2*/
  public static Point3D sub(Point3D r1, Point3D r2){
    return new Point3D(r1.koord[0]-r2.koord[0],
                       r1.koord[1]-r2.koord[1],
                       r1.koord[2]-r2.koord[2]);
  }


  /** Multiplicerar en vektor med en skalär.
   *@return r1*scalar */
  public static Point3D mul(Point3D r1, int scalar){
    return new Point3D(scalar*r1.koord[0],
                       scalar*r1.koord[1],
                       scalar*r1.koord[2]);
  }

  
  /** Multiplicerar en vektor med en skalär.
   *@return r1*scalar */
  public static Point3D mul(Point3D r1, double scalar){
    return new Point3D((int)(scalar*r1.koord[0]),
                       (int)(scalar*r1.koord[1]),
                       (int)(scalar*r1.koord[2]));
  }


  /** Punktprodukt
   *@return r1 (punkt) r2 */
  public static int punktProdukt(Point3D r1, Point3D r2){
    return (r1.koord[0]*r2.koord[0]+
            r1.koord[1]*r2.koord[1]+
            r1.koord[2]*r2.koord[2]);
  }


  /** Vektorprodukt
    *@return r1 (kryss) r2 */
  public static Point3D vektorProdukt(Point3D r1, Point3D r2){
    return new Point3D(r1.koord[1]*r2.koord[2] - r1.koord[2]*r2.koord[1],
                       r1.koord[2]*r2.koord[0] - r1.koord[0]*r2.koord[2],
                       r1.koord[0]*r2.koord[1] - r1.koord[1]*r2.koord[0]);
  }


  /** Ger avståndet i kvadrat mellan två punkter.
    *@return avståndet mellan  r1 och r2 i kvadrat. */
  public static int avstandKvadrat(Point3D r1, Point3D r2){
    return ((r1.koord[0]-r2.koord[0])*(r1.koord[0]-r2.koord[0])+
            (r1.koord[1]-r2.koord[1])*(r1.koord[1]-r2.koord[1])+
            (r1.koord[2]-r2.koord[2])*(r1.koord[2]-r2.koord[2]));
  }


  /** Ger avståndet mellan två punkter.
    *@return avståndet mellan  r1 och r2. */
  public static int avstand(Point3D r1, Point3D r2){
    return (int) Math.sqrt((r1.koord[0]-r2.koord[0])*(r1.koord[0]-r2.koord[0])+
                     (r1.koord[1]-r2.koord[1])*(r1.koord[1]-r2.koord[1])+
                     (r1.koord[2]-r2.koord[2])*(r1.koord[2]-r2.koord[2]));
  }


  /** Normaliserar en vektor.
    @param r vektor att normalisera.
    @return en normaliserad vektor. */
  public static Point3D normalisera(Point3D r){
    int length = avstand(r, Point3D.nollvektor);
    return(new Point3D(r.koord[0]/length, r.koord[1]/length, r.koord[2]/length));
  }

} // class VA3D
