//Copyright (C) 2000 Simon Gustafsson

import java.awt.*;

/** Klass som lagrar tredimmensionella trianglar.
  * @author Simon Gustafsson (www.simong.se) */
public class Triangle extends My3DThing{

  Point3D[] points;
  private Color color;

  static final int normal = 3;
  static final int mitt = 4;


  /** Skapar och initierar en triangel med alla koordinater (0,0,0) */
  public Triangle(){
    points = new Point3D[5];
    for(int i=0; i<5; i++) points[i] = new Point3D(0,0,0);
    color = new Color(128,128,128);
  }


  /** Skapar och kopierar en annan triangels alla egenskaper.
    *@param old den triangel som ska kopieras */
  public Triangle(Triangle old){
    points = new Point3D[5];

    for(int i=0; i<5; i++)
      points[i] = new Point3D(old.points[i]);

    color = old.color;
  }


  public Object clone(){
    return new Triangle(this);
  }


  /** Anger färgen på triangeln */
  public void setColor(Color c){
    if(c==null) return;
    color = c;
  }


  /** returnerar färgen på triangeln */
  public Color getColor(){
    return color;
  }


  public void scale(double x, double y, double z) {
    for(int k=0; k<5; k++){
      points[k].koord[0] = (int) (points[k].koord[0] * x);
      points[k].koord[1] = (int) (points[k].koord[1] * y);
      points[k].koord[2] = (int) (points[k].koord[2] * z);
    }
  }


  public void translate( int dx, int dy, int dz) {
    for(int k=0; k<5; k++){
      points[k].koord[0] += dx;
      points[k].koord[1] += dy;
      points[k].koord[2] += dz;}
  }


  public void rotate(double x, double y, double z) {
    rotateX(x);
    rotateY(y);
    rotateZ(z);
  }


  public void rotateX(double radians) {
    for(int k=0; k<5; k++) points[k].rotateX(radians);
  }


  public void rotateY(double radians) {
    for(int k=0; k<5; k++) points[k].rotateY(radians);
  }


  public void rotateZ(double radians) {
    for(int k=0; k<5; k++) points[k].rotateZ(radians);
  }


  public int getNumObjects(){
    if((points != null)&&(points[0]!=null)&&(points[1]!=null)&&
           (points[2]!=null)) return 1;
    else return 0;
  }


  /** Skapar och initierar en triangel från MyParser-objektet x 
    *@exception Exception kastas om något inte gick*/
  public Triangle(MyParser x) throws Exception {
    points = new Point3D[5];
    if(!parse(x)) throw new Exception ("Inte en triangel");
  }


  /** Bestämmer triangelns normal. (längden på normalen är c:a 1000)
    *@return normalen.*/
  private Point3D getNormal() {
    Point3D n = VA3D.vektorProdukt(
                  VA3D.sub(points[0],points[1]),
                  VA3D.sub(points[2],points[1]));
    return (VA3D.mul(n, 1000.0/VA3D.avstand(n,Point3D.nollvektor) ) );
  }


  /** Används för att skriva ut triangels som en sträng. OBS!
    * Skriver i denna version inte ut triangelns färg.
    *@return sträng som representerar triangeln. t.ex 
    *<code>Triangle { < 0, 0, 0 >, < 5, 5, 5 >, < -10, 0, 10 > }</code>*/
  public String toString(){
    String temp = "Triangle { ";
    for(int i=0; i<2; i++)
      temp = temp + points[i]+", ";
    return temp + points[2]+" }";
  }


  /** Läser den triangel som står först i MyParser-objektet.
    *@param x MyParser-objekt som skall parsas.
    *@return false om första saken i x inte är en triangel.
    *returnerar true om det var en riktig triangel, och den gick att läsa.
    *@exception Exception kastas om det inte står en korrekt triangel
    *först i MyParser-objektet. */
  public boolean parse(MyParser x) throws Exception {
    Triangle t = new Triangle();
    My3DColor c3d = new My3DColor();
    try{
      if(!x.skip("Triangle")) return false;
      
      if(!x.skip('{'))
	  throw new Exception("{ saknas för Triangle.");
      
      if(c3d.parse(x)) color = c3d.color;
      else color = new Color(128,128,128);
      
      for(int i=0; i<2; i++) {
        if(!t.points[i].parse(x)) throw new Exception("Punkt saknas i Triangle");
        if(!x.skip(',')) throw new Exception(", saknas i Triangle");
      }

      t.points[2].parse(x);
      
      if(!x.skip('}')) throw new Exception("} saknas för Triangle.");
    } catch (Exception e) {throw new Exception(e+ " Ogiltig triangel");}
    points = t.points;
    correctPoints();
    return true;
  }


  public void draw(Grafik3D g3D){
    g3D.drawTriangle(this);
  }


  private Point3D getMidPoint(){
    return (VA3D.mul(VA3D.add(VA3D.add(points[0],points[1]),points[2]),
      1.0/3));
  }
  
  private void correctPoints() {
    points[normal] = getNormal();
    points[mitt] = getMidPoint();
  }



  public int getZ(){
    return points[mitt].getZ();
  }


//******************************************************************
public static void main(String[] arg){
  System.out.println("Test av Triangle.class");
  String x;

do {
  System.out.println("\nSkriv sträng att parsa, tom sträng avbryter:");
  x=Mio.GetLine();
try {
  Triangle tmp = new Triangle(new MyParser(x));
  System.out.println("Så här tolkade datorn det:\n"+tmp);
} catch (Exception e) {System.out.println("Det där var ingen triangel :" +e);}

} while(!x.equals("") );

}
} 
