//Copyright (C) 2000 Simon Gustafsson.

import java.applet.*;
import java.awt.*;

/** Klass som används för perspektiv-transformation (3D till 2D) 
  * @author Simon Gustafsson (www.simong.se) */
public class Transformation{


  // 512 för att ev senare kunna optimera med shiftningar
  private int viewingDistance = 512;
  private int dx = 0;
  private int dy = 0;


  private int closestPoint = 1;  // Klipper bort närmare punkter


  /** Bestämmer vilka skärmkoordinater som skall motsvara origo, dvs vart
    * vektorn (0,0,0) skall transformeras.
    *@param x xkoordinat på skärmen för origo.
    *@param y ykoordinat på skärmen för origo. */
  public void setScreenOrigo(int x, int y){
    dx=x; dy=y;
  }


  /** Bestämmer från vilket avstånd man ser på skärmen. 
    *@param dist avstånd */
  public void setViewingDistance(int dist){
    viewingDistance = dist;
  }


  /** Metod som transformerar en Point3D till en tvådimensionell Point
    *@param r tredimensionell punkt
    *@return tvådimensionell punkt, som är perspektivtransformerad.*/
  public Point T(Point3D r){
    if( (viewingDistance-r.koord[2]) < closestPoint )
      return new Point(0,0); 
      // borde kanske slänga ett undantag, eller returnera
      // en punkt som inte syns på skärmen.
    else
      return new Point(
        (viewingDistance*r.koord[0])/(viewingDistance-r.koord[2])+dx,
        (viewingDistance*r.koord[1])/(viewingDistance-r.koord[2])+dy);
  }

}
