// Copyright (c) 2000 Simon Gustafsson

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/** Detta är en j-uppgift i ämnet 2D1343 Datalogi för elektro.
 * Skriven av Simon Gustafsson e99_sgu
 * <p>
 * Redovisad 30 maj 2000.
 * <p>
 * <p>
 * I originaldistrubutionen finns det en katalog doc, som innehåller
 * javadoc-dokumentation för de flesta klasser.
 * <p>
 * Det finns också med några filer, med ändelsen ".data". dessa filer
 * kan öppnas med knappen Öppna om programmet körs via Appletviewer.
 * <p>
 * De ".BAT"- filer som följer med, användes för att via en Toolbar
 * kunna öppna alla filerna i NotePad, kompilera dem, skapa 
 * dokumentation, samt visa appletten
 * <p>
 * OBS! Säkerhetsinställningarna i Web-browsers gör oftast att man inte
 * kan köra appleten i en browser, utan man får använda appletviewer
 *
 * @author Simon Gustafsson (www.simong.se)
 */

public class Test extends Applet implements ActionListener, ItemListener{

  public static boolean debug = false;

  public static Object3D meshes = new Object3D();
  private Edit Edit1;   // Edit-rutan
  private Figur Figur1; // Canvas
  private Button doItButton, loadButton; //Verkställ och Öppna-knappar
  private Checkbox rotateCheckBox, shadeCheckBox; //
  

  private void createThings() {
    Edit1 = new Edit(20,5);
    Figur1 = new Figur(size().width,size().height/2);
    doItButton = new Button("Uppdatera");
    loadButton = new Button("Öppna");
    rotateCheckBox = new Checkbox("Rotera");
    shadeCheckBox = new Checkbox("Skuggning");
  }

  private void doTheLayout() {
    setLayout(new BorderLayout());
    add(Figur1,"North");
    add(Edit1,"Center");
    Panel Panel1 = new Panel();
    Panel1.add(rotateCheckBox);
    Panel1.add(shadeCheckBox);
    Panel1.add(loadButton);
    Panel1.add(doItButton);
    add(Panel1,"South");
  }

  public void init(){
    //Skapa alla småsaker
    createThings();
    
    //Fixa hyfsad layout
    doTheLayout();

    doItButton.addActionListener(this);
    rotateCheckBox.addItemListener(this);
    shadeCheckBox.addItemListener(this);
    loadButton.addActionListener(this);


    // Läs in objektet från Edit1
    try{
      showStatus("Starting parser...");
      meshes = new Object3D(new MyParser(Edit1.getText()));
      showStatus("Parser done");
      if((meshes!=null)&&(debug)) Edit1.setText(meshes.toString());
      if(meshes != null) Figur1.setObject3D(meshes);
    } catch (Exception ex) {showStatus("Error in text!");
      if(debug)System.out.println("Error: "+ex);}
  }


  public void start(){
/* Ej testat ännu. Borde fungera hyfsat från HD, och ladda in ett objekt
   med filnamnet angiven som <param name="SOURCE" value="myfil.data">
    String source = getParameter("SOURCE");
     if(source != null){
       loadSource(source);
    }
*/
  }


  public void stop(){
    // Borde kanske stanna tråden som ritar och roterar
    // grafiken, men struntar i det.
  }


  public void itemStateChanged(ItemEvent e){
    if(e.getSource() == rotateCheckBox){
      Figur1.setRotationState(
        rotateCheckBox.getState(),
        0.09,0.04,0.08
      );
    }

    if(e.getSource() == shadeCheckBox){
      Figur1.setShadingState(
        shadeCheckBox.getState(),
        new Point3D(0,0,100)
      );
    }

  }

  public void actionPerformed(ActionEvent e){

    if (e.getSource()==doItButton){
      try {
  
        showStatus("Starting parser...");
        meshes = new Object3D(new MyParser(Edit1.getText()));
        showStatus("Parser done");
        if((meshes!=null)&&(debug)) Edit1.setText(meshes.toString());
        if(meshes != null) Figur1.setObject3D(meshes);
      } catch (Exception ex) {showStatus("Error in text!");
          if(debug)System.out.println("Error: "+ex);}
    }


    if (e.getSource()==loadButton){
      Frame f = new Frame();
      f.show();
      FileDialog d = new FileDialog(f,"Öppna",FileDialog.LOAD);
      d.show();
      String filename;
      if((filename=d.getFile()) != null){
	showStatus(filename);
        loadSource(filename);
      }//if((filename...
    }//loadButton
  }//ActionPerformed


  private void loadSource(String filename){
    FileReader theFile;
    BufferedReader fileIn = null;
    String oneLine;
    try{
      theFile = new FileReader(filename);
      fileIn = new BufferedReader(theFile);
      Edit1.setText("");
      while((oneLine = fileIn.readLine()) != null){
        if(debug)System.out.println(oneLine);
        Edit1.append(oneLine+"\n");
      }
    }catch(Exception ex){System.out.println("Error reading file:"+ex);
    try{
      if(fileIn != null) fileIn.close();
      } catch(Exception exx){};
  }


} //class Test



class Edit extends TextArea {
  public Edit(int x, int y){
    setText(//"Object3D { Triangle { <0,0,0>,<50,0,0>,<0,50,0> } }"
"// Lite komplex kub\r\n" +
"Object3D {\r\n" +
"Triangle { color=<255,255,255>; <-50,-50,50>,<-50,50,50>,<50,-50,50>}\r\n" +
"Triangle { color=<255,200,100>; <-50,50,50>,<50,-50,50>,<50,50,50>}\r\n" +
"Triangle { color=<255,200,100>; <50,-50,50>,<50,50,50>,<50,50,-50>}\r\n" +
"Triangle { color=<255,255,255>; <50,-50,50>,<50,50,-50>,<50,-50,-50>}\r\n" +
"Triangle { color=<255,255,255>; <50,50,-50>,<50,-50,-50>,<-50,-50,-50>}\r\n" +
"Triangle{ color=<255,255,0>; <-50,-50,-50>,<50,50,-50>,<-50,50,-50>}\r\n" +
"Triangle{ color=<255,255,0>; <-50,-50,-50>,<-50,50,50>,<-50,50,-50>}\r\n" +
"Triangle{ color=<255,255,255>;<-50,-50,-50>,<-50,50,50>,<-50,-50,50>}\r\n" +
"\r\n" +
"Triangle{ color=<0,128,255>;<-50,-50,-50>,<-50,-50,50>,<50,-50,-50>}\r\n" +
"Triangle{ color=<128,255,255>;<-50,-50,50>,<50,-50,-50>,<50,-50,50>}\r\n" +
"\r\n" +
"Triangle{ color=<0,128,255>;<-50,50,-50>,<-50,50,50>,<50,50,-50>}\r\n" +
"Triangle{ color=<128,255,255>;<-50,50,50>,<50,50,-50>,<50,50,50>}\r\n" +
"}\r\n"	
    );
    resize(x,y);
    setEditable(true);
    selectAll();
  } // Edit
}



class Figur extends Canvas implements Runnable{

  Thread thread;
  Transformation trans;
  Grafik3D G3D;
  private My3DThing thing = null;
  private My3DThing rotatingThing;
  private boolean rotate = false;
  private double x, y, z, dx, dy, dz;
  private Image bufferImage;
  private Graphics buff;


  public Figur(int x, int y){
    resize(x,y);
    G3D = new Grafik3D();
    trans = new Transformation();
    trans.setScreenOrigo(x/2,y/2);
    G3D.setTransformation(trans);
    G3D.setShading(false, new Point3D(00,00,100));
    thread = new Thread(this);
    thread.start();
  }


  public void run(){
    while(thread != null){
      repaint();
      try { Thread.sleep(150); }
      catch (InterruptedException ie) {}
    } // while
  } // run


  public void setObject3D(Object3D object){
    thing = (My3DThing) (object.clone());
    rotatingThing = (My3DThing) thing.clone();
  }


  public void setRotationState(boolean sx,double ddx, double ddy, double ddz){
    if(sx) { dx = ddx;  dy = ddy;  dz = ddz; }
    rotate = sx;
  }


  public void setShadingState(boolean sx, Point3D light) {
    G3D.setShading(sx, light);
  }


  public void update(Graphics rita){
    if(bufferImage == null)
       bufferImage = createImage(size().width,size().height);
    paint(rita);
    rita.drawImage(bufferImage,0,0,null); 
  } 


  public void paint(Graphics rita){
    if(thing==null || bufferImage == null)return;
    buff = bufferImage.getGraphics();
    buff.setColor(new Color(30,30,255));
    buff.fillRect(0,0,size().width,size().height);
    G3D.setGraphics(buff);
    if (thing != null){
      if(rotate) {
        x += dx; y+=dy; z+=dz;
	rotatingThing = (My3DThing) thing.clone();
	rotatingThing.rotate(x,y,z);
	rotatingThing.draw(G3D);
      }
      else { rotatingThing.draw(G3D); }
    }//if
  } //paint
}

}//Figur









