//Copyright (C) 2000 Simon Gustafsson

import java.awt.Color;


/** Klass som lagrar tredimensionella punkter 
  * @author Simon Gustafsson (www.simong.se) */
public class Point3D extends My3DThing {

  int[] koord;

  private static final boolean debug = false;

  static final Point3D e_x = new Point3D(1,0,0);
  static final Point3D e_y = new Point3D(0,1,0);
  static final Point3D e_z = new Point3D(0,0,1);
  static final Point3D nollvektor = new Point3D(0,0,0);


  /** Skapar och initierar punkten med x, y, och z -värden från en integervektor
    *@param koordinater koordinaterna*/
  public Point3D(int[] koordinater){
    if(koordinater == null){
      this.koord = new int[3];
      for(int i=0; i<3;i++) this.koord[i] = 0;
    }
    else{
      this.koord = new int[3];
      for(int i=0; i<3;i++) this.koord[i] = koordinater[i];
    }
  }


  public int getNumObjects(){
    return 1;
  }


  /** Skapar och initierar punkten med koordinaterna (x,y,z) = (0,0,0)*/
  public Point3D(){
    this(0,0,0);
  }


  /** Skapar och initierar punkten med koordinaterna (x,y,z).
    *@param x x-koordinat
    *@param y y-koordinat
    *@param z z-koordinat */
  public Point3D(int x, int y, int z){
    this.koord = new int[3];
    this.koord[0] = x;
    this.koord[1] = y;
    this.koord[2] = z;
  }
  

  public Point3D(Point3D p){
    koord = new int[3];
    koord[0] = p.koord[0];
    koord[1] = p.koord[1];
    koord[2] = p.koord[2];
  }


  public Object clone(){
    return new Point3D(this);
  }


  public void scale(double x, double y, double z) {
    koord[0] = (int) (koord[0]*x);
    koord[1] = (int) (koord[1]*y);
    koord[2] = (int) (koord[2]*z);
  }


  public void translate( int dx, int dy, int dz) {
    koord[0] += dx;
    koord[1] += dy;
    koord[2] += dz;
  }

 
  public void rotate(double x, double y, double z) {
    rotateX(x);
    rotateY(y);
    rotateZ(z);
  }


  public void rotateX(double radians) {
    double sin = Math.sin(radians);
    double cos = Math.cos(radians);

    int temp0 = (int) (cos*koord[1] - sin*koord[2]);
    koord[2] = (int) (sin*koord[1] + cos*koord[2]);
    koord[1] = temp0;
  }


  public void rotateY(double radians) {
    double sin = Math.sin(radians);
    double cos = Math.cos(radians);
 
    int temp0 = (int) (cos*koord[0] + sin*koord[2]);
    koord[2] = (int) (-sin*koord[0] + cos*koord[2]);
    koord[0] = temp0;
  }


  public void rotateZ(double radians) {
    double sin = Math.sin(radians);
    double cos = Math.cos(radians);
                                 
    int temp0 = (int) (cos*koord[0] - sin*koord[1]);
    koord[1] = (int) (sin*koord[0] + cos*koord[1]);
    koord[0] = temp0;
  }


  public int getZ(){
    return koord[2];
  }



  /** Skapar och initierar punkten som står först i x 
    *@exception Exception kastas om det inte gick */
  public Point3D(MyParser x) throws Exception{
    koord = new int[3];
    if(!parse(x)) throw new Exception("");
  }
 

  /** Används för att skriva ut punkten som en sträng. 
    *@return sträng som representerar punktens koordinater t.ex <code><1,-5,20></code>*/
  public String toString(){
    return "< "+koord[0]+", "+koord[1]+", "+koord[2]+" >";
  }


  /** Läser den punkt som står först i MyParser-objektet.
    *@param x MyParser-objekt som skall parsas.
    *@return false om första saken i x inte är en punkt.
    *Returnerar true om det var en punkt, och den gick att läsa.
    *@exception Exception kastas om det är en defekt punkt först i x.*/
  public boolean parse(MyParser x) throws Exception {
    Point3D p = new Point3D(0,0,0);

    if (debug) System.out.println("parsePoint3D("+x+")");
    if(!x.skip("<")) return false;
    if (debug) System.out.println(x);
 
    for(int i=0; i<2; i++) try {
      p.koord[i] = x.popInt();
      x.skip(',');
    } catch (Exception e) {throw new Exception(e + 
      "\n-->gick ej att läsa Point3D");}

    p.koord[2] = x.popInt();
    if( x.skip(">") ) {
      koord = p.koord; return true;
    }
    else throw new Exception("Ogiltig Point3D");
  }


  public void draw(Grafik3D g3D){
    g3D.drawLine(this,this);
  }


//*****************************************************************
public static void main(String[] arg){
  System.out.println("Test av Point3D.class");
  String x;
  Point3D tmp=null;
do {
System.out.println("\nSkriv sträng att parsa, tom sträng avbryter:");
 x = Mio.GetLine();
try {
  if ((tmp = new Point3D()).parse(new MyParser(x)))
  System.out.println("Så här tolkade datorn det:\n"+tmp);
  else System.out.println("Det där var ingen punkt. En punkt skrivs som <0,0,0>");
} catch (Exception e) {System.out.println( x + " är inte en giltig punkt");}


} while(!x.equals("") );

}
} // class Point3D
