//Copyright (C) 2000 Simon Gustafsson.

import java.awt.Color;


/** Klass som kan innehålla valfria objekt av typen My3DThing 
  * @author Simon Gustafsson (www.simong.se) */
public class Object3D extends My3DThing{

  private static final boolean debug = false;

  /** Här lagras samtliga objekt */
  public My3DThing[] objects;


  public Object3D(Object3D old){
    objects = new My3DThing[old.objects.length];
    for(int i=0; i<objects.length; i++)
      objects[i] = (My3DThing) old.objects[i].clone();
  }


  public Object clone(){
    return new Object3D(this);
  }


  public Object3D(My3DThing thing){
    if(debug) System.out.println("konstruktor Object3D("+thing+") anropad.");
    objects = new My3DThing[1];
    objects[0] = (My3DThing) thing.clone();
    if(debug) System.out.println("konstruktor Object3D("+objects+") KLAR.");
  }


  public Object3D(){
  }


  /** Skapar och initierar en Object3D från MyParser-objektet x 
    *@exception Exception kastas om något inte gick. */
  public Object3D(MyParser x) throws Exception{
    if(!parse(x)) throw new Exception ("Inte ett Object3D");
  }


  public void scale( double x, double y, double z ){
    for(int i=0; i<objects.length; i++) objects[i].scale(x,y,z);
  }


  public void translate( int dx, int dy, int dz){
    for(int i=0; i<objects.length; i++) objects[i].translate(dx,dy,dz);
  }


  public void rotateX(double radians){
    for(int i=0; i<objects.length; i++) objects[i].rotateX(radians);
  }


  public void rotateY(double radians){
    for(int i=0; i<objects.length; i++) objects[i].rotateY(radians);
  }


  public void rotateZ(double radians){
    for(int i=0; i<objects.length; i++) objects[i].rotateZ(radians);
  }


  public void rotate(double x, double y, double z){
    rotateX(x);
    rotateY(y);
    rotateZ(z);
  }


  public int getNumObjects(){
    int temp=0;
    if(objects == null) return 0;
    for(int i=0; i<objects.length; i++)
      temp += objects[i].getNumObjects();
    return temp;
  }


  /** Lägger till ett annat objekt till detta objekt.
    *@param objekt det som skall läggas till.*/
  public void add(My3DThing objekt){
    if(debug)System.out.println("add("+objekt+" + "+this.toString()+")");
    if(objekt.getNumObjects()==0) return;

    if(this.getNumObjects() == 0) {
      objects=new My3DThing[1];
      if(debug)System.out.println("add() instance-check");

      if(objekt instanceof Object3D){ //Funkar, eftersom (this) är tom.
        if(debug)System.out.println("add() instance Object3D");
        objects = ((Object3D) objekt.clone()).objects; return;
      }

      if(objekt instanceof Point3D){
        if(debug)System.out.println("add() instance Point3D");
        objects[0] = ((Point3D) objekt.clone()); return;
      }

      if(objekt instanceof Triangle){
        if(debug)System.out.println("add() instance Triangle");
        objects[0] = ((Triangle) objekt.clone()); return;
      }

      System.out.println("Okänd grej, vi ignorerar den.");
      return;
    }

    int newLength = objects.length + 1;
    if(debug)System.out.println("add längd "+newLength);
    My3DThing[] temp = new My3DThing[newLength];

    if(debug)System.out.println("add() flera smågrejor.");
    for(int i=0; i<objects.length; i ++){ //0219
      if(debug)System.out.println("Object3D.union: lägger till ett objekt");
      temp[i] = (My3DThing) objects[i].clone();
    }

    temp[newLength-1]= (My3DThing) objekt.clone();
    objects = temp;  
  }// add


  public String toString(){ 
    if(objects == null) return "null";
    String tmp = "Object3D {\n";

    for(int i=0; i<objects.length; i++)
      tmp = tmp + objects[i] +"\n";

    tmp = tmp + "}";
    return tmp;
  }


  public boolean parse(MyParser x)throws Exception{ //0219
    Object3D o = new Object3D();
    Triangle t = new Triangle();
    Point3D p = new Point3D();
    Object3D temp = new Object3D();
  try {
    if(!x.skip("Object3D")) return false;

    if(!x.skip('{')) throw new Exception("{ saknas för Object3D.");
    boolean modified = false;
    do{
      modified = false;
      if(t.parse(x)){
        if(debug)System.out.println("läste in en triangel");
        temp.add(new Triangle(t));
        modified = true;
      }
      if(p.parse(x)){
        if(debug)System.out.println("läste in en punkt");
        temp.add(new Point3D(p));
        modified = true;
      }
      if(o.parse(x)){
        if(debug)System.out.println("läste in en Object3D");
        temp.add(new Object3D(o));
        modified = true;
      }
    } while( !x.skip('}') && (modified));

  } catch (Exception e) {
    if(debug)System.out.println("Error in Object3D.parse() :"+e);
    throw new Exception(e+" --> ingen riktig Object3D.");
  }

    x.skip();

    if(!x.getString().equals("")) throw new Exception("Texten borde ha tagit slut innan :"+x);
    if(debug)System.out.println("Detta kom fram i parsningen:"+temp);
    objects = temp.objects;
    return true;
  }


  private Object3D itemize(){
    Object3D temp= new Object3D();
    for(int i=0; i<objects.length; i++){
      if(objects[i] instanceof Object3D) temp.add(((Object3D)(objects[i])).itemize());
      else {temp.add(objects[i]);}
    }
    return temp;
  }


  /** Ej implementerad än. Behövs inte heller för att Test.java ska
    * rita ut objekten rätt.
    *@return Integer.MAX_VALUE*/
  public int getZ(){
    return Integer.MAX_VALUE; // Lägg längst bak, för utritningens skull.
  }


  public My3DThing[] getZsorted(){
    My3DThing [] temp = itemize().objects;
    Heap h = new Heap();

    for(int i=0; i<temp.length; i++) {
      h.insert(temp[i], temp[i].getZ()); }

    for(int i=0; i<temp.length; i++) {
      temp[i] = (My3DThing) (h.get()); }

    return temp;
  }


  public void draw(Grafik3D g3D){
    // Denna variant ritar ut objekten längst bak först...
    My3DThing[] zSorted = getZsorted();

    for(int i=0; i<zSorted.length; i++) {
      zSorted[i].draw(g3D); }
  }


//*******************************************************************
public static void main(String[] arg){
  System.out.println("Test av Object3D.class");
  String x;
do {
  System.out.println("\nSkriv sträng att parsa, tom sträng avbryter:");
  x=Mio.GetLine();
try {
  Object3D tmp = new Object3D(new MyParser(x));
  System.out.println("Så här tolkade datorn det:\n"+tmp);
} catch (Exception e) {System.out.println(e + " -->Det där var inget Object3D.");}

} while(!x.equals("") );

}

} // class Object3D
