//Copyright (c) 2000 Simon Gustafsson

/** Klass som underlättar tolkning av strängar. 
  * @author Simon Gustafsson (www.simong.se) */
public class MyParser {

  private int toSkip = garbage;
  private String string = "";


  /** Konstant som skickas med metoden setToSkip för att skippa kommentarer*/
  public static final int comments = 1;


  /** Konstant som skickas med metoden setToSkip för att alla mellanrum och
    * kontrolltecken ska hoppas över.*/
  public static final int whitespace = 2;


  /** Konstant som skickas med metoden setToSkip för att kombinera effekten av
    * comments och whitespace.*/
  public static final int garbage = comments + whitespace;



  public MyParser(){
  }


  /** Tar objektets sträng-representation och sparar den 
    * internt i objektet MyParser. När man sedan använder metoderna
    * skip och popInt plockas dessa ut från strängen.
    *@param object ett objekt som ger den sträng som skall parsas. */
  public MyParser(Object object){
    if(object==null) return;
    string = object.toString();
  }


  /** Anger vilka sorts tecken som skall hoppas över i fortsättningen.
    * Garbage är förvalt värde.
    *@param toSkip ett värde, se comments, whitespace respektive garbage.
    */
  public void setToSkip(int toSkip){
    this.toSkip = toSkip;
  }


  /** Returnerar den del av strängen som inte har parsats än.
    *@return den sträng som ligger kvar i MyParser */
  public String getString(){
    return string;
  }


  /** Skriver in en ny sträng till det aktuella MyParser-objektet.
    * @param s den sträng som skall läggas in i MyParser */
  public void setString(String s){
    string = s;
  }


  /** Returnerar den del av strängen som inte har parsats än.
    *@return den sträng som ligger kvar i MyParser */
  public String toString(){
    return string;
  }

  
  /**Parsar en siffra, dvs läser in det nummer som skall stå först i
    *den del av strängen som fortfarande inte har parsats.
    *<p>
    *En siffra som föregås av ett minustecken, utan några mellanrum
    *räknas som en negativ siffra.
    *@exception kastas om det inte finns ett nummer först i strängen
    *@return första siffran i strängen */
  public int popInt() throws Exception{ 
    int index = 0;
    skip();
    if((string.length() > 0) && (string.charAt(0)=='-')) index++;
    while( (index < string.length()) && ('0' <= string.charAt(index)) && 
           (string.charAt(index) <= '9') 
         ) { index++; }

    if(index==0) throw new Exception(
      "MyParser.popInt(); det finns ingen siffra först i strängen\n" +
      ":"+string);

    String str = string.substring(0,index);
    string = string.substring(index);
    return Integer.parseInt(str);
  }



  /** Hoppar över allt ointressant i början av strängen s.
    * se <code>whitespace</code> och <code>comments</code> */
  public void skip(){
    boolean whitespace = (toSkip & MyParser.whitespace) == 
                          MyParser.whitespace;
    boolean comments = (toSkip & MyParser.comments) == 
                        MyParser.comments;
    boolean modified;

    do {
      modified = false;

      //Tar bort eventuella whitespace's
      if(whitespace && (string.length() >= 1) && 
         (string.charAt(0) <= 0x0020)) 
      {
        int index = 0;
        while( (index < string.length()) && 
               (string.charAt(index)<=0x20) 
             ){ index++; }
        string = string.substring(index);
        modified = true;
      }

      //Tar bort eventuella kommentarer
      if(comments && string.length() >= 2) 
        if(string.substring(0,2).equals("//"))
      {
        for(int index=0; index < string.length(); index++)
        {
          if((string.charAt(index) == '\n') ||
             (index+1 == string.length())) 
          {
            if(index+1 == string.length()) index--;
            string = string.substring(index+1);
            break;
          }
        }
        modified = true;
      }
 
    } while( modified );
  }


  /** Hoppar över allt ointressant i början av strängen,
    * samt teckent character.
    * @param character speciellt tecken som också skall hoppas över
    * @return true om tecknet <code>character</code> har hoppats över.
    * annars false */
  public boolean skip(char character){
    skip();
    if( string.length() == 0) return false;
    if( string.charAt(0) == character ) 
    {
      string = string.substring(1);
      skip();
      return true;
    }
    return false;
  }


  /** Hoppar över allt ointressant, samt en specifierad sträng.
    * @param s den sträng som också skall hoppas över
    * @return true om strängen <code>s</code> har hoppats över.
    * annars false */
  public boolean skip(String s){
    skip();

    if( string.startsWith(s) ) 
    {
      string = string.substring(s.length());
      skip();
      return true;
    }

    return false;
  }


} // class MyParser
