//Copyright (c) 2000 Simon Gustafsson

/** För att kunna behandla alla 3D-objekt på samma sätt 
  * @author Simon Gustafsson (www.simong.se) */
public abstract class My3DThing implements Cloneable
{

  /** Ritar ut saken på skärmen med hjälp av ett Grafik3D-objekt. */
  abstract public void draw(Grafik3D g3D);


  /** Läser in objektet från en fil.
    *@param x sträng som beskriver ett objekt
    *@return false om första saken i "strängen" x inte är rätt sorts objekt.
    *returnerar true om det var ett riktigt objekt, och det gick att läsa.
    *@exception Exception kastas om det var rätt sorts objekt, men det inte
    *gick att läsa. */
  abstract public boolean parse(MyParser x) throws Exception;


  /** Returnerar antalet objekt som bygger upp denna sak */
  abstract public int getNumObjects();


  /** Skalar om objektet med skalfaktorerna x, y, och z */
  abstract public void scale(double x, double y, double z);


  /** Flyttar objektet dx steg i x-led, dy steg i y-led och dz steg i z-led */
  abstract public void translate( int dx, int dy, int dz);


  /** Roterar objektet i x, y och z-led. */
  abstract public void rotate(double x, double y, double z);


  /** Roterar objektet i X-led */
  abstract public void rotateX(double radians);


  /** Roterar objektet i Y-led */
  abstract public void rotateY(double radians);


  /** Roterar objektet i Z-led */
  abstract public void rotateZ(double radians);


  /** Hämtar z-koordinat för en punkt inne i objektet (t ex tyngdpunkt)*/
  abstract public int getZ();


  abstract public Object clone();

}//My3DThing
