// Copyright (c) 2000 Simon Gustafsson

import java.awt.Color;

/** En klass som används enbart för att parsa in färger. 
  * <p>
  * För att läsa in en färg gör man på följande sätt:
  * <blockquote><pre>
  * My3DColor c = new My3DColor();
  * if(!c.parse(x)) System.out.println("Var inte en färg");
  * Color theColor = c.color;
  * </pre></blockquote>
  * <p>
  * En färg anges i strängform som <CODE>color = <10,0,20>;</CODE>.
  * De tre talen representerar RGB-representationen av färgen, dvs
  * hur mycket rött, grönt respektive blått som ingår i färgen.
  * Vardera talet måste ligga inom intervallet 0 till 255.
  *
  * @author Simon Gustafsson (www.simong.se) */
public class My3DColor{

  /** innehåller efter parsning en färg. */
  Color color;


  /** Läser in en färg från ett MyParser-objekt.
    *@param x MyParser-objekt som kan beskriva färgen
    *@return false om första saken i "strängen" x inte är en färg.
    *returnerar true om det var en färg, och gick att läsa in.
    *@exception Exception kastas om det är ett färgobjekt, men det inte
    *gick att läsa. */
  public boolean parse(MyParser x) throws Exception {
    Point3D p;
    try{
      if(!x.skip("color")) return false;
	    
      if(!x.skip("=")) 
        throw new Exception("= förväntas efter color");    
    
      p = new Point3D(x);

      //Nu är färgens komponenter inlästa i p. Måste kolla värdena.
      for(int i=0; i<3; i++) {
        if(p.koord[i]<0) throw new Exception("färg < 0 !");
        if(p.koord[i]>255) throw new Exception("färg > 255 !");
      }

      if(!x.skip(';')) throw new Exception("; saknas efter color!");
    } catch (Exception e) { throw new Exception(" Ogiltig färg"); }

    color = new Color(p.koord[0],p.koord[1],p.koord[2]);

    return true;
  }

}
