import java.io.*                                                            ;
/** Enkel in- och utmatning, Henrik Eriksson, 1997-02-03                    */
public class Mio                                                            {

  /** Läs en rad från tangenterna, glufsa radbytet, returnera raden         */
  public static String GetLine()                                            {
    return GetLine(keyboard)                                                ;}

  /** Läs ett ord avgränsat av blanka från tangenterna och returnera det    */
  public static String GetWord()                                            {
    return GetWord(keyboard)                                                ;}

  /** Läs ett heltal avgränsat av blanka från tangenterna och returnera det */
  public static int GetInt()                                                {
    return GetInt(keyboard)                                                 ;}

  /** Läs decimaltal avgränsat av blanka från tangenterna och returnera det */
  public static double GetReal()                                            {
    return GetReal(keyboard)                                                ;}
               
  /** Läs ett tecken från tangenterna och returnera det                     */
  public static char GetChar()                                              {
    return GetChar(keyboard)                                                ;}

  /** Tjuvtitta på nästa tecken från tangenterna och returnera det          */
  public static char NextChar()                                             {
    return NextChar(keyboard)                                               ;}

  /** Glufsa eventuella blanka på tur att läsas från tangenterna            */
  public static void SkipBlanks()                                           {
    SkipBlanks(keyboard)                                                    ;}

  /** Returnera true om retur står i tur från tangenterna                   */
  public static boolean Eoln()                                              {
    return Eoln(keyboard)                                                   ;}

  /** Returnera true om ctrl-D står i tur från tangenterna                  */
  public static boolean EOF()                                               {
    return EOF(keyboard)                                                    ;}

  static BufferedInputStream keyboard = (BufferedInputStream)System.in      ;
 
  /** Öppna filen för skrivning                                             */
  public static PrintWriter OpenWrite(String s)                             {
    try                                                                     {
        return new PrintWriter(new FileOutputStream(new File(s)))           ;}
    catch (IOException e)                                                   {
        System.err.println("Fel i OpenWrite")                               ;}
    return null                                                             ;}

  /** Öppna filen för läsning                                               */
  public static BufferedInputStream OpenRead(String s)                      {
    try                                                                     {
        return new BufferedInputStream(new FileInputStream(new File(s)))    ;}
    catch (IOException e)                                                   {
        System.err.println("Kan inte öppna "+s)                             ;}
    return null                                                             ;}

  /** Läs en rad från filen, glufsa radbytet, returnera raden               */
  public static String GetLine(BufferedInputStream in)                      {
    StringBuffer word = new StringBuffer()                                  ;
    char tkn                                                                ;
    if (EOF(in)) return ""                                                  ;
    while((tkn=GetChar(in))!='\n') if(tkn!='\015') word.append(tkn)         ; 
    return word.toString()                                                  ;}

  /** Läs ett ord avgränsat av blanka från filen och returnera det          */
  public static String GetWord(BufferedInputStream in)                      {
    StringBuffer word = new StringBuffer()                                  ;
    SkipBlanks(in)                                                          ;
    if (EOF(in)) return ""                                                  ;
    while(!Character.isWhitespace(NextChar(in))) word.append(GetChar(in))   ; 
    return word.toString()                                                  ;}

  /** Läs ett heltal avgränsat av blanka från filen och returnera det       */
  public static int GetInt(BufferedInputStream in)                          {
    String word=GetWord(in)                                                 ;
    try                                                                     {
      return Integer.parseInt(word)                                         ;}
    catch(NumberFormatException e)                                          {
      System.err.println("Not an integer:"+word)                            ;}
    return 0                                                                ;}

  /** Läs ett doubletal avgränsat av blanka från filen och returnera det    */
  public static double GetReal(BufferedInputStream in)                      {
    String word=GetWord(in)                                                 ;
    try                                                                     {
      Double d = Double.valueOf(word)                                       ;
      return d.doubleValue()                                                ;}
    catch(NumberFormatException e)                                          {
      System.err.println("Not a number:"+word)                              ;}
    return 0                                                                ;}

  /** Läs ett tecken från filen och returnera det                           */
  public static char GetChar(BufferedInputStream in)                        {
    char tkn='\000'                                                         ;
    try                                                                     {
      tkn=(char)in.read()                                                   ;}
    catch(IOException e)                                                    {
      System.err.println("Fel i GetChar")                                   ;}
    return tkn                                                              ;}

  /** Tjuvtitta på nästa tecken i filen och returnera det                   */
  public static char NextChar(BufferedInputStream in)                       {
    char tkn='\000'                                                         ;
    in.mark(1)                                                              ;
    try                                                                     { 
      tkn=(char)in.read()                                                   ;
      in.reset()                                                            ;}
    catch (IOException e)                                                   {
      System.err.println("Fel i NextChar\n")                                ;}
    if (tkn=='\015')                                                        {
      GetChar(in)                                                           ;
      return NextChar(in)                                                   ;} 
    return tkn                                                              ;}

  /** Glufsa eventuella blanka på tur att läsas i filen                     */
  public static void SkipBlanks(BufferedInputStream in)                     {
    while(Character.isWhitespace(NextChar(in))) GetChar(in)                 ;}

  /** Returnera true om retur står i tur att läsas i filen                  */
  public static boolean Eoln(BufferedInputStream in)                        {
    return (Mio.NextChar(in)=='\n')                                         ;}

  /** Returnera true om filen är slutläst                                   */
  public static boolean EOF(BufferedInputStream in)                         {
    int n=0                                                                 ;
    in.mark(1)                                                              ;
    try                                                                     {
      n=in.read()                                                           ;
      in.reset()                                                            ;}
    catch (IOException e)                                                   {
      System.err.println("Fel i EOF\n")                                     ;}
    return (n==-1)                                                          ;}}









