// Copyright (C) 2000 Simon Gustafsson.

class Node{
  Object sak;
  int priority;
  Node left, right, upp;

  public Node(Object x, int p){
    sak=x; priority = p;
  }
}


/** Heap, eller trappa. Används för att sortera saker efter prioritet 
  * @author Simon Gustafsson (www.simong.se) */
public class Heap{

  private int first = 1;
  private int last = 0;
  private int max = 200;
  private Node [] table = new Node[200]; //negativaste först


  /** Sätter in ett objekt, med viss prioritet i trappan.
    *@param x objektet
    *@param pri prioritet. negativare tal har högre prioritet */
  public void insert(Object x, int pri){

    //Behöver kanske mer minne?
    if(last >= max-1) {
      Node[] temp = new Node[max+max];
      for(int i=0; i<max; i++) temp[i] = table[i];

      table = temp;
    }

    if(last == 0) table[++last] = new Node(x,pri);
    else{
      table[++last] = new Node(x,pri);
      int i=last;
      while(((i/2)>=first) && (table[i].priority<table[i/2].priority))
      {
        swap(i, i/2);
        i = i/2;
      }
    }
  }


  /** Plockar ut objektet med högsta prioritet ur trappan
    *@return objekt med högsta prioritet */
  public Object get(){
    if(last == 0) return null;
    Object temp = table[first].sak;
    table[first] = table[last--];
    int i=first;

    while((i+i)<=last)
    {
      if(i+i == last)
        if(table[i].priority>table[i+i].priority){
          swap(i,i+i);
          i = i+i;
          break;
        }
  
      if(table[i].priority>table[i+i].priority) {
        if(table[i+i].priority<table[i+i+1].priority){
           swap(i,i+i);
           i = i+i;
           continue;
        }
        else{
          swap(i,i+i+1);
          i=i+i+1;
          continue;
        }
      }
      break;
    }
    return temp;
  }


  private void swap(int i1, int i2){
    Node temp = table[i1];
    table[i1] = table[i2];
    table[i2] = temp;
  }
  

} // Heap
