//Copyright (C) 2000 Simon Gustafsson

import java.applet.*;
import java.awt.*;


/** En klass som hjälper till vid ritning av 3-dimmensionella saker 
  * <p>
  * OBS! Enbart drawTriangle(Triangle t) är 100% testad. Övriga metoder
  * borde fungera, men saknar skuggning. Har inte heller hunnit testa
  * alla metoder i praktiken.
  * @author Simon Gustafsson (www.simong.se) */
public class Grafik3D {

  private Graphics g;
  private Transformation t;
  private boolean doShades=false;
  private Point3D light;
  private int light_length;


  /** Måste anropas innan några ritoperationer utförs.
    *@param graphics Graphics-objekt för den yta man vill rita på.*/
  public void setGraphics(Graphics graphics){
    g = graphics;
  }


  /** Måste anropas innan några ritoperationer utförs.
    *@param trans Transformation-objekt som beskriver hur en 
    *3-dimmensionell punkt ser ut i 2D.*/
  public void setTransformation(Transformation trans){
    t=trans;
  }


  /** Ritar ut en triangel. 
    *@param t triangel.*/
  public void drawTriangle(Triangle t){
    if(doShades){ 
      Color c = t.getColor();
      Point3D n = t.points[Triangle.normal];

      //0219 för debuggningen
      //    drawLine(t.points[1],VA3D.mul(n,50.0/ VA3D.avstand( n, Point3D.nollvektor )));

      float k = (float)( 1.0/256*Math.abs( VA3D.punktProdukt(n,light) ) /
                         ( 1000 * light_length ) 
                       );   // obs! längd inte nödvändigtvis 1000 för normalen

      g.setColor( new Color(c.getRed()*k, 
                            c.getGreen()*k, 
                            c.getBlue()*k));}
    else {
      g.setColor(t.getColor());}
    fillPolygon(t.points, 3);
  }


  public void drawLine(Point3D r1, Point3D r2){
    g.setColor(Color.black);
    Point t1, t2;
    t1 = t.T(r1);
    t2 = t.T(r2);
    g.drawLine(t1.x, t1.y, t2.x, t2.y);
  }


  public void drawLine(int x1,int y1,int z1,int x2,int y2,int z2){
    g.setColor(Color.black);
    Point t1, t2;
    t1 = t.T( new Point3D(x1,y1,z1) );
    t2 = t.T( new Point3D(x2,y2,z2) );
    g.drawLine(t1.x, t1.y, t2.x, t2.y);
  }


  public void drawPolygon(Point3D[] points, int nPoints){
    if(points==null) return;
    int[] xPoints = new int[nPoints];
    int[] yPoints = new int[nPoints];
    Point temp = new Point();
    for(int i=0; i<nPoints; i++){
      if (points[i]==null)return;
      temp = t.T(points[i]);
      xPoints[i] = temp.x;
      yPoints[i] = temp.y;
    } // for
    g.drawPolygon(xPoints,yPoints,nPoints);
  }

  public void drawPolygon(int[] x, int[] y, int[] z, int nPoints){
    int[] xPoints = new int[nPoints];
    int[] yPoints = new int[nPoints];
    Point temp = new Point();
    for(int i=0; i<nPoints; i++){
      temp = t.T( new Point3D(x[i],y[i],z[i]) );
      xPoints[i] = temp.x;
      yPoints[i] = temp.y;
    } // for
    g.drawPolygon(xPoints,yPoints,nPoints);
  }


  public void drawPolyline(Point3D[] points, int nPoints){
    int[] xPoints = new int[nPoints];
    int[] yPoints = new int[nPoints];
    Point temp = new Point();
    for(int i=0; i<nPoints; i++){
      temp = t.T(points[i]);
      xPoints[i] = temp.x;
      yPoints[i] = temp.y;
    } // for
    g.drawPolyline(xPoints,yPoints,nPoints);
  }


  public void drawPolyline(int[] x, int[] y, int[] z, int nPoints){
    g.setColor(Color.black);
    int[] xPoints = new int[nPoints];
    int[] yPoints = new int[nPoints];
    Point temp = new Point();
    for(int i=0; i<nPoints; i++){
      temp = t.T( new Point3D(x[i],y[i],z[i]) );
      xPoints[i] = temp.x;
      yPoints[i] = temp.y;
    } // for
    g.drawPolyline(xPoints,yPoints,nPoints);
  }


  public void fillPolygon(Point3D[] points, int nPoints){
    int[] xPoints = new int[nPoints];
    int[] yPoints = new int[nPoints];
    Point temp = new Point();
    for(int i=0; i<nPoints; i++){
      temp = t.T(points[i]);
      xPoints[i] = temp.x;
      yPoints[i] = temp.y;
    } // for
    g.fillPolygon(xPoints,yPoints,nPoints);
  }


  public void fillPolygon(int[] x, int[] y, int[] z, int nPoints){
    int[] xPoints = new int[nPoints];
    int[] yPoints = new int[nPoints];
    Point temp = new Point();
    for(int i=0; i<nPoints; i++){
      temp = t.T( new Point3D(x[i],y[i],z[i]) );
      xPoints[i] = temp.x;
      yPoints[i] = temp.y;
    } // for
    g.fillPolygon(xPoints,yPoints,nPoints);
  }


  /** Slår av och på "skuggningen" */
  public void setShading(boolean state){
    doShades = state;
  }


  /** bestämmer hur skuggningen skall "se ut" */
  public void setShading(boolean state, Point3D lightSource){
    doShades = state;
    light = lightSource;
    light_length = VA3D.avstand(lightSource, Point3D.nollvektor);
  }


  public Grafik3D(){
    light = new Point3D(10,10,10);
    light_length = VA3D.avstand(light, Point3D.nollvektor);
  }


/* 
 * Kommande metoder?
 *
 * public void drawRect(int x,int y,int width,int height)
 * public void drawPolyline(int[] xPoints,int[] yPoints,int nPoints)
 * public void drawString(String str,int x,int y,int size)
 * public void fillRect(int x,int y,int width,int height)
 */

}
