/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Triangle
extends My3DThing {
    Point3D[] points = new Point3D[5];
    private Color color;
    static final int normal = 3;
    static final int mitt = 4;

    public Triangle() {
        for (int i = 0; i < 5; ++i) {
            this.points[i] = new Point3D(0, 0, 0);
        }
        this.color = new Color(128, 128, 128);
    }

    public Triangle(Triangle triangle) {
        for (int i = 0; i < 5; ++i) {
            this.points[i] = new Point3D(triangle.points[i]);
        }
        this.color = triangle.color;
    }

    @Override
    public Object clone() {
        return new Triangle(this);
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void scale(double d, double d2, double d3) {
        for (int i = 0; i < 5; ++i) {
            this.points[i].koord[0] = (int)((double)this.points[i].koord[0] * d);
            this.points[i].koord[1] = (int)((double)this.points[i].koord[1] * d2);
            this.points[i].koord[2] = (int)((double)this.points[i].koord[2] * d3);
        }
    }

    @Override
    public void translate(int n, int n2, int n3) {
        for (int i = 0; i < 5; ++i) {
            this.points[i].koord[0] = this.points[i].koord[0] + n;
            this.points[i].koord[1] = this.points[i].koord[1] + n2;
            this.points[i].koord[2] = this.points[i].koord[2] + n3;
        }
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.rotateX(d);
        this.rotateY(d2);
        this.rotateZ(d3);
    }

    @Override
    public void rotateX(double d) {
        for (int i = 0; i < 5; ++i) {
            this.points[i].rotateX(d);
        }
    }

    @Override
    public void rotateY(double d) {
        for (int i = 0; i < 5; ++i) {
            this.points[i].rotateY(d);
        }
    }

    @Override
    public void rotateZ(double d) {
        for (int i = 0; i < 5; ++i) {
            this.points[i].rotateZ(d);
        }
    }

    @Override
    public int getNumObjects() {
        if (this.points != null && this.points[0] != null && this.points[1] != null && this.points[2] != null) {
            return 1;
        }
        return 0;
    }

    public Triangle(MyParser myParser) throws Exception {
        if (!this.parse(myParser)) {
            throw new Exception("Inte en triangel");
        }
    }

    private Point3D getNormal() {
        Point3D point3D = VA3D.vektorProdukt(VA3D.sub(this.points[0], this.points[1]), VA3D.sub(this.points[2], this.points[1]));
        return VA3D.mul(point3D, 1000.0 / (double)VA3D.avstand(point3D, Point3D.nollvektor));
    }

    public String toString() {
        String string = "Triangle { ";
        for (int i = 0; i < 2; ++i) {
            string = string + this.points[i] + ", ";
        }
        return string + this.points[2] + " }";
    }

    @Override
    public boolean parse(MyParser myParser) throws Exception {
        Triangle triangle = new Triangle();
        My3DColor my3DColor = new My3DColor();
        try {
            if (!myParser.skip("Triangle")) {
                return false;
            }
            if (!myParser.skip('{')) {
                throw new Exception("{ saknas f\u00f6r Triangle.");
            }
            this.color = my3DColor.parse(myParser) ? my3DColor.color : new Color(128, 128, 128);
            for (int i = 0; i < 2; ++i) {
                if (!triangle.points[i].parse(myParser)) {
                    throw new Exception("Punkt saknas i Triangle");
                }
                if (myParser.skip(',')) continue;
                throw new Exception(", saknas i Triangle");
            }
            triangle.points[2].parse(myParser);
            if (!myParser.skip('}')) {
                throw new Exception("} saknas f\u00f6r Triangle.");
            }
        }
        catch (Exception exception) {
            throw new Exception(exception + " Ogiltig triangel");
        }
        this.points = triangle.points;
        this.correctPoints();
        return true;
    }

    @Override
    public void draw(Grafik3D grafik3D) {
        grafik3D.drawTriangle(this);
    }

    private Point3D getMidPoint() {
        return VA3D.mul(VA3D.add(VA3D.add(this.points[0], this.points[1]), this.points[2]), 0.3333333333333333);
    }

    private void correctPoints() {
        this.points[3] = this.getNormal();
        this.points[4] = this.getMidPoint();
    }

    @Override
    public int getZ() {
        return this.points[4].getZ();
    }

    public static void main(String[] stringArray) {
        String string;
        System.out.println("Test av Triangle.class");
        do {
            System.out.println("\nSkriv str\u00e4ng att parsa, tom str\u00e4ng avbryter:");
            string = Mio.GetLine();
            try {
                Triangle triangle = new Triangle(new MyParser(string));
                System.out.println("S\u00e5 h\u00e4r tolkade datorn det:\n" + triangle);
            }
            catch (Exception exception) {
                System.out.println("Det d\u00e4r var ingen triangel :" + exception);
            }
        } while (!string.equals(""));
    }
}

