/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class Grafik3D {
    private Graphics g;
    private Transformation t;
    private boolean doShades = false;
    private Point3D light = new Point3D(10, 10, 10);
    private int light_length = VA3D.avstand(this.light, Point3D.nollvektor);

    public void setGraphics(Graphics graphics) {
        this.g = graphics;
    }

    public void setTransformation(Transformation transformation) {
        this.t = transformation;
    }

    public void drawTriangle(Triangle triangle) {
        if (this.doShades) {
            Color color = triangle.getColor();
            Point3D point3D = triangle.points[3];
            float f = (float)(0.00390625 * (double)Math.abs(VA3D.punktProdukt(point3D, this.light)) / (double)(1000 * this.light_length));
            this.g.setColor(new Color((float)color.getRed() * f, (float)color.getGreen() * f, (float)color.getBlue() * f));
        } else {
            this.g.setColor(triangle.getColor());
        }
        this.fillPolygon(triangle.points, 3);
    }

    public void drawLine(Point3D point3D, Point3D point3D2) {
        this.g.setColor(Color.black);
        Point point = this.t.T(point3D);
        Point point2 = this.t.T(point3D2);
        this.g.drawLine(point.x, point.y, point2.x, point2.y);
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.setColor(Color.black);
        Point point = this.t.T(new Point3D(n, n2, n3));
        Point point2 = this.t.T(new Point3D(n4, n5, n6));
        this.g.drawLine(point.x, point.y, point2.x, point2.y);
    }

    public void drawPolygon(Point3D[] point3DArray, int n) {
        if (point3DArray == null) {
            return;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        Point point = new Point();
        for (int i = 0; i < n; ++i) {
            if (point3DArray[i] == null) {
                return;
            }
            point = this.t.T(point3DArray[i]);
            nArray[i] = point.x;
            nArray2[i] = point.y;
        }
        this.g.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        Point point = new Point();
        for (int i = 0; i < n; ++i) {
            point = this.t.T(new Point3D(nArray[i], nArray2[i], nArray3[i]));
            nArray4[i] = point.x;
            nArray5[i] = point.y;
        }
        this.g.drawPolygon(nArray4, nArray5, n);
    }

    public void drawPolyline(Point3D[] point3DArray, int n) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        Point point = new Point();
        for (int i = 0; i < n; ++i) {
            point = this.t.T(point3DArray[i]);
            nArray[i] = point.x;
            nArray2[i] = point.y;
        }
        this.g.drawPolyline(nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        this.g.setColor(Color.black);
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        Point point = new Point();
        for (int i = 0; i < n; ++i) {
            point = this.t.T(new Point3D(nArray[i], nArray2[i], nArray3[i]));
            nArray4[i] = point.x;
            nArray5[i] = point.y;
        }
        this.g.drawPolyline(nArray4, nArray5, n);
    }

    public void fillPolygon(Point3D[] point3DArray, int n) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        Point point = new Point();
        for (int i = 0; i < n; ++i) {
            point = this.t.T(point3DArray[i]);
            nArray[i] = point.x;
            nArray2[i] = point.y;
        }
        this.g.fillPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        Point point = new Point();
        for (int i = 0; i < n; ++i) {
            point = this.t.T(new Point3D(nArray[i], nArray2[i], nArray3[i]));
            nArray4[i] = point.x;
            nArray5[i] = point.y;
        }
        this.g.fillPolygon(nArray4, nArray5, n);
    }

    public void setShading(boolean bl) {
        this.doShades = bl;
    }

    public void setShading(boolean bl, Point3D point3D) {
        this.doShades = bl;
        this.light = point3D;
        this.light_length = VA3D.avstand(point3D, Point3D.nollvektor);
    }
}

