/*
 * Demo program to show use of MyV4L2 for video capture,
 * and of SDL for displaying video.
 *
 * The tutorial by Marius Andra at
 * http://cone3d.gamedev.net/cgi-bin/index.pl?page=tutorials/gfxsdl/tut1
 * was very usefull for getting SDL up and running.
 *
 *
 * Copyright (c) 2007 Simon Gustafsson (www.simong.se)
 */


#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>
#include "../../video/MyV4L2.hh"



void Slock(SDL_Surface *screen)
{
  if ( SDL_MUSTLOCK(screen) )
  {
    if ( SDL_LockSurface(screen) < 0 )
    {
      return;
    }
  }
}

void Sulock(SDL_Surface *screen)
{
  if ( SDL_MUSTLOCK(screen) )
  {
    SDL_UnlockSurface(screen);
  }
}

void DrawPixel(SDL_Surface *screen, int x, int y,
                                    Uint8 R, Uint8 G, Uint8 B)
{
  Uint32 color = SDL_MapRGB(screen->format, R, G, B);
  switch (screen->format->BytesPerPixel)
  {
    case 1: // Assuming 8-bpp
      {
        Uint8 *bufp;
        bufp = (Uint8 *)screen->pixels + y*screen->pitch + x;
        *bufp = color;
      }
      break;
    case 2: // Probably 15-bpp or 16-bpp
      {
        Uint16 *bufp;
        bufp = (Uint16 *)screen->pixels + y*screen->pitch/2 + x;
        *bufp = color;
      }
      break;
    case 3: // Slow 24-bpp mode, usually not used
      {
        Uint8 *bufp;
        bufp = (Uint8 *)screen->pixels + y*screen->pitch + x * 3;
        if(SDL_BYTEORDER == SDL_LIL_ENDIAN)
        {
          bufp[0] = color;
          bufp[1] = color >> 8;
          bufp[2] = color >> 16;
        } else {
          bufp[2] = color;
          bufp[1] = color >> 8;
          bufp[0] = color >> 16;
        }
      }
      break;
    case 4: // Probably 32-bpp
      {
        Uint32 *bufp;
        bufp = (Uint32 *)screen->pixels + y*screen->pitch/4 + x;
        *bufp = color;
      }
      break;
  }
}

void DrawScene(SDL_Surface *screen, char* cam_img=0, __u32 fourcc=0)
{
  Slock(screen);
  
  if(cam_img){

    switch(fourcc){
    case v4l2_fourcc('B','G','R','4'):

      if(screen->format->BytesPerPixel==4){
	/*
	//FIXME Driver may add arbitrarily padding to each line...
	  memcpy((void*) screen->pixels,
	  (void*) cam_img,
	  640*480*4);
	*/
	for(int y=0;y<480;y++){
	  memcpy((void*) ((Uint8*)screen->pixels + y*screen->pitch),
		 (void*) (cam_img + y*640*4),
		 640*4);
	}

	//FIXME Byte-ordering may vary, add 
	//checks for SDL_BYTEORDER == SDL_BIG_ENDIAN and SDL_LIL_ENDIAN.
      }else{
	for(int y=0;y<480;y++){
	  int yoffs=(y*640)<<2;
	  for(int x=0;x<640;x++){
	    DrawPixel(screen,x,y,
		      cam_img[(x<<2)+yoffs+1],
		      cam_img[(x<<2)+yoffs+2],
		      cam_img[(x<<2)+yoffs+3]);
	  }
	}
      }

	  
      break;
    case v4l2_fourcc('G','R','E','Y'):
      for(int y=0;y<480;y++){
	int yoffs=y*640;
	for(int x=0;x<640;x++){
	  DrawPixel(screen,x,y,
		    cam_img[x+yoffs],
		    cam_img[x+yoffs],
		    cam_img[x+yoffs]);
	  //FIXME Driver may add arbitrarily padding of each line...
	}
      }
      break;

    default:
      printf("UNHANDLED fourcc %c%c%c%c in input to DrawScene\n",
	     ((char*)&fourcc)[0],((char*)&fourcc)[1],
	     ((char*)&fourcc)[2],((char*)&fourcc)[3]);
      exit(1);
    }


  }else{ //if(cam_img){
    for(int x=0;x<640;x++){
      for(int y=0;y<480;y++){
	DrawPixel(screen, x,y,y/2,y/2,x/3);
      }
    }
  }
  Sulock(screen);
  //SDL_Flip(screen);
}

int main(int argc, char *argv[])
{

  if ( SDL_Init(SDL_INIT_AUDIO|SDL_INIT_VIDEO) < 0 )
  {
    printf("Unable to init SDL: %s\n", SDL_GetError());
    exit(1);
  }
  atexit(SDL_Quit);
  SDL_WM_SetCaption("v4l2-viewer", "v4l2-viewer");//Sets the window tile and icon name


  SDL_Surface *screen;
  screen=SDL_SetVideoMode(640,480,32,SDL_SWSURFACE|SDL_DOUBLEBUF);
  if ( screen == NULL )
  {
    printf("Unable to set 640x480 video: %s\n", SDL_GetError());
    exit(1);
  }
  int done=0;

  MyV4L2 cam("/dev/video", MyV4L2::IO_METHOD_MMAP, //MyV4L2::IO_METHOD_READ, 
	     //v4l2_fourcc('G','R','E','Y') );
	     //v4l2_fourcc('R','G','B','4') );
	     v4l2_fourcc('B','G','R','4') );
  cam.open_device();
  cam.set_input(1); //FIXME uggly, use command line parameter for this instead
  cam.show_inputs();
  cam.show_input();

  cam.show_enumerate_image_formats();
  cam.init_device();
  cam.start_capturing ();
  


  while(done == 0)
  {
    DrawScene(screen, (char*) cam.wait_read_frame(), cam.pixelformat);

    SDL_Event event;

    while ( SDL_PollEvent(&event) )
    {
      if ( event.type == SDL_QUIT )  {  done = 1;  }

      if ( event.type == SDL_KEYDOWN )
      {
	switch(event.key.keysym.sym){
	case SDLK_ESCAPE:
	  done=1;
	  break;
	case SDLK_LEFT:
	  break;
	case SDLK_RIGHT:
	  break;
	case SDLK_UP:
	  break;
	case SDLK_DOWN:
	  break;
	}
      }

      if(event.type == SDL_MOUSEBUTTONDOWN){
	printf("SDL_MOUSEBUTTONDOWN %d, %d\n", event.button.x, event.button.y);
	if(event.button.button==SDL_BUTTON_LEFT){
	  for(int dy=-5; dy<5; dy++){
	    for(int dx=-5; dx<5; dx++){
	      if( ((dx+event.button.x)>=0) &&
		  ((dx+event.button.x)<640) &&
		  ((dy+event.button.y)>=0) &&
		  ((dy+event.button.y)<480)){
		DrawPixel(screen, dx+event.button.x, dy+event.button.y,
			  255, 255, 255);
	      }
	    }
	  }
	}
      }//if(event.button.button==SDL_BUTTON_LEFT){

      int mx, my;
      Uint8 btn = SDL_GetMouseState(&mx, &my);
      if(btn&SDL_BUTTON(1)){
	printf("depressed at %d,%d\n", mx, my);
      }

    }
    SDL_Flip(screen);
  }

  cam.stop_capturing();
  cam.uninit_device();
  cam.close_device();

  return 0;
}
