#include <signal.h>

#ifndef CtrlC_HH
#define CtrlC_HH

/**
   Class, which intercepts Ctrl-C (the SIGINT signal), 
   and makes testing for it easy.

@code
// Example CtrlC usage
CtrlC ctrlc(3); //intercept Ctrl-C 3 times before calling
                           //previous SIGINT handler.
                           //Use 0 to never call previous SIGINT handler.
			   //Place outside main if it's needed globally

for(int i=0; i<INT_MAX; i++){
  sleep(1);
  if(ctrlc.pressed()){ break; }
}
@endcode

@author Simon Gustafsson (www.simong.se)
*/
class CtrlC{
private:
  static int _pressed;
  static int _maxtimes;
  static int _numtimes;
  static sighandler_t oldtrap;
  static void sigtrap(int signo);
public:
  /**
     Create Ctrl-C (SIGINT) catcher. Observe that it uses some
     static members, so never have more than one handler in place
     simultaneously.

     @param howmanytimes set to 0 to catch an infinite ammount 
     of SIGINT signals. Set to a higher value (n) to trap just 
     the first n signals, then let the previous handler catch 
     further signals.
   */
   CtrlC(int howmanytimes=0);
  ~CtrlC();
  /* 
     @returns 1 if ctrl-c pressed, othervise 0.
   */
  int pressed();
};

#endif

