#include "CtrlC.hh"
#include <iostream>

int CtrlC::_pressed=0;
int CtrlC::_numtimes=0;
int CtrlC::_maxtimes=0;
sighandler_t CtrlC::oldtrap;

void CtrlC::sigtrap(int signo){
  CtrlC::_pressed=1;
  CtrlC::_numtimes++;
  if(CtrlC::_maxtimes!=0){
    
    std::cerr << "SIGINT (Ctrl-C) intercepted "
	      << CtrlC::_numtimes << " times (maximally "
	      << (CtrlC::_maxtimes-CtrlC::_numtimes)
	      << " intercepts left)" << std::endl << std::flush;
    
    if( CtrlC::_numtimes >= CtrlC::_maxtimes){
      signal(SIGINT,CtrlC::oldtrap); //Restore signal handler
    }
  }
};

CtrlC::CtrlC(int howmanytimes){
  _maxtimes=howmanytimes;
  _numtimes=0;
  _pressed=0; 
  oldtrap=signal(SIGINT, &sigtrap); 
};
CtrlC::~CtrlC(){ 
  signal(SIGINT,oldtrap); 
};

int CtrlC::pressed(){ 
  return _pressed; 
};

